/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.coff.CoffSymbol;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxArray;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxBeginningOfBlock;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxDefault;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxEndOfStruct;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxFilename;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxFunction;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxSection;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxTagName;
import java.io.IOException;

final class CoffSymbolAuxFactory {
    CoffSymbolAuxFactory() {
    }

    static CoffSymbolAux read(BinaryReader reader, CoffSymbol symbol) throws IOException {
        if (symbol.getDerivedType(1) == 0 && symbol.getBasicType() == 0) {
            if (symbol.getStorageClass() == 103) {
                return new CoffSymbolAuxFilename(reader);
            }
            if (symbol.getStorageClass() == 3) {
                return new CoffSymbolAuxSection(reader);
            }
            if (symbol.getStorageClass() == 10 || symbol.getStorageClass() == 12 || symbol.getStorageClass() == 15) {
                return new CoffSymbolAuxTagName(reader);
            }
            if (symbol.getStorageClass() == 102) {
                return new CoffSymbolAuxEndOfStruct(reader);
            }
            if (symbol.getStorageClass() == 100) {
                return new CoffSymbolAuxBeginningOfBlock(reader);
            }
            if (symbol.getStorageClass() == 101) {
                return new CoffSymbolAuxFunction(reader);
            }
        }
        if (symbol.getDerivedType(1) == 2) {
            if (symbol.getStorageClass() == 2) {
                return new CoffSymbolAuxFunction(reader);
            }
            if (symbol.getStorageClass() == 3) {
                return new CoffSymbolAuxFunction(reader);
            }
        }
        if (symbol.getDerivedType(1) == 3) {
            switch (symbol.getStorageClass()) {
                case 1: 
                case 3: 
                case 8: 
                case 11: 
                case 13: {
                    return new CoffSymbolAuxArray(reader);
                }
            }
        }
        return new CoffSymbolAuxDefault(reader);
    }
}

