/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bean;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.util.bean.SetEquateDialog;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import java.util.Comparator;
import java.util.List;

public class SetEquateTableModel
extends GDynamicColumnTableModel<SetEquateDialog.EquateRowObject, Program> {
    private List<SetEquateDialog.EquateRowObject> data;
    private Program program;

    public SetEquateTableModel(ServiceProvider serviceProvider, List<SetEquateDialog.EquateRowObject> data, Program program) {
        super(serviceProvider);
        this.data = data;
        this.program = program;
    }

    public String getName() {
        return "Set Equate";
    }

    public List<SetEquateDialog.EquateRowObject> getModelData() {
        return this.data;
    }

    protected TableColumnDescriptor<SetEquateDialog.EquateRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new NameColumn(), 2, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new PathColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RefsColumn(), 1, false);
        return descriptor;
    }

    public Program getDataSource() {
        return this.program;
    }

    private class NameColumn
    extends AbstractDynamicTableColumn<SetEquateDialog.EquateRowObject, String, Object> {
        private Comparator<String> comparator;

        private NameColumn() {
            this.comparator = new CaseInsensitiveComparator();
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(SetEquateDialog.EquateRowObject rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getEntryName();
        }

        public int getColumnPreferredWidth() {
            return 280;
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }
    }

    private class PathColumn
    extends AbstractDynamicTableColumn<SetEquateDialog.EquateRowObject, String, Object> {
        private Comparator<String> comparator;

        private PathColumn() {
            this.comparator = new CaseInsensitiveComparator();
        }

        public String getColumnName() {
            return "Path";
        }

        public String getValue(SetEquateDialog.EquateRowObject rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getPath();
        }

        public int getColumnPreferredWidth() {
            return 310;
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }
    }

    private class RefsColumn
    extends AbstractDynamicTableColumn<SetEquateDialog.EquateRowObject, Integer, Object> {
        private RefsColumn() {
        }

        public String getColumnName() {
            return "# Refs";
        }

        public Integer getValue(SetEquateDialog.EquateRowObject rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getRefCount();
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    private class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

