/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.RefRepeatComment;
import ghidra.app.util.viewer.field.EolEnablement;
import ghidra.app.util.viewer.field.EolExtraCommentsOption;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AutomaticCommentFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RefRepeatCommentFieldLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class EolComments {
    private static final String POINTER_ARROW = "-> ";
    private CodeUnit codeUnit;
    private List<String> eols = new ArrayList<String>();
    private List<String> repeatables = new ArrayList<String>();
    private List<RefRepeatComment> refRepeatables = new ArrayList<RefRepeatComment>();
    private List<String> autos = new ArrayList<String>();
    private List<Reference> references = new ArrayList<Reference>();
    private boolean operandsShowReferences = false;
    private int maxDisplayComments;
    private EolExtraCommentsOption extraCommentsOption;

    public EolComments(CodeUnit cu, boolean operandsShowReferences, int maxDisplayComments, EolExtraCommentsOption extraCommentsOption) {
        this.codeUnit = cu;
        this.operandsShowReferences = operandsShowReferences;
        this.maxDisplayComments = maxDisplayComments;
        this.extraCommentsOption = extraCommentsOption;
        this.loadComments();
    }

    private void loadComments() {
        this.loadEols();
        this.loadRepeatables();
        this.loadRefRepeatables();
        this.loadAutos();
    }

    private int size() {
        int refRepeatablesSize = 0;
        for (RefRepeatComment item : this.refRepeatables) {
            refRepeatablesSize += item.getCommentLineCount();
        }
        return this.eols.size() + this.repeatables.size() + refRepeatablesSize + this.autos.size();
    }

    private int getAvailableSpace() {
        return this.maxDisplayComments - this.size();
    }

    private void loadEols() {
        List<String> comments = Arrays.asList(this.codeUnit.getCommentAsArray(0));
        this.addStrings(comments, this.eols);
    }

    private void loadRepeatables() {
        boolean hasOtherComments;
        boolean bl = hasOtherComments = !this.eols.isEmpty();
        if (!this.extraCommentsOption.isShowingRepeatables(hasOtherComments)) {
            return;
        }
        List<String> comments = Arrays.asList(this.codeUnit.getCommentAsArray(4));
        this.addStrings(comments, this.repeatables);
    }

    private void loadRefRepeatables() {
        boolean hasOtherComments;
        boolean bl = hasOtherComments = !this.eols.isEmpty() || !this.repeatables.isEmpty();
        if (!this.extraCommentsOption.isShowingRefRepeatables(hasOtherComments)) {
            return;
        }
        Collection<RefRepeatComment> refRepeatableComments = this.getRepeatableComments(true);
        this.addRefRepeatables(refRepeatableComments, this.refRepeatables);
    }

    private void loadAutos() {
        boolean hasOtherComments;
        boolean bl = hasOtherComments = !this.eols.isEmpty() || !this.repeatables.isEmpty() || !this.refRepeatables.isEmpty();
        if (!this.extraCommentsOption.isShowingAutoComments(hasOtherComments)) {
            return;
        }
        Collection<String> comments = this.getReferencePreviews();
        this.addStrings(comments, this.autos);
    }

    private void addRefRepeatables(Collection<RefRepeatComment> from, Collection<RefRepeatComment> to) {
        int space = this.getAvailableSpace();
        int total = 0;
        for (RefRepeatComment item : from) {
            to.add(item);
            if ((total += item.getCommentLineCount()) != space) continue;
            return;
        }
    }

    private void addStrings(Collection<String> from, Collection<String> to) {
        int space = this.getAvailableSpace();
        for (String item : from) {
            to.add(item);
            if (to.size() != space) continue;
            return;
        }
    }

    private void loadReferences() {
        if (!this.references.isEmpty()) {
            return;
        }
        int space = this.getAvailableSpace();
        int max = Math.min(100, space);
        Program program = this.codeUnit.getProgram();
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressSet addresses = new AddressSet(this.codeUnit.getMinAddress(), this.codeUnit.getMaxAddress());
        AddressIterator it = referenceManager.getReferenceSourceIterator((AddressSetView)addresses, true);
        while (it.hasNext() && this.references.size() < max) {
            Reference[] refs;
            Address fromAddress = it.next();
            for (Reference r : refs = referenceManager.getReferencesFrom(fromAddress)) {
                this.references.add(r);
            }
        }
        Collections.sort(this.references);
    }

    public boolean isShowingRepeatables() {
        return !this.repeatables.isEmpty();
    }

    public boolean isShowingRefRepeatables() {
        return !this.refRepeatables.isEmpty();
    }

    public boolean isShowingAutoComments() {
        return !this.autos.isEmpty();
    }

    private Collection<String> getReferencePreviews() {
        this.loadReferences();
        if (this.references.isEmpty()) {
            return this.getPreviewForNoReferences();
        }
        int space = this.getAvailableSpace();
        Program program = this.codeUnit.getProgram();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Reference reference : this.references) {
            if (set.size() >= space) break;
            if (!this.isValidReference(program, reference)) continue;
            this.createAutoCommentFromReference(set, program, reference);
        }
        return set;
    }

    private Collection<String> getPreviewForNoReferences() {
        HashSet<String> set = new HashSet<String>();
        String translatedString = this.getTranslatedString();
        if (translatedString != null) {
            set.add(translatedString);
            return set;
        }
        String pointerText = this.getUndefinedPointer(this.codeUnit);
        if (pointerText != null) {
            set.add(pointerText);
            return set;
        }
        return set;
    }

    private String getTranslatedString() {
        StringDataInstance sdi;
        Data data;
        CodeUnit codeUnit = this.codeUnit;
        if (codeUnit instanceof Data && StringDataInstance.isString((Data)(data = (Data)codeUnit)) && (sdi = StringDataInstance.getStringDataInstance((Data)data)).hasTranslatedValue()) {
            return sdi.getStringRepresentation(sdi.isShowTranslation());
        }
        return null;
    }

    private boolean isValidReference(Program program, Reference reference) {
        if (!reference.isMemoryReference()) {
            return false;
        }
        Address toAddress = reference.getToAddress();
        return this.isValidAddress(program, toAddress);
    }

    private void createAutoCommentFromReference(Set<String> results, Program program, Reference reference) {
        Address toAddress = reference.getToAddress();
        if (this.createFunctionCallPreview(results, reference, program, toAddress)) {
            return;
        }
        Data data = this.getData(program, toAddress);
        if (data == null) {
            return;
        }
        if (this.createIndirectDataReferencePreview(results, reference, program, toAddress, data)) {
            return;
        }
        this.handleDirectDataReferencePreview(results, toAddress, data);
    }

    private Data getData(Program program, Address toAddr) {
        Data data = program.getListing().getDataAt(toAddr);
        if (data == null) {
            data = program.getListing().getDataContaining(toAddr);
        }
        return data;
    }

    private void handleDirectDataReferencePreview(Set<String> set, Address address, Data data) {
        Scalar scalar;
        Object value = data.getValue();
        if (value instanceof Scalar && (scalar = (Scalar)value).getSignedValue() == 0L) {
            return;
        }
        String dataRepresentation = this.getDataValueRepresentation(address, data);
        if (!StringUtils.isBlank((CharSequence)dataRepresentation)) {
            set.add("= " + dataRepresentation);
        }
    }

    private String getDataValueRepresentation(Address dataAccessAddress, Data data) {
        if (this.extraCommentsOption.useAbbreviatedComments() && this.isOffcut(dataAccessAddress, (CodeUnit)data)) {
            return this.getOffcutString(dataAccessAddress, data);
        }
        return data.getDefaultValueRepresentation();
    }

    private boolean isOffcut(Address address, CodeUnit cu) {
        if (cu == null) {
            return false;
        }
        return !cu.getMinAddress().equals((Object)address);
    }

    private String getOffcutString(Address offcutAddress, Data data) {
        Address dataAddress = data.getMinAddress();
        int diff = (int)offcutAddress.subtract(dataAddress);
        DataType dt = data.getBaseDataType();
        return this.getOffcutString(data, dataAddress, diff, dt);
    }

    private String getOffcutString(Data data, Address dataAddress, int diff, DataType dt) {
        if (StringDataInstance.isString((Data)data)) {
            StringDataInstance string = StringDataInstance.getStringDataInstance((Data)data);
            string = string.getByteOffcut(diff);
            return string.getStringRepresentation();
        }
        if (!data.hasStringValue()) {
            return null;
        }
        int length = data.getLength();
        if (diff >= length) {
            return data.getDefaultValueRepresentation();
        }
        DumbMemBufferImpl mb = new DumbMemBufferImpl(data.getMemory(), dataAddress.add((long)diff));
        return dt.getRepresentation((MemBuffer)mb, (Settings)data, length - diff);
    }

    private boolean createIndirectDataReferencePreview(Set<String> set, Reference reference, Program program, Address toAddress, Data data) {
        RefType type = reference.getReferenceType();
        if (!type.isIndirect()) {
            return false;
        }
        if (this.createDefinedDataPointerPreview(set, program, reference, data)) {
            return true;
        }
        this.createUndefinedPointerPreview(set, program, toAddress, data);
        return true;
    }

    private boolean createDefinedDataPointerPreview(Set<String> set, Program program, Reference reference, Data data) {
        if (!data.isPointer()) {
            return false;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        ReferenceManager referenceManager = program.getReferenceManager();
        Reference pointerReference = referenceManager.getPrimaryReferenceFrom(reference.getToAddress(), 0);
        if (pointerReference != null) {
            Symbol symbol = symbolTable.getPrimarySymbol(pointerReference.getToAddress());
            if (this.operandIsShowingSymbolReference(symbol, reference)) {
                return true;
            }
            set.add(POINTER_ARROW + symbol.getName());
            return true;
        }
        Address address = (Address)data.getValue();
        if (address != null && address.getOffset() != 0L) {
            set.add(POINTER_ARROW + address);
        }
        return true;
    }

    private boolean operandIsShowingSymbolReference(Symbol symbol, Reference reference) {
        return this.operandsShowReferences && reference.getOperandIndex() != -1 && !symbol.isDynamic();
    }

    private void createUndefinedPointerPreview(Set<String> list, Program program, Address toAddress, Data data) {
        if (data.isDefined()) {
            return;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        PseudoDisassembler dis = new PseudoDisassembler(program);
        Address pointerAddress = dis.getIndirectAddr(toAddress);
        if (!this.isValidAddress(program, pointerAddress)) {
            return;
        }
        Symbol symbol = symbolTable.getPrimarySymbol(pointerAddress);
        if (symbol != null) {
            list.add(POINTER_ARROW + symbol.getName());
        } else {
            list.add(POINTER_ARROW + pointerAddress);
        }
    }

    private boolean createFunctionCallPreview(Set<String> set, Reference reference, Program program, Address toAddress) {
        String signature;
        if (this.extraCommentsOption.getAutoFunction() == EolEnablement.NEVER) {
            return false;
        }
        RefType type = reference.getReferenceType();
        if (!type.isFlow()) {
            return false;
        }
        if (type.isIndirect()) {
            return false;
        }
        if (type.isCall() && (signature = this.getFunctionSignature(program, toAddress)) != null) {
            set.add(signature);
        }
        return true;
    }

    private String getUndefinedPointer(CodeUnit cu) {
        if (!(cu instanceof Data)) {
            return null;
        }
        Data data = (Data)cu;
        DataType dataType = data.getDataType();
        if (!(dataType instanceof Undefined) && !(dataType instanceof DefaultDataType)) {
            return null;
        }
        Program program = cu.getProgram();
        if (this.isEntireMemorySpace(program)) {
            return null;
        }
        int align = program.getLanguage().getInstructionAlignment();
        Address codeUnitAddress = cu.getAddress();
        long codeUnitOffset = codeUnitAddress.getOffset();
        if (codeUnitOffset % (long)align != 0L) {
            return null;
        }
        return this.createPointerString(program, codeUnitAddress);
    }

    private String createPointerString(Program program, Address codeUnitAddress) {
        int pointerSize = program.getDefaultPointerSize();
        long offset = 0L;
        Memory memory = program.getMemory();
        try {
            Address potentialAddr;
            switch (pointerSize) {
                case 4: {
                    int addrInt = memory.getInt(codeUnitAddress);
                    offset = (long)addrInt & 0xFFFFFFFFL;
                    offset *= (long)codeUnitAddress.getAddressSpace().getAddressableUnitSize();
                    break;
                }
                case 8: {
                    offset = memory.getLong(codeUnitAddress);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (offset != 0L && memory.contains(potentialAddr = codeUnitAddress.getNewAddress(offset))) {
                return "?  ->  " + potentialAddr.toString();
            }
        }
        catch (AddressOutOfBoundsException | MemoryAccessException throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean isEntireMemorySpace(Program program) {
        Address min = program.getMinAddress();
        Address max = program.getMaxAddress();
        AddressSpace space = max.getAddressSpace();
        return min.getOffset() == 0L && max.equals((Object)space.getMaxAddress());
    }

    private String getFunctionSignature(Program program, Address a) {
        Function f = program.getFunctionManager().getFunctionAt(a);
        if (f != null) {
            return f.getPrototypeString(false, false);
        }
        return null;
    }

    private boolean isValidAddress(Program program, Address address) {
        if (address == null) {
            return false;
        }
        if (!program.getMemory().contains(address)) {
            return false;
        }
        long offset = address.getOffset();
        return offset != 0L && offset != -1L && offset != 65535L && offset != 255L;
    }

    private Collection<RefRepeatComment> getRepeatableComments(boolean showAll) {
        this.loadReferences();
        int space = this.getAvailableSpace();
        LinkedHashSet<RefRepeatComment> set = new LinkedHashSet<RefRepeatComment>();
        for (int i = 0; i < this.references.size() && set.size() < space; ++i) {
            Address address;
            Object[] comment;
            Reference reference = this.references.get(i);
            if (!showAll && !reference.isPrimary() || CollectionUtils.isBlank((Object[])(comment = this.getComment(address = reference.getToAddress())))) continue;
            set.add(new RefRepeatComment(address, (String[])comment));
        }
        return set;
    }

    private String[] getComment(Address address) {
        Program program = this.codeUnit.getProgram();
        Listing listing = program.getListing();
        String repeatable = listing.getComment(4, address);
        if (repeatable != null) {
            return StringUtilities.toLines((String)repeatable);
        }
        CodeUnit cu = listing.getCodeUnitAt(address);
        if (cu == null) {
            return null;
        }
        Function f = listing.getFunctionAt(address);
        if (f != null) {
            return f.getRepeatableCommentAsArray();
        }
        return cu.getCommentAsArray(4);
    }

    public List<String> getComments() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.eols);
        list.addAll(this.repeatables);
        for (RefRepeatComment comment : this.refRepeatables) {
            list.addAll(Arrays.asList(comment.getCommentLines()));
        }
        list.addAll(this.autos);
        return list;
    }

    private String[] getCommentsArray() {
        List<String> comments = this.getComments();
        return comments.toArray(new String[comments.size()]);
    }

    public List<String> getEOLComments() {
        return Collections.unmodifiableList(this.eols);
    }

    public List<String> getRepeatableComments() {
        return Collections.unmodifiableList(this.repeatables);
    }

    public List<RefRepeatComment> getReferencedRepeatableComments() {
        return Collections.unmodifiableList(this.refRepeatables);
    }

    public List<String> getAutomaticComment() {
        return Collections.unmodifiableList(this.autos);
    }

    public String toString() {
        StringBuilder buffy = new StringBuilder();
        if (this.eols.isEmpty()) {
            buffy.append("EOLs: ").append(this.eols);
        }
        if (!this.repeatables.isEmpty()) {
            buffy.append("My Repeatables: ").append(this.repeatables);
        }
        if (!this.refRepeatables.isEmpty()) {
            buffy.append("Ref Repeatables: ").append(this.refRepeatables);
        }
        if (!this.autos.isEmpty()) {
            buffy.append("My Automatic: ").append(this.autos);
        }
        return buffy.toString();
    }

    private int getEolRow(ProgramLocation loc) {
        int numBefore = 0;
        if (loc instanceof EolCommentFieldLocation) {
            EolCommentFieldLocation commentLoc = (EolCommentFieldLocation)loc;
            return numBefore + commentLoc.getCurrentCommentRow();
        }
        numBefore += this.eols.size();
        if (loc instanceof RepeatableCommentFieldLocation) {
            RepeatableCommentFieldLocation commentLoc = (RepeatableCommentFieldLocation)loc;
            return numBefore + commentLoc.getCurrentCommentRow();
        }
        numBefore += this.repeatables.size();
        if (loc instanceof RefRepeatCommentFieldLocation) {
            RefRepeatCommentFieldLocation commentLoc = (RefRepeatCommentFieldLocation)loc;
            Address desiredAddress = commentLoc.getReferencedRepeatableAddress();
            int startRowInRefRepeats = this.getCommentStartRow(desiredAddress);
            int rowInComment = this.hasRefRepeatComment(desiredAddress) ? commentLoc.getCurrentCommentRow() : 0;
            return numBefore + startRowInRefRepeats + rowInComment;
        }
        numBefore += this.refRepeatables.size();
        if (loc instanceof AutomaticCommentFieldLocation) {
            AutomaticCommentFieldLocation commentLoc = (AutomaticCommentFieldLocation)loc;
            return numBefore + commentLoc.getCurrentCommentRow();
        }
        return numBefore += this.autos.size();
    }

    private boolean hasRefRepeatComment(Address desiredAddress) {
        for (RefRepeatComment comment : this.refRepeatables) {
            Address checkAddress = comment.getAddress();
            if (!desiredAddress.equals((Object)checkAddress)) continue;
            return true;
        }
        return false;
    }

    public RowColLocation getRowCol(CommentFieldLocation cloc) {
        RefRepeatCommentFieldLocation commentLoc;
        Address desiredAddress;
        int offset = cloc.getCharOffset();
        if (cloc instanceof RefRepeatCommentFieldLocation && !this.hasRefRepeatComment(desiredAddress = (commentLoc = (RefRepeatCommentFieldLocation)cloc).getReferencedRepeatableAddress())) {
            offset = 0;
        }
        int eolRow = this.getEolRow((ProgramLocation)cloc);
        return new RowColLocation(eolRow, offset);
    }

    public ProgramLocation getLocation(int eolRow, int eolColumn) {
        int beforeRepeatable;
        if (eolRow < 0) {
            return null;
        }
        int numEol = this.eols.size();
        int numRepeatable = this.repeatables.size();
        int numRefRepeats = this.refRepeatables.size();
        int numAutomatic = this.autos.size();
        int beforeRefRepeats = beforeRepeatable = numEol;
        if (!this.repeatables.isEmpty()) {
            beforeRefRepeats += numRepeatable;
        }
        int beforeAutomatic = beforeRefRepeats;
        if (!this.refRepeatables.isEmpty()) {
            beforeAutomatic += numRefRepeats;
        }
        int numTotal = beforeAutomatic;
        if (!this.autos.isEmpty()) {
            numTotal += numAutomatic;
        }
        Program program = this.codeUnit.getProgram();
        Address minAddress = this.codeUnit.getMinAddress();
        int[] cpath = null;
        if (this.codeUnit instanceof Data) {
            cpath = ((Data)this.codeUnit).getComponentPath();
        }
        if (eolRow < beforeRepeatable) {
            return new EolCommentFieldLocation(program, minAddress, cpath, this.getCommentsArray(), eolRow, eolColumn, eolRow);
        }
        if (eolRow < beforeRefRepeats) {
            return new RepeatableCommentFieldLocation(program, minAddress, cpath, this.getCommentsArray(), eolRow, eolColumn, eolRow - beforeRepeatable);
        }
        if (eolRow < beforeAutomatic) {
            int rowInAllRefRepeats = eolRow - beforeRefRepeats;
            return new RefRepeatCommentFieldLocation(program, minAddress, cpath, this.getCommentsArray(), eolRow, eolColumn, this.getRefRepeatRow(rowInAllRefRepeats), this.getRefRepeatAddress(rowInAllRefRepeats));
        }
        if (eolRow < numTotal) {
            return new AutomaticCommentFieldLocation(program, minAddress, cpath, this.getCommentsArray(), eolRow, eolColumn, eolRow - beforeAutomatic);
        }
        return null;
    }

    private Address getRefRepeatAddress(int row) {
        int currentRow = 0;
        for (RefRepeatComment comment : this.refRepeatables) {
            int lineCount = comment.getCommentLineCount();
            if (row < currentRow + lineCount) {
                return comment.getAddress();
            }
            currentRow += lineCount;
        }
        return null;
    }

    private int getRefRepeatRow(int row) {
        int currentRow = 0;
        for (RefRepeatComment comment : this.refRepeatables) {
            int numRows = comment.getCommentLineCount();
            if (row < currentRow + numRows) {
                return row - currentRow;
            }
            currentRow += numRows;
        }
        return -1;
    }

    private int getCommentStartRow(Address address) {
        int currentRow = 0;
        for (RefRepeatComment comment : this.refRepeatables) {
            Address commentAddress = comment.getAddress();
            if (address.compareTo((Object)commentAddress) <= 0) {
                return currentRow;
            }
            currentRow += comment.getCommentLineCount();
        }
        return currentRow;
    }
}

