/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.VtAttributes;

public class VtLine {
    protected int cols;
    protected int len;
    protected char[] chars;
    protected boolean wrappedToNext;
    private VtAttributes[] cellAttrs;

    public VtLine(int cols) {
        this.reset(cols);
    }

    public char getChar(int x) {
        return this.chars[x];
    }

    public char[] getCharBuffer() {
        return this.chars;
    }

    public VtAttributes getCellAttrs(int x) {
        VtAttributes attrs = this.cellAttrs[x];
        if (attrs == null) {
            return VtAttributes.DEFAULTS;
        }
        return attrs;
    }

    public void putChar(int x, char c, VtAttributes attrs) {
        int oldLen = this.len;
        this.len = Math.max(this.len, x + 1);
        this.wrappedToNext = false;
        for (int i = oldLen; i < x; ++i) {
            this.chars[i] = 32;
            this.cellAttrs[i] = VtAttributes.DEFAULTS;
        }
        this.chars[x] = c;
        if (attrs != null) {
            this.cellAttrs[x] = attrs;
        }
    }

    public void resize(int cols) {
        this.cols = cols;
        if (cols <= this.chars.length) {
            return;
        }
        char[] newChars = new char[cols];
        VtAttributes[] newCellAttrs = new VtAttributes[cols];
        System.arraycopy(this.chars, 0, newChars, 0, Math.min(cols, this.chars.length));
        System.arraycopy(this.cellAttrs, 0, newCellAttrs, 0, Math.min(cols, this.cellAttrs.length));
        this.chars = newChars;
        this.cellAttrs = newCellAttrs;
    }

    public void reset(int cols) {
        this.cols = cols;
        this.len = 0;
        this.wrappedToNext = false;
        if (this.cols != cols || this.chars == null) {
            this.chars = new char[cols];
            this.cellAttrs = new VtAttributes[cols];
        }
    }

    public int length() {
        return Math.min(this.len, this.cols);
    }

    public int cols() {
        return this.cols;
    }

    public void clear() {
        this.len = 0;
        this.wrappedToNext = false;
    }

    public void clearToEnd(int x) {
        this.len = Math.min(this.len, x);
        this.wrappedToNext = false;
    }

    public void clearToStart(int x, VtAttributes attrs) {
        if (this.len <= x) {
            this.len = 0;
            this.wrappedToNext = false;
            return;
        }
        for (int i = 0; i <= x; ++i) {
            this.chars[i] = 32;
            this.cellAttrs[i] = attrs;
        }
    }

    public void delete(int start, int end) {
        if (this.len <= end) {
            this.len = Math.min(this.len, start);
            this.wrappedToNext = false;
            return;
        }
        int shift = end - start;
        this.len -= shift;
        for (int x = start; x < end; ++x) {
            this.chars[x] = this.chars[x + shift];
            this.cellAttrs[x] = this.cellAttrs[x + shift];
        }
    }

    public void erase(int start, int end, VtAttributes attrs) {
        if (this.len <= end) {
            this.len = Math.min(this.len, start);
            this.wrappedToNext = false;
            return;
        }
        for (int x = start; x < end; ++x) {
            this.chars[x] = 32;
            this.cellAttrs[x] = attrs;
        }
    }

    public void insert(int start, int n) {
        int x;
        int end = Math.min(this.cols, start + n);
        for (x = this.cols - 1; x >= end; --x) {
            this.chars[x] = this.chars[x - n];
            this.cellAttrs[x] = this.cellAttrs[x - n];
        }
        for (x = start; x < end; ++x) {
            this.chars[x] = 32;
        }
        this.len = Math.min(this.cols, this.len + n);
        this.wrappedToNext = false;
    }

    public void forEachRun(RunConsumer action) {
        int length = this.length();
        if (length == 0) {
            action.accept(VtAttributes.DEFAULTS, 0, 0);
        }
        int first = 0;
        VtAttributes attrs = this.getCellAttrs(0);
        for (int x = 1; x < length; ++x) {
            if (attrs.equals(this.getCellAttrs(x))) continue;
            action.accept(attrs, first, x);
            first = x;
            attrs = this.getCellAttrs(x);
        }
        action.accept(attrs, first, length);
    }

    public void gatherText(StringBuilder sb, int start, int end) {
        start = Math.max(0, Math.min(start, this.len));
        end = Math.max(0, Math.min(end, this.len));
        sb.append(this.chars, start, end - start);
    }

    public static boolean isWordChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
    }

    public int findWord(int x, boolean forward) {
        int step = forward ? 1 : -1;
        for (int i = x; i < this.len && i >= 0; i += step) {
            char ch = this.chars[i];
            if (VtLine.isWordChar(ch)) continue;
            if (forward) {
                return i;
            }
            return i + 1;
        }
        if (forward) {
            return this.len;
        }
        return 0;
    }

    public static interface RunConsumer {
        public void accept(VtAttributes var1, int var2, int var3);
    }
}

