/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.VtAttributes;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.app.plugin.core.terminal.vt.VtLine;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class VtBuffer {
    public static final int DEFAULT_ROWS = 25;
    public static final int DEFAULT_COLS = 80;
    protected static final int TAB_WIDTH = 8;
    protected int rows;
    protected int cols;
    protected int curX;
    protected int curY;
    protected int savedX;
    protected int savedY;
    protected int bottomY;
    protected int scrollStart;
    protected int scrollEnd;
    protected int maxScrollBack = 10000;
    protected VtAttributes curAttrs = VtAttributes.DEFAULTS;
    protected ArrayDeque<VtLine> scrollBack = new ArrayDeque();
    protected ArrayList<VtLine> lines = new ArrayList();

    public VtBuffer() {
        this(25, 80);
    }

    public VtBuffer(int rows, int cols) {
        this.rows = Math.max(1, rows);
        this.cols = Math.max(1, cols);
        this.scrollStart = 0;
        this.scrollEnd = rows;
        while (this.lines.size() < rows) {
            this.lines.add(new VtLine(cols));
        }
    }

    public void reset() {
        this.lines.clear();
        while (this.lines.size() < this.rows) {
            this.lines.add(new VtLine(this.cols));
        }
        this.curX = 0;
        this.curY = 0;
        this.scrollBack.clear();
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void putChar(char c) {
        if (c == '\u0000') {
            return;
        }
        this.checkVerticalScroll();
        this.lines.get(this.curY).putChar(this.curX, c, this.curAttrs);
    }

    public void tab() {
        int n = 8 + -this.curX % 8;
        this.moveCursorRight(n, false, false);
    }

    public void tabBack() {
        if (this.curX == 0) {
            return;
        }
        int n = (this.curX - 1) % 8 + 1;
        this.moveCursorLeft(n, false);
    }

    public void carriageReturn() {
        if (this.curX == 0) {
            return;
        }
        int prevY = this.curY - 1;
        if (prevY >= 0 && prevY < this.lines.size()) {
            this.lines.get((int)prevY).wrappedToNext = false;
        }
        this.curX = 0;
    }

    public void scrollViewportDown(boolean intoScrollBack) {
        VtLine temp;
        if (this.scrollStart == this.scrollEnd) {
            return;
        }
        if (intoScrollBack && this.scrollStart == 0 && this.maxScrollBack > 0) {
            temp = this.scrollBack.size() >= this.maxScrollBack ? this.scrollBack.remove() : null;
            this.scrollBack.add(this.lines.remove(0));
        } else {
            temp = this.lines.remove(this.scrollStart);
        }
        if (temp == null) {
            temp = new VtLine(this.cols);
        } else {
            temp.reset(this.cols);
        }
        this.lines.add(this.scrollEnd - 1, temp);
    }

    public void scrollViewportUp() {
        VtLine temp = this.lines.remove(this.scrollEnd - 1);
        temp.reset(this.cols);
        this.lines.add(this.scrollStart, temp);
    }

    public void checkVerticalScroll() {
        while (this.curY >= this.scrollEnd) {
            this.scrollViewportDown(true);
            this.curY = Math.max(0, this.curY - 1);
        }
    }

    public void moveCursorUp(int n) {
        this.curY = Math.max(0, this.curY - n);
    }

    public void moveCursorDown(int n, boolean dedupWrap) {
        int prevY = this.curY - 1;
        if (dedupWrap && n == 1 && prevY >= 0 && prevY < this.lines.size() && this.lines.get((int)prevY).wrappedToNext) {
            this.lines.get((int)prevY).wrappedToNext = false;
        } else {
            this.curY += n;
            this.bottomY = Math.max(this.bottomY, this.curY);
            this.checkVerticalScroll();
        }
    }

    public void moveCursorLeft(int n, boolean wrap) {
        int prevY = this.curY - 1;
        if (wrap && this.curX - n < 0 && prevY >= 0 && prevY < this.lines.size() && this.lines.get((int)prevY).wrappedToNext) {
            this.curX = this.cols - 1;
            --this.curY;
            this.lines.get((int)this.curY).wrappedToNext = false;
        }
        this.curX = Math.max(0, Math.min(this.curX - n, this.cols - 1));
    }

    public void moveCursorRight(int n, boolean wrap, boolean isCursorShowing) {
        if (wrap && this.curX + n >= this.cols) {
            this.checkVerticalScroll();
            this.curX = 0;
            this.lines.get((int)this.curY).wrappedToNext = true;
            ++this.curY;
            this.bottomY = Math.max(this.bottomY, this.curY);
            if (isCursorShowing) {
                this.checkVerticalScroll();
            }
        } else {
            this.curX = Math.max(0, Math.min(this.curX + n, this.cols - 1));
        }
    }

    public void saveCursorPos() {
        this.savedX = this.curX;
        this.savedY = this.curY;
    }

    public void restoreCursorPos() {
        this.curX = this.savedX;
        this.curY = this.savedY;
        this.bottomY = Math.max(this.bottomY, this.curY);
    }

    public void moveCursor(int row, int col) {
        this.curX = Math.max(0, Math.min(this.cols - 1, col));
        this.curY = Math.max(0, Math.min(this.rows - 1, row));
        this.bottomY = Math.max(this.bottomY, this.curY);
    }

    public VtAttributes getAttributes() {
        return this.curAttrs;
    }

    public void setAttributes(VtAttributes attributes) {
        this.curAttrs = attributes == null ? VtAttributes.DEFAULTS : attributes;
    }

    public void erase(VtHandler.Erasure erasure) {
        switch (erasure) {
            case TO_DISPLAY_END: {
                if (this.curY >= this.lines.size()) {
                    return;
                }
                for (int y = this.curY; y < this.rows; ++y) {
                    VtLine line = this.lines.get(y);
                    if (y == this.curY) {
                        line.clearToEnd(this.curX);
                        continue;
                    }
                    line.clear();
                }
                return;
            }
            case TO_DISPLAY_START: {
                for (int y = 0; y <= this.curY; ++y) {
                    VtLine line = this.lines.get(y);
                    if (y == this.curY) {
                        line.clearToStart(this.curX, this.curAttrs);
                        continue;
                    }
                    line.clear();
                }
                return;
            }
            case FULL_DISPLAY: {
                for (VtLine line : this.lines) {
                    line.clear();
                }
                return;
            }
            case FULL_DISPLAY_AND_SCROLLBACK: {
                for (VtLine line : this.lines) {
                    line.clear();
                }
                this.scrollBack.clear();
                return;
            }
            case TO_LINE_END: {
                if (this.curY >= this.lines.size()) {
                    return;
                }
                this.lines.get(this.curY).clearToEnd(this.curX);
                return;
            }
            case TO_LINE_START: {
                if (this.curY >= this.lines.size()) {
                    return;
                }
                this.lines.get(this.curY).clearToStart(this.curX, this.curAttrs);
                return;
            }
            case FULL_LINE: {
                if (this.curY >= this.lines.size()) {
                    return;
                }
                this.lines.get(this.curY).clear();
                return;
            }
        }
    }

    public void insertLines(int n) {
        for (int i = 0; i < n; ++i) {
            VtLine temp = this.lines.remove(this.scrollEnd - 1);
            temp.reset(this.cols);
            this.lines.add(this.curY, temp);
        }
    }

    public void deleteLines(int n) {
        for (int i = 0; i < n; ++i) {
            VtLine temp = this.lines.remove(this.curY);
            temp.reset(this.cols);
            this.lines.add(this.scrollEnd - 1, temp);
        }
    }

    public void insertChars(int n) {
        if (this.curY >= this.lines.size()) {
            return;
        }
        this.lines.get(this.curY).insert(this.curX, n);
    }

    public void deleteChars(int n) {
        if (this.curY >= this.lines.size()) {
            return;
        }
        this.lines.get(this.curY).delete(this.curX, this.curX + n);
    }

    public void eraseChars(int n) {
        if (this.curY >= this.lines.size()) {
            return;
        }
        this.lines.get(this.curY).erase(this.curX, this.curX + n, this.curAttrs);
    }

    public void setScrollViewport(Integer start, Integer end) {
        this.scrollStart = start != null ? Math.max(0, start) : 0;
        this.scrollEnd = end != null ? Math.max(this.scrollStart + 1, Math.min(this.rows, end + 1)) : this.rows;
    }

    public boolean resize(int cols, int rows) {
        cols = Math.max(1, cols);
        if (this.rows == (rows = Math.max(1, rows)) && this.cols == cols) {
            return false;
        }
        for (VtLine line : this.scrollBack) {
            line.resize(cols);
        }
        for (VtLine line : this.lines) {
            line.resize(cols);
        }
        this.rows = rows;
        this.cols = cols;
        this.scrollStart = 0;
        this.scrollEnd = rows;
        while (this.lines.size() < rows) {
            this.lines.add(0, this.scrollBack.isEmpty() ? new VtLine(cols) : this.scrollBack.pollLast());
            ++this.curY;
            ++this.savedY;
        }
        while (this.lines.size() > rows) {
            this.scrollBack.addLast(this.lines.remove(0));
            --this.curY;
            --this.savedY;
        }
        while (this.scrollBack.size() > this.maxScrollBack) {
            this.scrollBack.pollFirst();
        }
        this.curX = Math.min(this.curX, cols - 1);
        this.savedX = Math.min(this.savedX, cols - 1);
        this.curY = Math.max(0, Math.min(this.curY, rows - 1));
        this.savedY = Math.max(0, Math.min(this.savedY, rows - 1));
        return true;
    }

    public void setMaxScrollBack(int maxScrollBack) {
        this.maxScrollBack = maxScrollBack;
        while (this.scrollBack.size() > maxScrollBack) {
            this.scrollBack.pollFirst();
        }
    }

    public void forEachLine(boolean includeScrollBack, LineConsumer action) {
        int i = 0;
        if (includeScrollBack) {
            for (VtLine line : this.scrollBack) {
                action.accept(i, -1, line);
                ++i;
            }
        }
        int y = 0;
        for (VtLine line : this.lines) {
            action.accept(i, y, line);
            ++i;
            ++y;
        }
    }

    public int size() {
        return this.scrollBack.size() + this.rows;
    }

    public int getScrollBackSize() {
        return this.scrollBack.size();
    }

    public int getCurX() {
        return this.curX;
    }

    public int getCurY() {
        return this.curY;
    }

    protected boolean gatherLineText(StringBuilder sb, int startRow, int startCol, int endRow, int endCol, int i, VtLine line, CharSequence lineSep) {
        if (i < startRow) {
            return false;
        }
        if (i == startRow && startRow == endRow) {
            line.gatherText(sb, startCol, endCol);
            return true;
        }
        if (i == startRow) {
            line.gatherText(sb, startCol, this.cols);
            sb.append(lineSep);
            return false;
        }
        if (i == endRow) {
            line.gatherText(sb, 0, endCol);
            return true;
        }
        if (i > endRow) {
            return true;
        }
        line.gatherText(sb, 0, this.cols);
        sb.append(lineSep);
        return false;
    }

    public String getText(int startRow, int startCol, int endRow, int endCol, CharSequence lineSep) {
        int i;
        StringBuilder buf = new StringBuilder();
        int sbSize = this.scrollBack.size();
        if (startRow < sbSize) {
            i = 0;
            for (VtLine line : this.scrollBack) {
                if (this.gatherLineText(buf, startRow, startCol, endRow, endCol, i, line, lineSep)) break;
                ++i;
            }
        }
        for (i = Math.max(sbSize, startRow); i <= endRow; ++i) {
            VtLine line = this.lines.get(i - sbSize);
            this.gatherLineText(buf, startRow, startCol, endRow, endCol, i, line, lineSep);
        }
        return buf.toString();
    }

    public int resetBottomY() {
        int ret = this.bottomY;
        this.bottomY = this.curY;
        return ret;
    }

    public static interface LineConsumer {
        public void accept(int var1, int var2, VtLine var3);
    }
}

