/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import ghidra.app.plugin.core.terminal.DefaultTerminal;
import ghidra.app.plugin.core.terminal.TerminalProvider;
import ghidra.app.plugin.core.terminal.ThreadedTerminal;
import ghidra.app.plugin.core.terminal.vt.VtOutput;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.Terminal;
import ghidra.app.services.TerminalService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.STABLE, category="Common", packageName="Ghidra Core", description="Provides VT100 Terminal Emulation", shortDescription="VT100 Emulator", servicesProvided={TerminalService.class})
public class TerminalPlugin
extends Plugin
implements TerminalService {
    protected ClipboardService clipboardService;
    protected List<TerminalProvider> providers = new ArrayList<TerminalProvider>();

    public TerminalPlugin(PluginTool tool) {
        super(tool);
        this.clipboardService = (ClipboardService)tool.getService(ClipboardService.class);
    }

    @Override
    public void cleanTerminated() {
        Swing.runIfSwingOrRunLater(this::doCleanTerminated);
    }

    protected void doCleanTerminated() {
        for (TerminalProvider provider : List.copyOf(this.providers)) {
            if (!provider.isTerminated()) continue;
            provider.removeFromTool();
        }
    }

    public TerminalProvider createProvider(Charset charset, VtOutput outputCb) {
        return (TerminalProvider)((Object)Swing.runNow(() -> {
            this.cleanTerminated();
            TerminalProvider provider = new TerminalProvider(this, charset);
            provider.setOutputCallback(outputCb);
            provider.addToTool();
            provider.setVisible(true);
            this.providers.add(provider);
            provider.setClipboardService(this.clipboardService);
            provider.toFront();
            return provider;
        }));
    }

    @Override
    public Terminal createNullTerminal(Charset charset, VtOutput outputCb) {
        return new DefaultTerminal(this.createProvider(charset, outputCb));
    }

    @Override
    public Terminal createWithStreams(Charset charset, InputStream in, OutputStream out) {
        WritableByteChannel channel = Channels.newChannel(out);
        return new ThreadedTerminal(this.createProvider(charset, buf -> {
            while (buf.hasRemaining()) {
                try {
                    channel.write(buf);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Could not write terminal output: " + e));
                }
            }
        }), in);
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == ClipboardService.class) {
            this.clipboardService = (ClipboardService)service;
            for (TerminalProvider p : this.providers) {
                p.setClipboardService(this.clipboardService);
            }
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == ClipboardService.class) {
            for (TerminalProvider p : this.providers) {
                p.setClipboardService(null);
            }
        }
    }
}

