/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import ghidra.app.plugin.core.terminal.TerminalLayout;
import ghidra.app.plugin.core.terminal.TerminalLayoutModel;
import ghidra.app.plugin.core.terminal.TerminalPanel;
import ghidra.app.plugin.core.terminal.vt.VtLine;
import java.math.BigInteger;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TerminalFinder {
    protected final TerminalLayoutModel model;
    protected final FieldLocation cur;
    protected final boolean forward;
    protected final boolean caseSensitive;
    protected final boolean wrap;
    protected final boolean wholeWord;
    protected final StringBuilder sb = new StringBuilder();

    protected TerminalFinder(TerminalLayoutModel model, FieldLocation cur, boolean forward, Set<TerminalPanel.FindOptions> options) {
        this.model = model;
        if (cur != null) {
            this.cur = cur;
        } else if (forward) {
            this.cur = new FieldLocation();
        } else {
            BigInteger maxIndex = model.getNumIndexes().subtract(BigInteger.ONE);
            int maxChar = model.getLayout((BigInteger)maxIndex).line.length();
            this.cur = new FieldLocation(maxIndex, 0, 0, maxChar);
        }
        this.forward = forward;
        this.caseSensitive = options.contains((Object)TerminalPanel.FindOptions.CASE_SENSITIVE);
        this.wrap = options.contains((Object)TerminalPanel.FindOptions.WRAP);
        this.wholeWord = options.contains((Object)TerminalPanel.FindOptions.WHOLE_WORD);
    }

    protected void lowerBuf(StringBuilder sb) {
        for (int i = 0; i < sb.length(); ++i) {
            sb.setCharAt(i, Character.toLowerCase(sb.charAt(i)));
        }
    }

    protected boolean isWholeWord(int i, String match) {
        if (i > 0 && VtLine.isWordChar(this.sb.charAt(i - 1))) {
            return false;
        }
        int iAfter = i + match.length();
        return iAfter >= this.sb.length() || !VtLine.isWordChar(this.sb.charAt(iAfter));
    }

    protected abstract FieldRange findInLine(int var1, BigInteger var2);

    protected boolean continueIndex(BigInteger index, BigInteger end) {
        if (this.forward) {
            return index.compareTo(end) <= 0;
        }
        return index.compareTo(end) >= 0;
    }

    protected FieldRange findInIndices(BigInteger start, BigInteger end, BigInteger step) {
        BigInteger index = start;
        while (this.continueIndex(index, end)) {
            int s;
            FieldRange found;
            TerminalLayout layout = this.model.getLayout(index);
            VtLine line = layout.line;
            this.sb.delete(0, this.sb.length());
            line.gatherText(this.sb, 0, line.length());
            if (!this.caseSensitive) {
                this.lowerBuf(this.sb);
            }
            if ((found = this.findInLine(s = index.equals(this.cur.getIndex()) ? this.cur.getCol() : (this.forward ? 0 : line.length() - 1), index)) != null) {
                return found;
            }
            index = index.add(step);
        }
        return null;
    }

    public FieldRange find() {
        BigInteger step = this.forward ? BigInteger.ONE : BigInteger.ONE.negate();
        BigInteger maxIndex = this.model.getNumIndexes().subtract(BigInteger.ONE);
        FieldRange found = this.findInIndices(this.cur.getIndex(), this.forward ? maxIndex : BigInteger.ZERO, step);
        if (found != null) {
            return found;
        }
        if (!this.wrap) {
            return null;
        }
        return this.findInIndices(this.forward ? BigInteger.ZERO : maxIndex, this.cur.getIndex(), step);
    }

    public static class RegexTerminalFinder
    extends TerminalFinder {
        protected final Pattern pattern;

        public RegexTerminalFinder(TerminalLayoutModel model, FieldLocation cur, boolean forward, String pattern, Set<TerminalPanel.FindOptions> options) {
            super(model, cur, forward, options);
            if (pattern.isEmpty()) {
                throw new IllegalArgumentException("Empty pattern");
            }
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        protected FieldRange findInLine(int start, BigInteger index) {
            Matcher matcher = this.pattern.matcher(this.sb);
            int length = this.sb.length();
            if (length == 0) {
                return null;
            }
            start = Math.min(length - 1, start);
            if (this.forward) {
                int i = start;
                while (i < length && matcher.find(i)) {
                    if (!this.wholeWord || this.isWholeWord(i, matcher.group())) {
                        return new FieldRange(new FieldLocation(index, 0, 0, matcher.start()), new FieldLocation(index, 0, 0, matcher.end()));
                    }
                    i = matcher.start() + 1;
                }
                return null;
            }
            int lastStart = -1;
            int lastEnd = -1;
            int i = 0;
            while (i <= start && matcher.find(i)) {
                if (!this.wholeWord || this.isWholeWord(i, matcher.group())) {
                    if (matcher.start() > start) break;
                    lastStart = matcher.start();
                    lastEnd = matcher.end();
                }
                i = matcher.start() + 1;
            }
            if (lastStart == -1) {
                return null;
            }
            return new FieldRange(new FieldLocation(index, 0, 0, lastStart), new FieldLocation(index, 0, 0, lastEnd));
        }
    }

    public static class TextTerminalFinder
    extends TerminalFinder {
        protected final String text;

        public TextTerminalFinder(TerminalLayoutModel model, FieldLocation cur, boolean forward, String text, Set<TerminalPanel.FindOptions> options) {
            super(model, cur, forward, options);
            if (text.isEmpty()) {
                throw new IllegalArgumentException("Empty text");
            }
            this.text = text;
        }

        @Override
        protected FieldRange findInLine(int start, BigInteger index) {
            int step;
            int length = this.sb.length();
            int n = step = this.forward ? 1 : -1;
            for (int i = Math.min(start, length - 1); 0 <= i && i < length; i += step) {
                int n2 = i = this.forward ? this.sb.indexOf(this.text, i) : this.sb.lastIndexOf(this.text, i);
                if (i == -1) {
                    return null;
                }
                if (this.wholeWord && !this.isWholeWord(i, this.text)) continue;
                return new FieldRange(new FieldLocation(index, 0, 0, i), new FieldLocation(index, 0, 0, i + this.text.length()));
            }
            return null;
        }
    }
}

