/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.cmd.refs.SetExternalNameCmd;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.LibrarySymbolNode;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class SetExternalProgramAction
extends SymbolTreeContextAction {
    private static Icon EDIT_ICON = new GIcon("icon.plugin.symboltree.set.external");
    private final SymbolTreePlugin plugin;
    private SymbolTreeProvider provider;

    public SetExternalProgramAction(SymbolTreePlugin plugin, SymbolTreeProvider provider) {
        super("Set External Program", plugin.getName());
        this.plugin = plugin;
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Set External Program"}, EDIT_ICON, "0External"));
        this.setToolBarData(new ToolBarData(EDIT_ICON, null));
        this.setEnabled(false);
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        Object object;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        return selectionPaths.length == 1 && (object = selectionPaths[0].getLastPathComponent()) instanceof LibrarySymbolNode;
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return;
        }
        Object object = selectionPaths[0].getLastPathComponent();
        if (!(object instanceof LibrarySymbolNode)) {
            return;
        }
        LibrarySymbolNode libraryNode = (LibrarySymbolNode)((Object)object);
        String externalName = libraryNode.getName();
        Program program = this.plugin.getProgram();
        ExternalManager externalManager = program.getExternalManager();
        String externalLibraryPath = externalManager.getExternalLibraryPath(externalName);
        DataTreeDialog dialog = new DataTreeDialog(this.provider.getComponent(), "Choose External Program (" + externalName + ")", 0);
        dialog.setSearchText(externalName);
        dialog.addOkActionListener(e1 -> {
            DomainFile domainFile = dialog.getDomainFile();
            if (domainFile == null) {
                return;
            }
            String pathName = domainFile.toString();
            dialog.close();
            if (!pathName.equals(externalLibraryPath)) {
                SetExternalNameCmd cmd = new SetExternalNameCmd(externalName, domainFile.getPathname());
                this.plugin.getTool().execute((Command)cmd, (DomainObject)this.plugin.getProgram());
            }
        });
        dialog.setHelpLocation(new HelpLocation("SymbolTreePlugin", "ChooseExternalProgram"));
        if (externalLibraryPath != null) {
            SwingUtilities.invokeLater(() -> {
                Project project = AppInfo.getActiveProject();
                ProjectData pd = project.getProjectData();
                DomainFile domainFile = pd.getFile(externalLibraryPath);
                if (domainFile != null) {
                    dialog.selectDomainFile(domainFile);
                }
            });
        }
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

