/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;

public class LocationReferencesPanel
extends JPanel {
    private LocationReferencesProvider locationReferencesProvider;
    private GhidraThreadedTablePanel<LocationReference> tablePanel;
    private LocationReferencesTableModel tableModel;
    private GhidraTable table;

    LocationReferencesPanel(LocationReferencesProvider locationReferencesProvider) {
        this.locationReferencesProvider = locationReferencesProvider;
        this.buildPanel();
    }

    private void buildPanel() {
        this.tableModel = new LocationReferencesTableModel(this.locationReferencesProvider);
        this.tablePanel = new GhidraThreadedTablePanel<LocationReference>(this.tableModel, 250);
        this.table = this.tablePanel.getTable();
        this.table.setHTMLRenderingEnabled(true);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 120));
        this.table.setSelectionMode(2);
        this.setLayout(new BorderLayout(10, 10));
        PluginTool tool = this.locationReferencesProvider.getTool();
        this.table.installNavigation((ServiceProvider)tool);
        GhidraTableFilterPanel tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        this.add((Component)((Object)this.tablePanel), "Center");
        this.add((Component)((Object)tableFilterPanel), "South");
    }

    Collection<Address> getReferenceAddresses() {
        return this.tableModel.getReferenceAddresses();
    }

    GhidraTable getTable() {
        return this.table;
    }

    ProgramSelection getSelection() {
        return this.table.getProgramSelection();
    }

    void updateModel() {
        this.tableModel.reload();
    }

    void reloadModel() {
        this.tableModel.fullReload();
    }

    void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    boolean isInitialized() {
        return this.tableModel.isInitialized();
    }

    boolean selectRow(MouseEvent event) {
        return this.table.selectRow(event);
    }

    void dispose() {
        this.table.dispose();
    }
}

