/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DataTypeQueryService;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.parser.FunctionSignatureParser;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.util.exception.CancelledException;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractEditFunctionSignatureDialog
extends DialogComponentProvider {
    private static final String NONE_CHOICE = "-NONE-";
    private static int SIGNATURE_COLUMNS = 60;
    protected JLabel signatureLabel;
    protected JTextField signatureField;
    protected JComboBox<String> callingConventionComboBox;
    protected JComboBox<String> callFixupComboBox;
    protected JCheckBox inlineCheckBox;
    protected JCheckBox noReturnCheckBox;
    protected boolean allowInLine;
    protected boolean allowNoReturn;
    protected boolean allowCallFixup;
    protected PluginTool tool;
    boolean initialized = false;

    public AbstractEditFunctionSignatureDialog(PluginTool tool, String title, boolean allowInLine, boolean allowNoReturn, boolean allowCallFixup) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.allowInLine = allowInLine;
        this.allowNoReturn = allowNoReturn;
        this.allowCallFixup = allowCallFixup;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setRememberSize(true);
    }

    public JComponent getComponent() {
        this.setFunctionInfo();
        return super.getComponent();
    }

    protected abstract DataTypeManager getDataTypeManager();

    protected abstract FunctionSignature getFunctionSignature();

    protected abstract String getPrototypeString();

    protected abstract String getCallingConventionName();

    protected abstract List<String> getCallingConventionNames();

    protected boolean isInline() {
        return false;
    }

    protected boolean hasNoReturn() {
        return false;
    }

    protected abstract String getCallFixupName();

    protected abstract String[] getSupportedCallFixupNames();

    private void setFunctionInfo() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.signatureField.setText(this.getPrototypeString());
        this.setCallingConventionChoices();
        this.callingConventionComboBox.setSelectedItem(this.getCallingConventionName());
        if (this.allowInLine) {
            this.inlineCheckBox.setSelected(this.isInline());
        }
        if (this.allowNoReturn) {
            this.noReturnCheckBox.setSelected(this.hasNoReturn());
        }
        if (this.allowCallFixup) {
            this.setCallFixupChoices();
            String callFixupName = this.getCallFixupName();
            if (callFixupName != null) {
                this.callFixupComboBox.setSelectedItem(callFixupName);
            }
        }
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        mainPanel.add(this.buildSignaturePanel());
        mainPanel.add(this.buildAttributePanel());
        if (this.allowCallFixup) {
            JPanel callFixupPanel = this.buildCallFixupPanel();
            mainPanel.add(callFixupPanel != null ? callFixupPanel : this.buildSpacerPanel());
        }
        return mainPanel;
    }

    private JPanel buildSignaturePanel() {
        JPanel signaturePanel = new JPanel();
        signaturePanel.setLayout(new BoxLayout(signaturePanel, 0));
        this.signatureField = new JTextField(SIGNATURE_COLUMNS);
        this.signatureLabel = new GDLabel("Signature:");
        signaturePanel.add(this.signatureLabel);
        signaturePanel.add(this.signatureField);
        signaturePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return signaturePanel;
    }

    private Component buildSpacerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createVerticalStrut(20));
        return panel;
    }

    private JPanel buildAttributePanel() {
        JPanel attributePanel = new JPanel();
        attributePanel.setLayout(new BoxLayout(attributePanel, 0));
        attributePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.installCallingConventionWidget(attributePanel);
        if (this.allowInLine) {
            this.installInlineWidget(attributePanel);
        }
        if (this.allowNoReturn) {
            this.installNoReturnWidget(attributePanel);
        }
        attributePanel.add(Box.createGlue());
        return attributePanel;
    }

    private void installCallingConventionWidget(JPanel parentPanel) {
        this.callingConventionComboBox = new GhidraComboBox();
        parentPanel.add((Component)new GLabel("Calling Convention:"));
        parentPanel.add(this.callingConventionComboBox);
    }

    private void installInlineWidget(JPanel parentPanel) {
        this.inlineCheckBox = new GCheckBox("Inline");
        this.inlineCheckBox.addChangeListener(e -> {
            if (this.inlineCheckBox.isSelected() && this.callFixupComboBox != null) {
                this.callFixupComboBox.setSelectedItem(NONE_CHOICE);
            }
        });
        parentPanel.add(this.inlineCheckBox);
    }

    private void installNoReturnWidget(JPanel parentPanel) {
        this.noReturnCheckBox = new GCheckBox("No Return");
        parentPanel.add(this.noReturnCheckBox);
    }

    private JPanel buildCallFixupPanel() {
        JPanel callFixupPanel = new JPanel();
        callFixupPanel.setLayout(new BoxLayout(callFixupPanel, 0));
        this.callFixupComboBox = new GhidraComboBox();
        this.callFixupComboBox.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                return;
            }
            if (!NONE_CHOICE.equals(e.getItem())) {
                this.inlineCheckBox.setSelected(false);
            }
        });
        callFixupPanel.add((Component)new GLabel("Call-Fixup:"));
        callFixupPanel.add(this.callFixupComboBox);
        callFixupPanel.add(Box.createGlue());
        callFixupPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return callFixupPanel;
    }

    protected PluginTool getTool() {
        return this.tool;
    }

    private String getSignature() {
        return this.signatureField.getText();
    }

    private void setCallingConventionChoices() {
        String callingConventionName = this.getCallingConventionName();
        this.callingConventionComboBox.removeAllItems();
        for (String element : this.getCallingConventionNames()) {
            if (element.equals(callingConventionName)) {
                callingConventionName = null;
            }
            this.callingConventionComboBox.addItem(element);
        }
        if (callingConventionName != null) {
            this.callingConventionComboBox.addItem(callingConventionName);
        }
    }

    protected final String getCallingConvention() {
        String callingConvention = (String)this.callingConventionComboBox.getSelectedItem();
        if (callingConvention != null) {
            callingConvention = callingConvention.trim();
        }
        if (callingConvention.length() == 0 || "unknown".equals(callingConvention)) {
            callingConvention = null;
        }
        return callingConvention;
    }

    protected boolean isInlineSelected() {
        return this.inlineCheckBox != null ? this.inlineCheckBox.isSelected() : false;
    }

    protected boolean hasNoReturnSelected() {
        return this.noReturnCheckBox != null ? this.noReturnCheckBox.isSelected() : false;
    }

    private void setCallFixupChoices() {
        String[] callFixupNames = this.getSupportedCallFixupNames();
        this.callFixupComboBox.addItem(NONE_CHOICE);
        if (callFixupNames != null) {
            for (String element : callFixupNames) {
                this.callFixupComboBox.addItem(element);
            }
        }
    }

    protected String getCallFixupSelection() {
        String callFixup;
        if (this.callFixupComboBox != null && (callFixup = (String)this.callFixupComboBox.getSelectedItem()) != null && !NONE_CHOICE.equals(callFixup)) {
            return callFixup;
        }
        return null;
    }

    protected void okCallback() {
        try {
            if (this.applyChanges()) {
                this.close();
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    protected void cancelCallback() {
        this.setStatusText("");
        this.close();
    }

    protected abstract boolean applyChanges() throws CancelledException;

    protected final FunctionDefinitionDataType parseSignature() throws CancelledException {
        this.setFunctionInfo();
        FunctionSignatureParser parser = new FunctionSignatureParser(this.getDataTypeManager(), (DataTypeQueryService)this.tool.getService(DataTypeManagerService.class));
        try {
            return parser.parse(this.getFunctionSignature(), this.getSignature());
        }
        catch (ParseException e) {
            this.setStatusText("Invalid Signature: " + e.getMessage());
            return null;
        }
    }

    protected final boolean isSignatureChanged() {
        return !this.getSignature().equals(this.getPrototypeString());
    }

    protected final boolean isCallingConventionChanged() {
        String current = this.getCallingConventionName();
        return !Objects.equals(current, this.getCallingConvention());
    }

    protected void dialogShown() {
        this.signatureField.selectAll();
    }
}

