/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.exporter;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.help.AboutDomainObjectUtils;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.OptionValidator;
import ghidra.app.util.OptionsDialog;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExporterDialog
extends DialogComponentProvider
implements AddressFactoryService {
    private static final String XML_WARNING = "   Warning: XML is lossy and intended only for transfering data to external tools. GZF is the recommended format for saving and sharing program data.";
    private static final String SARIF_WARNING = "   Warning: SARIF is lossy and intended only for transfering data to external tools. GZF is the recommended format for saving and sharing program data.";
    private static String lastUsedExporterName = "Ghidra Zip File";
    private JButton optionsButton;
    private ProgramSelection currentSelection;
    private JCheckBox selectionCheckBox;
    private JTextField filePathTextField;
    private JButton fileChooserButton;
    private GhidraComboBox<Exporter> comboBox;
    private final DomainFile domainFile;
    private boolean domainObjectWasSupplied;
    private DomainObject domainObject;
    private List<Option> options;
    private PluginTool tool;
    private JLabel selectionOnlyLabel;

    public ExporterDialog(PluginTool tool, DomainFile domainFile) {
        this(tool, domainFile, null, null);
    }

    public ExporterDialog(PluginTool tool, DomainFile domainFile, DomainObject domainObject, ProgramSelection selection) {
        super("Export " + domainFile.getName());
        this.tool = tool;
        this.domainFile = domainFile;
        this.domainObject = domainObject;
        this.currentSelection = selection;
        if (domainObject != null) {
            this.domainObjectWasSupplied = true;
            domainObject.addConsumer((Object)this);
        } else {
            domainObject = this.getDomainObjectIfNeeded(TaskMonitor.DUMMY);
        }
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("ExporterPlugin", "Exporter_Dialog"));
        this.setTransient(true);
        this.selectedFormatChanged();
        this.validate();
    }

    public void close() {
        super.close();
        if (this.domainObject != null) {
            this.domainObject.release((Object)this);
        }
    }

    private boolean isFrontEndPlugin() {
        return this.tool.getService(FrontEndService.class) != null;
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildMainPanel());
        panel.add(this.buildButtonPanel());
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel innerPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        innerPanel.add(this.buildOptionsButton());
        panel.add(this.buildSelectionCheckboxPanel(), "West");
        panel.add((Component)innerPanel, "East");
        return panel;
    }

    private Component buildOptionsButton() {
        this.optionsButton = new JButton("Options...");
        this.optionsButton.addActionListener(e -> this.showOptions());
        return this.optionsButton;
    }

    private void showOptions() {
        OptionValidator validator = optionList -> {
            try {
                this.getSelectedExporter().setOptions(optionList);
                return null;
            }
            catch (OptionException e) {
                return e.getMessage();
            }
            catch (Exception e) {
                return "Unexpected exception validating options: " + e.getMessage();
            }
        };
        ExporterDialog svc = this.domainObject instanceof Program ? null : this;
        OptionsDialog optionsDialog = new OptionsDialog(this.options, validator, svc);
        optionsDialog.setHelpLocation(new HelpLocation("ExporterPlugin", this.getAnchorForSelectedFormat()));
        this.tool.showDialog((DialogComponentProvider)optionsDialog);
        if (!optionsDialog.wasCancelled()) {
            this.options = optionsDialog.getOptions();
        }
    }

    private String getAnchorForSelectedFormat() {
        Exporter selectedExporter = this.getSelectedExporter();
        String exporterName = selectedExporter.getName();
        return "Options_" + exporterName;
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel("Format: ", 4));
        panel.add(this.buildFormatChooser());
        panel.add((Component)new GLabel("Output File: ", 4));
        panel.add(this.buildFilePanel());
        return panel;
    }

    private Component buildSelectionCheckboxPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.selectionOnlyLabel = new GLabel("Selection Only:");
        if (!this.isFrontEndPlugin()) {
            this.selectionCheckBox = new GCheckBox("");
            this.updateSelectionCheckbox();
            panel.add(this.selectionOnlyLabel);
            panel.add(this.selectionCheckBox);
        }
        return panel;
    }

    private Component buildFilePanel() {
        this.filePathTextField = new JTextField();
        this.filePathTextField.setName("OUTPUT_FILE_TEXTFIELD");
        this.filePathTextField.setText(this.getFileName());
        this.filePathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExporterDialog.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExporterDialog.this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExporterDialog.this.validate();
            }
        });
        this.fileChooserButton = new BrowseButton();
        this.fileChooserButton.addActionListener(e -> this.chooseDestinationFile());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.filePathTextField, "Center");
        panel.add((Component)this.fileChooserButton, "East");
        return panel;
    }

    private String getFileName() {
        String name = this.domainFile.getName();
        File lastDir = this.getLastExportDirectory();
        return lastDir.getAbsolutePath() + File.separator + name;
    }

    private void chooseDestinationFile() {
        File file;
        String filePath;
        File currentFile;
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setSelectedFile(this.getLastExportDirectory());
        chooser.setTitle("Select Output File");
        chooser.setApproveButtonText("Select Output File");
        chooser.setApproveButtonToolTipText("Select File");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        Exporter exporter = this.getSelectedExporter();
        if (exporter != null && exporter.getDefaultFileExtension() != null) {
            chooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(exporter.getDefaultFileExtension(), exporter.getName()));
        }
        File file2 = currentFile = (filePath = this.filePathTextField.getText().trim()).isEmpty() ? null : new File(filePath);
        if (currentFile != null) {
            chooser.setSelectedFile(currentFile);
        }
        if ((file = chooser.getSelectedFile()) != null) {
            this.setLastExportDirectory(file);
            this.filePathTextField.setText(file.getAbsolutePath());
        }
        chooser.dispose();
    }

    private void setLastExportDirectory(File file) {
        Preferences.setProperty((String)"LastExportDirectory", (String)file.getParent());
        Preferences.store();
    }

    private File getLastExportDirectory() {
        String lastDirStr = Preferences.getProperty((String)"LastExportDirectory", (String)System.getProperty("user.home"), (boolean)true);
        return new File(lastDirStr);
    }

    private Component buildFormatChooser() {
        List<Exporter> exporters = this.getApplicableExporters(false);
        this.comboBox = new GhidraComboBox(exporters);
        Exporter defaultExporter = this.getDefaultExporter(exporters);
        if (defaultExporter != null) {
            this.comboBox.setSelectedItem((Object)defaultExporter);
        }
        this.comboBox.addItemListener(e -> this.selectedFormatChanged());
        return this.comboBox;
    }

    private List<Exporter> getApplicableExporters(boolean preliminaryCheck) {
        ArrayList<Exporter> list = new ArrayList<Exporter>(ClassSearcher.getInstances(Exporter.class));
        list.removeIf(exporter -> !this.canExport((Exporter)exporter, preliminaryCheck));
        Collections.sort(list, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return list;
    }

    private boolean canExport(Exporter exporter, boolean preliminaryCheck) {
        if (exporter.canExportDomainFile(this.domainFile)) {
            return true;
        }
        if (this.domainObject == null) {
            return preliminaryCheck ? exporter.canExportDomainObject(this.domainFile.getDomainObjectClass()) : false;
        }
        return exporter.canExportDomainObject(this.domainObject);
    }

    private Exporter getDefaultExporter(List<Exporter> list) {
        for (Exporter exporter : list) {
            if (!lastUsedExporterName.equals(exporter.getName())) continue;
            return exporter;
        }
        return list.isEmpty() ? null : list.get(0);
    }

    private void selectedFormatChanged() {
        Exporter selectedExporter = this.getSelectedExporter();
        if (selectedExporter != null) {
            this.options = selectedExporter.getOptions(() -> this.domainObject);
        }
        this.validate();
        this.updateSelectionCheckbox();
    }

    private void updateSelectionCheckbox() {
        if (this.selectionCheckBox != null) {
            boolean shouldEnableCheckbox = this.shouldEnableCheckbox();
            this.selectionCheckBox.setSelected(shouldEnableCheckbox);
            this.selectionCheckBox.setEnabled(shouldEnableCheckbox);
            this.selectionOnlyLabel.setEnabled(shouldEnableCheckbox);
        }
    }

    private boolean shouldEnableCheckbox() {
        if (this.currentSelection == null || this.currentSelection.isEmpty()) {
            return false;
        }
        Exporter selectedExporter = this.getSelectedExporter();
        return selectedExporter != null && selectedExporter.supportsAddressRestrictedExport();
    }

    private void validate() {
        this.setOkEnabled(false);
        this.optionsButton.setEnabled(this.hasOptions());
        this.setStatusText("");
        if (this.getSelectedExporter() == null) {
            this.setStatusText("Please select an exporter format.");
            return;
        }
        String fileToExportInto = this.filePathTextField.getText();
        if (fileToExportInto.length() == 0) {
            this.setStatusText("Please enter a destination file.");
            return;
        }
        File file = new File(fileToExportInto);
        if (file.isDirectory()) {
            this.setStatusText("The specified output file is a directory.");
            return;
        }
        if (file.exists() && !file.canWrite()) {
            this.setStatusText("The specified output file is read-only.");
            return;
        }
        if (this.getSelectedExporter().getName().contains("XML")) {
            this.setStatusText(XML_WARNING);
        }
        if (this.getSelectedExporter().getName().contains("SARIF")) {
            this.setStatusText(SARIF_WARNING);
        }
        this.setOkEnabled(true);
    }

    private boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    private Exporter getSelectedExporter() {
        return (Exporter)this.comboBox.getSelectedItem();
    }

    private File getSelectedOutputFile() {
        String filename = this.appendExporterFileExtension(this.filePathTextField.getText().trim());
        File outputFileName = new File(filename);
        if (outputFileName.getParent() == null) {
            File defaultParent = new File(System.getProperty("user.home"));
            outputFileName = new File(defaultParent, filename);
        }
        return outputFileName;
    }

    private String appendExporterFileExtension(String filename) {
        Exporter exporter = this.getSelectedExporter();
        Object extension = exporter.getDefaultFileExtension();
        if (((String)extension).isEmpty()) {
            return filename;
        }
        extension = "." + (String)extension;
        if (!filename.toLowerCase().endsWith(((String)extension).toLowerCase())) {
            return filename + (String)extension;
        }
        return filename;
    }

    protected void okCallback() {
        lastUsedExporterName = this.getSelectedExporter().getName();
        this.setLastExportDirectory(this.getSelectedOutputFile());
        if (this.doExport()) {
            this.close();
        }
    }

    private DomainObject getDomainObjectIfNeeded(TaskMonitor taskMonitor) {
        if (this.domainObject != null) {
            return this.domainObject;
        }
        boolean doOpen = false;
        for (Exporter exporter : this.getApplicableExporters(true)) {
            if (exporter.canExportDomainFile(this.domainFile)) continue;
            doOpen = true;
            break;
        }
        if (!doOpen) {
            return null;
        }
        if (SystemUtilities.isEventDispatchThread()) {
            TaskLauncher.launchModal((String)("Opening File: " + this.domainFile.getName()), monitor -> this.doOpenFile(monitor));
        } else {
            this.doOpenFile(taskMonitor);
        }
        return this.domainObject;
    }

    private void doOpenFile(TaskMonitor monitor) {
        try {
            this.domainObject = this.domainFile.isLinkFile() ? this.domainFile.getReadOnlyDomainObject((Object)this, -1, monitor) : this.domainFile.getImmutableDomainObject((Object)this, -1, monitor);
        }
        catch (VersionException e) {
            String msg = "Could not open file: " + this.domainFile.getName() + "\n\nAvailable export options will be limited.";
            msg = e.isUpgradable() ? msg + "\n\nA data upgrade is required.  You may open file\nin a tool first then Export if a different exporter\nis required." : msg + "\nFile was created with a newer version of Ghidra";
            Msg.showError((Object)this, (Component)this.getComponent(), (String)"Error Opening File", (Object)msg);
        }
        catch (IOException e) {
            String msg = "Could not open file: " + this.domainFile.getName() + "\n\nAvailable export options will be limited.";
            Msg.showError((Object)this, (Component)this.getComponent(), (String)"Error Opening File", (Object)msg, (Throwable)e);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    @Override
    public AddressFactory getAddressFactory() {
        DomainObject domainObject = this.domainObject;
        if (domainObject instanceof Program) {
            Program p = (Program)domainObject;
            return p.getAddressFactory();
        }
        return null;
    }

    private boolean doExport() {
        ExportTask task = new ExportTask();
        TaskLauncher.launch((Task)task);
        task.showResults();
        return task.getSuccess();
    }

    private ProgramSelection getApplicableProgramSeletion() {
        if (this.selectionCheckBox != null && this.selectionCheckBox.isSelected()) {
            return this.currentSelection;
        }
        return null;
    }

    private void displaySummaryResults(Exporter exporter) {
        File outputFile = this.getSelectedOutputFile();
        StringBuffer resultsBuffer = new StringBuffer();
        resultsBuffer.append("Destination file:       " + outputFile.getAbsolutePath() + "\n\n");
        resultsBuffer.append("Destination file Size:  " + outputFile.length() + "\n");
        resultsBuffer.append("Format:                 " + exporter.getName() + "\n\n");
        MessageLog log = exporter.getMessageLog();
        resultsBuffer.append(log.toString());
        HelpLocation helpLocation = new HelpLocation("About", "About_Program");
        Object tmpConsumer = new Object();
        if (this.domainObject != null) {
            this.domainObject.addConsumer(tmpConsumer);
        }
        Swing.runLater(() -> {
            try {
                Map metadata = this.domainObject != null ? this.domainObject.getMetadata() : this.domainFile.getMetadata();
                AboutDomainObjectUtils.displayInformation((PluginTool)this.tool, (DomainFile)this.domainFile, (Map)metadata, (String)"Export Results Summary", (String)resultsBuffer.toString(), (HelpLocation)helpLocation);
            }
            finally {
                if (this.domainObject != null) {
                    this.domainObject.release(tmpConsumer);
                }
            }
        });
    }

    JCheckBox getSelectionCheckBox() {
        return this.selectionCheckBox;
    }

    JComboBox<Exporter> getExporterComboBox() {
        return this.comboBox;
    }

    JTextField getOutputFileTextField() {
        return this.filePathTextField;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    private class ExportTask
    extends Task {
        private boolean success;
        private boolean showResults;
        private Exporter exporter;

        public ExportTask() {
            super("Export " + ExporterDialog.this.domainFile.getName(), true, true, true, false);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            boolean exportDomainFile;
            this.exporter = ExporterDialog.this.getSelectedExporter();
            this.exporter.setExporterServiceProvider((ServiceProvider)ExporterDialog.this.tool);
            boolean bl = exportDomainFile = !ExporterDialog.this.domainObjectWasSupplied && this.exporter.canExportDomainFile(ExporterDialog.this.domainFile);
            if (!exportDomainFile && ExporterDialog.this.domainFile == null) {
                return;
            }
            ProgramSelection selection = ExporterDialog.this.getApplicableProgramSeletion();
            File outputFile = ExporterDialog.this.getSelectedOutputFile();
            try {
                if (outputFile.exists() && OptionDialog.showOptionDialog((Component)ExporterDialog.this.getComponent(), (String)"Overwrite Existing File?", (String)("The file " + outputFile + " already exists.\nDo you want to overwrite it?"), (String)"Overwrite", (int)3) != 1) {
                    return;
                }
                if (ExporterDialog.this.options != null) {
                    this.exporter.setOptions(ExporterDialog.this.options);
                }
                this.success = !ExporterDialog.this.domainObjectWasSupplied && this.exporter.canExportDomainFile(ExporterDialog.this.domainFile) ? this.exporter.export(outputFile, ExporterDialog.this.domainFile, monitor) : this.exporter.export(outputFile, ExporterDialog.this.domainObject, selection, monitor);
                this.showResults = true;
            }
            catch (Exception e) {
                Msg.error((Object)((Object)this), (Object)"Exception exporting", (Throwable)e);
                SystemUtilities.runSwingLater(() -> ExporterDialog.this.setStatusText("Exception exporting: " + e.getMessage() + ".  If null, see log for details."));
            }
        }

        void showResults() {
            if (this.showResults) {
                ExporterDialog.this.displaySummaryResults(this.exporter);
            }
        }

        boolean getSuccess() {
            return this.success;
        }
    }
}

