/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.framework.Application;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTypeArchiveUtility {
    private static HashMap<String, String> archiveRemappings = new HashMap();
    public static final Map<String, ResourceFile> GHIDRA_ARCHIVES;
    private static final String RELATIVE_PATH_PREFIX = ".";

    private DataTypeArchiveUtility() {
    }

    public static String getRemappedArchiveName(String archiveName) {
        return archiveRemappings.get(archiveName);
    }

    public static ResourceFile findArchiveFile(String archiveName) {
        if (!((String)archiveName).endsWith(".gdt")) {
            archiveName = (String)archiveName + ".gdt";
        }
        if (((String)(archiveName = ((String)archiveName).replace('\\', '/'))).indexOf(58) >= 0 || ((String)archiveName).charAt(0) == '/') {
            return null;
        }
        archiveName = ((String)archiveName).startsWith(RELATIVE_PATH_PREFIX) ? ((String)archiveName).substring(RELATIVE_PATH_PREFIX.length()) : "/" + (String)archiveName;
        for (ResourceFile file : GHIDRA_ARCHIVES.values()) {
            String path = file.getAbsolutePath().replace('\\', '/');
            if (!path.endsWith((String)archiveName) || !file.exists()) continue;
            return file;
        }
        String remappedRelativePath = DataTypeArchiveUtility.getRemappedArchiveName(((String)archiveName).substring(1));
        if (remappedRelativePath != null) {
            return DataTypeArchiveUtility.findArchiveFile(remappedRelativePath);
        }
        return null;
    }

    public static List<String> getArchiveList(Program program) {
        ArrayList<String> list = new ArrayList<String>();
        Options props = program.getOptions("Program Information");
        String format = props.getString("Executable Format", "");
        int size = program.getAddressFactory().getDefaultAddressSpace().getSize();
        if (format.equals("Portable Executable (PE)") || format.equals("Common Object File Format (COFF)") && DataTypeArchiveUtility.isVisualStudio(program)) {
            if (size == 64) {
                list.add("windows_vs12_64");
            } else {
                list.add("windows_vs12_32");
            }
        } else if (format.equals("Mac OS X Mach-O")) {
            list.add("mac_osx");
        } else if (size == 64) {
            list.add("generic_clib_64");
        } else {
            list.add("generic_clib");
        }
        if (program.getCompiler().contains("rustc")) {
            list.add("rust-common");
        }
        return list;
    }

    private static boolean isVisualStudio(Program program) {
        return program.getMemory().getBlock(".drectve") != null || program.getMemory().getBlock(".debug$S") != null;
    }

    static {
        archiveRemappings.put("windows_vs12.gdt", "windows_vs12_32.gdt");
        archiveRemappings.put("windows_vs.gdt", "windows_vs12_32.gdt");
        archiveRemappings.put("windows_VS9.gdt", "windows_vs12_32.gdt");
        archiveRemappings.put("generic_C_lib.gdt", "generic_clib.gdt");
        GHIDRA_ARCHIVES = new HashMap<String, ResourceFile>();
        for (ResourceFile file : Application.findFilesByExtensionInApplication((String)".gdt")) {
            String name = file.getName();
            ResourceFile resourceFile = GHIDRA_ARCHIVES.get(name);
            if (resourceFile == null) {
                GHIDRA_ARCHIVES.put(file.getName(), file);
                continue;
            }
            Msg.showError(DataTypeManagerHandler.class, null, (String)"Duplicate Archive Name Error", (Object)("Duplicate datatype archive name detected and is not supported:\n  " + resourceFile.getAbsolutePath() + "\n  " + file.getAbsolutePath()));
        }
    }
}

