/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModelListener;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import utility.function.Callback;

abstract class CompositeViewerModel
extends AbstractTableModel
implements DataTypeManagerChangeListener {
    protected boolean updatingSelection = false;
    protected Composite originalComposite;
    protected DataTypePath originalDataTypePath;
    protected long originalCompositeId;
    protected Composite viewComposite;
    protected DataTypeManager viewDTM;
    private List<CompositeViewerModelListener> modelListeners = new ArrayList<CompositeViewerModelListener>();
    private String status = "";
    protected FieldSelection selection;
    protected String[] headers = new String[]{"Offset", "Length", "Mnemonic", "DataType", "FieldName", "Comment"};
    private static final int OFFSET = 0;
    private static final int LENGTH = 1;
    private static final int MNEMONIC = 2;
    private static final int DATATYPE = 3;
    private static final int NAME = 4;
    private static final int COMMENT = 5;
    protected int[] columnOffsets = new int[this.headers.length];
    protected int[] columnWidths = new int[]{75, 75, 100, 100, 100, 150};
    protected int width = 0;
    protected int leftMargin = 10;
    protected int row = -1;
    protected int column = -1;
    protected CompositeEditorProvider provider;
    protected boolean showHexNumbers = false;

    CompositeViewerModel(CompositeEditorProvider provider) {
        this.provider = provider;
        this.selection = new FieldSelection();
        this.adjustWidth();
        this.adjustOffsets();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.getDataTypeColumn()) {
            return DataTypeInstance.class;
        }
        return String.class;
    }

    public int getOffsetColumn() {
        return 0;
    }

    public int getLengthColumn() {
        return 1;
    }

    public int getMnemonicColumn() {
        return 2;
    }

    public int getDataTypeColumn() {
        return 3;
    }

    public int getNameColumn() {
        return 4;
    }

    public int getCommentColumn() {
        return 5;
    }

    protected List<TableColumn> getHiddenColumns() {
        return Collections.emptyList();
    }

    void dispose() {
        this.unload();
    }

    public boolean isLoaded() {
        return this.viewComposite != null;
    }

    abstract void load(Composite var1);

    void unload() {
        DataTypeManager originalDTM;
        DataTypeManager dataTypeManager = originalDTM = this.originalComposite != null ? this.originalComposite.getDataTypeManager() : null;
        if (originalDTM != null) {
            originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
            originalDTM = null;
        }
        this.originalComposite = null;
        this.originalCompositeId = -1L;
        this.viewComposite = null;
        this.originalDataTypePath = null;
        if (this.viewDTM != null) {
            this.viewDTM.close();
            this.viewDTM = null;
        }
    }

    DataType resolve(DataType dataType) {
        if (this.viewDTM == null) {
            return DataType.DEFAULT;
        }
        return this.viewDTM.resolve(dataType, null);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        if (this.updatingSelection) {
            return;
        }
        this.column = column;
    }

    protected void setLocation(int row, int column) {
        this.row = row;
        this.column = column;
    }

    protected Composite getOriginalComposite() {
        DataType dt;
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (this.originalDataTypePath != null && originalDTM != null && (dt = originalDTM.getDataType(this.originalDataTypePath)) instanceof Composite) {
            return (Composite)dt;
        }
        return this.originalComposite;
    }

    public final String getOriginalDataTypeName() {
        return this.originalDataTypePath != null ? this.originalDataTypePath.getDataTypeName() : "";
    }

    protected DataTypeManager getOriginalDataTypeManager() {
        return this.originalComposite != null ? this.originalComposite.getDataTypeManager() : null;
    }

    public final Category getOriginalCategory() {
        CategoryPath originalCategoryPath;
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (this.originalDataTypePath != null && originalDTM != null && originalDTM.containsCategory(originalCategoryPath = this.originalDataTypePath.getCategoryPath())) {
            return originalDTM.getCategory(originalCategoryPath);
        }
        return null;
    }

    public final CategoryPath getOriginalCategoryPath() {
        if (this.originalDataTypePath != null) {
            return this.originalDataTypePath.getCategoryPath();
        }
        return null;
    }

    public String getDescription() {
        String desc = null;
        if (this.viewComposite != null) {
            desc = this.viewComposite.getDescription();
        }
        return desc != null ? desc : "";
    }

    public int getLength() {
        if (this.viewComposite != null && !this.viewComposite.isZeroLength()) {
            return this.viewComposite.getLength();
        }
        return 0;
    }

    public String getLengthAsString() {
        int length = this.getLength();
        return this.showHexNumbers ? CompositeViewerModel.getHexString(length, true) : Integer.toString(length);
    }

    public String getCompositeName() {
        return this.viewComposite != null ? this.viewComposite.getDisplayName() : "";
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getFieldName(columnIndex);
    }

    public String getFieldName(int columnIndex) {
        if (columnIndex < 0) {
            return "UNKNOWN";
        }
        if (columnIndex < this.headers.length) {
            return this.headers[columnIndex];
        }
        List<TableColumn> hiddenColumns = this.getHiddenColumns();
        for (TableColumn c : hiddenColumns) {
            int modelIndex = c.getModelIndex();
            if (modelIndex != columnIndex) continue;
            return Objects.toString(c.getHeaderValue());
        }
        return "UNKNOWN";
    }

    boolean isEditTypeOfCell(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    int getFieldOffset(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.getColumnCount() ? 0 : this.columnOffsets[columnIndex];
    }

    int[] getFieldOffsets() {
        return this.columnOffsets;
    }

    protected void adjustOffsets() {
        int offset = this.leftMargin;
        int numCols = this.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            this.columnOffsets[i] = offset;
            offset += this.columnWidths[i];
        }
        this.width = offset;
    }

    private void adjustWidth() {
        int newWidth = this.leftMargin;
        int numCols = this.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            newWidth += this.columnWidths[i];
        }
        this.width = newWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFieldWidth(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.getColumnCount() ? 0 : this.columnWidths[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.viewComposite != null ? this.viewComposite.getNumComponents() : 0;
    }

    public int getNumComponents() {
        return this.viewComposite != null ? this.viewComposite.getNumComponents() : 0;
    }

    public DataTypeComponent getComponent(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getNumComponents()) {
            return this.viewComposite.getComponent(rowIndex);
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    public int getNumFields() {
        return this.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value;
        if (this.viewComposite == null || rowIndex >= this.viewComposite.getNumComponents() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            if (columnIndex == this.getDataTypeColumn()) {
                return null;
            }
            return "";
        }
        DataTypeComponent dtc = this.viewComposite.getComponent(rowIndex);
        if (columnIndex == this.getOffsetColumn()) {
            int offset = dtc.getOffset();
            value = this.showHexNumbers ? CompositeViewerModel.getHexString(offset, true) : Integer.toString(offset);
        } else if (columnIndex == this.getLengthColumn()) {
            int compLen = dtc.getLength();
            value = this.showHexNumbers ? CompositeViewerModel.getHexString(compLen, true) : Integer.toString(compLen);
        } else if (columnIndex == this.getMnemonicColumn()) {
            int dtLen;
            DataType dt = dtc.getDataType();
            value = dt.getMnemonic(dtc.getDefaultSettings());
            int compLen = dtc.getLength();
            int n = dtLen = dt.isZeroLength() ? 0 : dt.getLength();
            if (dtLen > compLen) {
                value = "TooBig: " + (String)value + " needs " + dtLen + " has " + compLen;
            }
        } else {
            if (columnIndex == this.getDataTypeColumn()) {
                DataType dt;
                int dtLen = (dt = dtc.getDataType()).getLength();
                return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)(dtLen > 0 ? dtLen : dtc.getLength()), (boolean)this.usesAlignedLengthComponents());
            }
            value = columnIndex == this.getNameColumn() ? dtc.getFieldName() : (columnIndex == this.getCommentColumn() ? dtc.getComment() : "UNKNOWN");
        }
        return value == null ? "" : value;
    }

    protected String getTypeName() {
        return "Composite Data Type";
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.setStatus(status, false);
    }

    public void setStatus(String status, boolean beep) {
        if (status == null) {
            status = "";
        }
        this.status = status;
        this.notify(this.modelListeners, listener -> listener.statusChanged(this.status, beep));
    }

    public void clearStatus() {
        if (this.status.length() == 0) {
            return;
        }
        this.status = "";
        this.setStatus(this.status, false);
    }

    protected void fixupOriginalPath(Composite composite) {
        String newName = composite.getName();
        CategoryPath newCatPath = composite.getCategoryPath();
        CategoryPath oldCatPath = this.viewComposite.getCategoryPath();
        DataTypePath newDtPath = new DataTypePath(newCatPath, composite.getName());
        DataTypePath oldDtPath = new DataTypePath(oldCatPath, this.viewComposite.getName());
        if (!oldCatPath.equals((Object)newCatPath)) {
            this.dataTypeMoved(this.viewDTM, oldDtPath, newDtPath);
        }
        if (!this.originalDataTypePath.getDataTypeName().equals(newName)) {
            this.dataTypeRenamed(this.viewDTM, oldDtPath, newDtPath);
        }
    }

    public void addCompositeViewerModelListener(CompositeViewerModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeCompositeViewerModelListener(CompositeViewerModelListener listener) {
        this.modelListeners.remove(listener);
    }

    protected void compositeInfoChanged() {
        this.notify(this.modelListeners, CompositeViewerModelListener::compositeInfoChanged);
    }

    protected void componentDataChanged() {
        this.notify(this.modelListeners, CompositeViewerModelListener::componentDataChanged);
    }

    public final DataTypePath getOriginalDataTypePath() {
        return this.originalDataTypePath;
    }

    public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
    }

    public void sourceArchiveAdded(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
    }

    public void sourceArchiveChanged(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
    }

    public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (this.originalDataTypePath.isAncestor(path)) {
            String msg = "\"" + this.originalDataTypePath.getDataTypeName() + "\" had its category \"" + path.getPath() + "\" removed.";
            this.setStatus(msg, true);
        } else if (this.hasSubDtInCategory(this.viewComposite, path.getPath())) {
            String msg = "The category \"" + path.getPath() + "\" was removed, which contained a sub-component of \"" + this.originalDataTypePath.getDataTypeName() + "\".";
            this.setStatus(msg, true);
        }
    }

    private void changeOriginalDataTypeCategory(CategoryPath oldPath, CategoryPath newPath) {
        String originalCategory = this.originalDataTypePath.getCategoryPath().getPath();
        String suffix = originalCategory.substring(oldPath.getPath().length());
        this.originalDataTypePath = new DataTypePath(newPath + suffix, this.originalDataTypePath.getDataTypeName());
    }

    public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (!this.viewDTM.containsCategory(oldPath)) {
            return;
        }
        Category oldCat = this.viewDTM.getCategory(oldPath);
        try {
            oldCat.setName(newPath.getName());
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvalidNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        if (this.originalDataTypePath.isAncestor(oldPath)) {
            this.changeOriginalDataTypeCategory(oldPath, newPath);
        }
        this.compositeInfoChanged();
    }

    public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (!this.viewDTM.containsCategory(oldPath)) {
            return;
        }
        Category oldCat = this.viewDTM.getCategory(oldPath);
        if (oldCat == null) {
            return;
        }
        CategoryPath parent = newPath.getParent();
        this.viewDTM.createCategory(parent);
        Category newCat = this.viewDTM.getCategory(parent);
        try {
            newCat.moveCategory(oldCat, TaskMonitor.DUMMY);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        if (this.originalDataTypePath.isAncestor(oldPath)) {
            this.changeOriginalDataTypeCategory(oldPath, newPath);
        }
        this.compositeInfoChanged();
    }

    public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
    }

    public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        DataType dataType = this.viewDTM.getDataType(path.getCategoryPath(), path.getDataTypeName());
        if (dataType == null) {
            return;
        }
        DataType baseDt = DataTypeHelper.getBaseType(dataType);
        DataTypePath dtPath = new DataTypePath(path.getCategoryPath(), baseDt.getName());
        if (!dtPath.equals((Object)this.originalDataTypePath)) {
            DataType dt = this.viewDTM.getDataType(dtPath);
            if (dt != null) {
                if (this.hasSubDt(this.viewComposite, dtPath)) {
                    String msg = "Removed sub-component data type \"" + dtPath;
                    this.setStatus(msg, true);
                }
                this.viewDTM.remove(dt, TaskMonitor.DUMMY);
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
        } else {
            if (!dataType.equals(baseDt)) {
                return;
            }
            String msg = "\"" + dtPath + "\" was removed from the data type manager.";
            this.setStatus(msg, true);
        }
    }

    public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        DataType dt = this.viewDTM.getDataType(oldPath);
        if (dt == null) {
            return;
        }
        try {
            dt.setName(newPath.getDataTypeName());
            this.fireTableDataChanged();
            this.componentDataChanged();
        }
        catch (InvalidNameException | DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        DataType dt = this.viewDTM.getDataType(oldPath);
        if (dt == null) {
            return;
        }
        Category newDtCat = this.viewDTM.createCategory(newPath.getCategoryPath());
        try {
            newDtCat.moveDataType(dt, null);
        }
        catch (DataTypeDependencyException e) {
            throw new AssertException((Throwable)e);
        }
        if (this.originalDataTypePath.getDataTypeName().equals(newPath.getDataTypeName()) && this.originalDataTypePath.getCategoryPath().equals((Object)oldPath.getCategoryPath())) {
            this.originalDataTypePath = newPath;
            this.compositeInfoChanged();
        } else {
            this.fireTableDataChanged();
            this.componentDataChanged();
        }
    }

    public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (this.isLoaded()) {
            if (this.originalCompositeId != -1L && path.equals((Object)this.originalDataTypePath)) {
                this.compositeInfoChanged();
            } else {
                CategoryPath cat = path.getCategoryPath();
                this.viewDTM.createCategory(cat);
                DataType dt = this.viewDTM.getDataType(path);
                if (dt == null) {
                    return;
                }
                if (originalDTM != this.viewDTM) {
                    DataType dataType = dtm.getDataType(path);
                    this.viewDTM.resolve(dataType, DataTypeConflictHandler.REPLACE_HANDLER);
                }
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
        }
    }

    public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (!this.isLoaded()) {
            return;
        }
        if (!oldPath.equals((Object)this.originalDataTypePath)) {
            DataType dt = this.viewDTM.getDataType(oldPath);
            if (dt != null) {
                if (this.hasSubDt(this.viewComposite, oldPath)) {
                    String msg = "Replaced sub-component data type \"" + oldPath.getPath();
                    this.setStatus(msg, true);
                }
                try {
                    this.viewDTM.replaceDataType(dt, newDataType, true);
                }
                catch (DataTypeDependencyException e) {
                    throw new AssertException((Throwable)e);
                }
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
        } else {
            this.load((Composite)newDataType);
        }
    }

    public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
    }

    boolean hasSubDtInCategory(Composite parentDt, String catPath) {
        DataTypeComponent[] components;
        for (DataTypeComponent component : components = parentDt.getDefinedComponents()) {
            DataType subDt = component.getDataType();
            String subCatPath = subDt.getCategoryPath().getPath();
            if (subCatPath.startsWith(catPath)) {
                return true;
            }
            if (!(subDt instanceof Composite) || !this.hasSubDtInCategory((Composite)subDt, catPath)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSubDt(Composite parentDt, DataTypePath dtPath) {
        DataTypeComponent[] components;
        for (DataTypeComponent component : components = parentDt.getDefinedComponents()) {
            DataType subDt = component.getDataType();
            String subDtPath = subDt.getPathName();
            if (subDtPath.equals(dtPath.getPath())) {
                return true;
            }
            if (!(subDt instanceof Composite) || !this.hasSubDt((Composite)subDt, dtPath)) continue;
            return true;
        }
        return false;
    }

    public FieldSelection getSelection() {
        return new FieldSelection(this.selection);
    }

    public boolean hasSelection() {
        return this.selection.getNumRanges() > 0;
    }

    public boolean hasComponentSelection() {
        return this.selection.getNumRanges() > 0 && this.selection.getFieldRange(0).getStart().getIndex().intValue() < this.getNumComponents();
    }

    public int getNumSelectedRows() {
        int count = 0;
        for (FieldRange range : this.selection) {
            int endIndex = range.getEnd().getIndex().intValue();
            int startIndex = range.getStart().getIndex().intValue();
            count += endIndex - startIndex;
        }
        return count;
    }

    public int getNumSelectedComponentRows() {
        int numComponents = this.getNumComponents();
        int count = 0;
        for (FieldRange range : this.selection) {
            int startIndex;
            int endIndex = Math.min(range.getEnd().getIndex().intValue(), numComponents);
            int rangeCount = endIndex - (startIndex = range.getStart().getIndex().intValue());
            if (rangeCount <= 0) continue;
            count += rangeCount;
        }
        return count;
    }

    public boolean isContiguousSelection() {
        return this.selection.getNumRanges() == 1;
    }

    public boolean isSingleComponentRowSelection() {
        if (!this.isSingleRowSelection()) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        int rowIndex = range.getStart().getIndex().intValue();
        return this.getComponent(rowIndex) != null;
    }

    public boolean isSingleRowSelection() {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        return range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1;
    }

    public boolean isContiguousComponentSelection() {
        return this.selection.getNumRanges() == 1 && this.selection.getFieldRange(0).getStart().getIndex().intValue() < this.getNumComponents();
    }

    public int[] getSelectedRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (FieldRange range : this.selection) {
            int startIndex;
            int endIndex = range.getEnd().getIndex().intValue();
            for (int i = startIndex = range.getStart().getIndex().intValue(); i < endIndex; ++i) {
                list.add(i);
            }
        }
        return list.stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] getSelectedComponentRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int numComponents = this.getNumComponents();
        for (FieldRange range : this.selection) {
            int startIndex;
            int endIndex = Math.min(range.getEnd().getIndex().intValue(), numComponents);
            for (int i = startIndex = range.getStart().getIndex().intValue(); i < endIndex; ++i) {
                list.add(i);
            }
        }
        return list.stream().mapToInt(Integer::intValue).toArray();
    }

    public FieldRange getSelectedRangeContaining(int rowIndex) {
        FieldRange fieldRange = null;
        if (this.selection.containsEntirely(BigInteger.valueOf(rowIndex))) {
            int numRanges = this.selection.getNumRanges();
            for (int i = 0; i < numRanges; ++i) {
                FieldRange range = this.selection.getFieldRange(i);
                if (range.getStart().getIndex().intValue() > rowIndex || rowIndex >= range.getEnd().getIndex().intValue()) continue;
                fieldRange = range;
                break;
            }
        }
        return fieldRange;
    }

    public int getMinIndexSelected() {
        if (!this.selection.isEmpty()) {
            FieldRange fieldRange = this.selection.getFieldRange(0);
            return fieldRange.getStart().getIndex().intValue();
        }
        return -1;
    }

    public void setSelection(int[] rows) {
        if (this.updatingSelection) {
            return;
        }
        FieldSelection tmpSelection = new FieldSelection();
        int numComponents = this.viewComposite.getNumComponents();
        for (int row2 : rows) {
            if (row2 >= numComponents) continue;
            tmpSelection.addRange(row2, row2 + 1);
        }
        if (this.selection.equals((Object)tmpSelection)) {
            return;
        }
        this.selection = tmpSelection;
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    public void setSelection(FieldSelection selection) {
        if (this.updatingSelection) {
            return;
        }
        if (this.selection.equals((Object)selection)) {
            return;
        }
        this.selection.clear();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = selection.getFieldRange(i);
            this.selection.addRange(range.getStart().getIndex(), range.getEnd().getIndex());
        }
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    protected void adjustSelection(int rowIndex, int adjustment) {
        FieldSelection newSelection = new FieldSelection();
        int num = this.selection.getNumRanges();
        for (int i = 0; i < num; ++i) {
            FieldRange range = this.selection.getFieldRange(i);
            int last = range.getEnd().getIndex().intValue() - 1;
            if (last < rowIndex) {
                newSelection.addRange(range.getStart().getIndex(), range.getEnd().getIndex());
                continue;
            }
            if (range.getStart().getIndex().intValue() >= rowIndex) {
                newSelection.addRange(range.getStart().getIndex().intValue() + adjustment, range.getEnd().getIndex().intValue() + adjustment);
                continue;
            }
            newSelection.addRange(range.getStart().getIndex().intValue(), rowIndex);
            newSelection.addRange(rowIndex + adjustment, range.getEnd().getIndex().intValue() + adjustment);
        }
        this.selection = newSelection;
    }

    protected void updatingSelection(Callback c) {
        this.swing(() -> {
            boolean tmpUpdatingSelection = this.updatingSelection;
            try {
                this.updatingSelection = true;
                c.call();
            }
            finally {
                this.updatingSelection = tmpUpdatingSelection;
            }
        });
    }

    protected void selectionChanged() {
        this.updatingSelection(() -> {
            for (CompositeViewerModelListener listener : this.modelListeners) {
                listener.selectionChanged();
            }
        });
    }

    protected void swing(Runnable r) {
        Swing.runIfSwingOrRunLater((Runnable)r);
    }

    protected <T> void notify(List<T> listeners, Consumer<T> method) {
        this.swing(() -> {
            for (Object listener : listeners) {
                method.accept(listener);
            }
        });
    }

    public void displayNumbersInHex(boolean showHex) {
        if (this.showHexNumbers != showHex) {
            this.showHexNumbers = showHex;
            this.fireTableDataChanged();
            this.compositeInfoChanged();
        }
    }

    public boolean isShowingNumbersInHex() {
        return this.showHexNumbers;
    }

    public static String getHexString(int offset, boolean showPrefix) {
        String prefix = showPrefix ? "0x" : "";
        return offset >= 0 ? prefix + Integer.toHexString(offset) : "-" + prefix + Integer.toHexString(-offset);
    }

    protected void adjustCurrentRow() {
        int currentRow = -1;
        if (this.selection.getNumRanges() > 0) {
            currentRow = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        }
        this.setRow(currentRow);
    }

    protected long getCompositeID() {
        return this.originalCompositeId;
    }

    protected boolean usesAlignedLengthComponents() {
        return this.viewComposite.isPackingEnabled();
    }

    public void programArchitectureChanged(DataTypeManager dataTypeManager) {
    }
}

