/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class FunctionSignatureListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final String NAME = "Function Signature Display";
    private static final String DESCRIPTION = "Toggle whether function signature is displayed in a tooltip when the mouse hovers over a function signature.";
    private static final int POPUP_PRIORITY = 20;

    public FunctionSignatureListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        Class<?> clazz = programLocation.getClass();
        if (clazz != FunctionSignatureFieldLocation.class && clazz != FunctionNameFieldLocation.class) {
            return null;
        }
        FunctionSignatureFieldLocation functionLocation = (FunctionSignatureFieldLocation)programLocation;
        Address entry = functionLocation.getFunctionAddress();
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(entry);
        String toolTipText = ToolTipUtils.getToolTipText(function, true);
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText(toolTipText);
        return toolTip;
    }
}

