/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class BookmarkDeleteBackgroundCmd
extends BackgroundCommand {
    private Bookmark[] bookmarks;

    public BookmarkDeleteBackgroundCmd(Bookmark[] bookmarks) {
        super("Delete Bookmarks", true, true, false);
        this.bookmarks = bookmarks;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        BookmarkManager mgr = ((Program)obj).getBookmarkManager();
        monitor.initialize((long)this.bookmarks.length);
        for (int i = 0; i < this.bookmarks.length; ++i) {
            if (monitor.isCancelled()) {
                return true;
            }
            Bookmark bm = this.bookmarks[i];
            mgr.removeBookmark(bm);
            monitor.setProgress((long)i);
        }
        return true;
    }
}

