/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.FieldPanelOverLayoutManager;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.listingpanel.ListingModelAdapter;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;

public abstract class AbstractPatchAction
extends DockingAction {
    protected static final String MENU_GROUP = "Disassembly";
    protected final PluginTool tool;
    private FieldPanelOverLayoutManager fieldLayoutManager;
    private CodeViewerProvider codeViewerProvider;
    private FieldPanel fieldPanel;
    private ListingPanel listingPanel;
    private Program program;
    private Address address;
    private CodeUnit codeUnit;
    private final KeyListener listenerForKeys = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            switch (e.getKeyCode()) {
                case 27: {
                    AbstractPatchAction.this.cancel();
                    e.consume();
                    break;
                }
                case 10: {
                    AbstractPatchAction.this.accept();
                    e.consume();
                }
            }
        }
    };
    private final FocusListener listenerForFocusLost = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            AbstractPatchAction.this.cancel();
        }
    };

    public AbstractPatchAction(Plugin owner, String name) {
        super(name, owner.getName());
        this.tool = owner.getTool();
    }

    protected void init() {
        this.addInputFocusListener(this.listenerForFocusLost);
        this.addInputKeyListener(this.listenerForKeys);
    }

    protected abstract void addInputFocusListener(FocusListener var1);

    protected abstract void addInputKeyListener(KeyListener var1);

    protected void addLayoutListeners(FieldPanelOverLayoutManager fieldLayoutManager) {
    }

    protected void removeLayoutListeners(FieldPanelOverLayoutManager fieldLayoutManager) {
    }

    protected abstract void setInputFont(Font var1);

    protected Program getProgram() {
        return this.program;
    }

    protected CodeUnit getCodeUnit() {
        return this.codeUnit;
    }

    protected Address getAddress() {
        return this.address;
    }

    public void dispose() {
        super.dispose();
        if (this.fieldLayoutManager != null) {
            this.fieldPanel.setLayout(null);
            this.fieldLayoutManager.unregister();
            this.removeLayoutListeners(this.fieldLayoutManager);
        }
    }

    private void prepareLayout(ListingActionContext context) {
        ComponentProvider contextProvider = context.getComponentProvider();
        if (this.codeViewerProvider == contextProvider) {
            return;
        }
        if (this.codeViewerProvider != null) {
            this.fieldPanel.setLayout(null);
            this.fieldLayoutManager.unregister();
            this.removeLayoutListeners(this.fieldLayoutManager);
        }
        this.codeViewerProvider = (CodeViewerProvider)contextProvider;
        this.listingPanel = this.codeViewerProvider.getListingPanel();
        this.fieldPanel = this.listingPanel.getFieldPanel();
        this.fieldLayoutManager = new FieldPanelOverLayoutManager(this.fieldPanel);
        this.addLayoutListeners(this.fieldLayoutManager);
        this.fieldPanel.setLayout((LayoutManager)this.fieldLayoutManager);
    }

    public abstract void accept();

    protected void hide() {
        this.fieldPanel.removeAll();
        this.fieldLayoutManager.layoutContainer((Container)this.fieldPanel);
        this.fieldPanel.requestFocusInWindow();
    }

    public void cancel() {
        this.hide();
    }

    protected FieldLocation findFieldLocation(Address address, String fieldName) {
        Layout layout = this.listingPanel.getLayout(address);
        ListingModelAdapter adapter = (ListingModelAdapter)this.fieldPanel.getLayoutModel();
        BigInteger index = adapter.getAddressIndexMap().getIndex(address);
        int count = layout.getNumFields();
        for (int i = 0; i < count; ++i) {
            ListingField field;
            Field f = layout.getField(i);
            if (!(f instanceof ListingField) || !(field = (ListingField)f).getFieldFactory().getFieldName().equals(fieldName)) continue;
            return new FieldLocation(index, i);
        }
        return null;
    }

    protected abstract boolean isApplicableToUnit(CodeUnit var1);

    public boolean isAddToPopup(ActionContext context) {
        CodeUnit cu = this.getCodeUnit(context);
        if (cu == null || !this.isApplicableToUnit(cu)) {
            return false;
        }
        ListingActionContext lac = (ListingActionContext)context;
        ComponentProvider provider = lac.getComponentProvider();
        if (!(provider instanceof CodeViewerProvider)) {
            return false;
        }
        CodeViewerProvider codeViewer = (CodeViewerProvider)provider;
        if (codeViewer.isReadOnly()) {
            return false;
        }
        Program program = lac.getProgram();
        if (program == null) {
            return false;
        }
        Address address = lac.getAddress();
        if (address == null) {
            return false;
        }
        MemoryBlock block = program.getMemory().getBlock(address);
        return block != null && block.isInitialized();
    }

    protected void prepare() {
    }

    protected abstract boolean showInputs(FieldPanel var1);

    protected abstract void fillInputs();

    protected CodeUnit getCodeUnit(ActionContext context) {
        if (!(context instanceof ListingActionContext)) {
            return null;
        }
        ListingActionContext lac = (ListingActionContext)context;
        ComponentProvider provider = lac.getComponentProvider();
        if (!(provider instanceof CodeViewerProvider)) {
            return null;
        }
        CodeViewerProvider codeViewProvider = (CodeViewerProvider)provider;
        if (codeViewProvider.isReadOnly()) {
            return null;
        }
        return lac.getCodeUnit();
    }

    public void actionPerformed(ActionContext context) {
        this.codeUnit = this.getCodeUnit(context);
        if (this.codeUnit == null || !this.isApplicableToUnit(this.codeUnit)) {
            return;
        }
        ListingActionContext lac = (ListingActionContext)context;
        this.prepareLayout(lac);
        ProgramLocation cur = lac.getLocation();
        this.program = cur.getProgram();
        this.address = cur.getAddress();
        if (this.address == null) {
            return;
        }
        MemoryBlock block = this.program.getMemory().getBlock(this.address);
        if (block == null || !block.isInitialized()) {
            return;
        }
        this.prepare();
        ToolOptions displayOptions = this.tool.getOptions("Listing Display");
        Font font = displayOptions.getFont("BASE FONT", null);
        if (font != null) {
            this.setInputFont(font);
        }
        this.fieldPanel.removeAll();
        if (!this.showInputs(this.fieldPanel)) {
            return;
        }
        this.fillInputs();
        this.fieldLayoutManager.layoutContainer((Container)this.fieldPanel);
    }
}

