/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import generic.json.Json;
import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledType;
import ghidra.program.model.symbol.SourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RustDemanglerParser {
    private static final char NULL_CHAR = '\u0000';
    private String mangledSource;
    private String demangledSource;

    public DemangledObject parse(String mangled, String demangled) throws RuntimeException {
        this.mangledSource = mangled;
        this.demangledSource = demangled;
        return this.parseNext(demangled);
    }

    private String removeBadSpaces(String text) {
        CondensedString condensedString = new CondensedString(text);
        return condensedString.getCondensedText();
    }

    private void setNameAndNamespace(DemangledObject object, String name) {
        List names = SymbolPathParser.parse((String)name, (boolean)false);
        DemangledType namespace = null;
        if (names.size() > 1) {
            namespace = this.convertToNamespaces(names.subList(0, names.size() - 1));
        }
        String objectName = (String)names.get(names.size() - 1);
        object.setName(objectName);
        object.setNamespace(namespace);
    }

    private DemangledObject parseNext(String demangled) {
        String nameString = this.removeBadSpaces(demangled).trim();
        DemangledFunction demangledFunction = new DemangledFunction(this.mangledSource, this.demangledSource, null);
        this.setNameAndNamespace(demangledFunction, nameString);
        demangledFunction.setSignatureSourceType(SourceType.DEFAULT);
        return demangledFunction;
    }

    private DemangledType convertToNamespaces(List<String> names) {
        DemangledType myNamespace;
        if (names.isEmpty()) {
            return null;
        }
        int index = names.size() - 1;
        String rawName = names.get(index);
        String escapedName = this.removeBadSpaces(rawName);
        DemangledType namespace = myNamespace = new DemangledType(this.mangledSource, this.demangledSource, escapedName);
        while (--index >= 0) {
            rawName = names.get(index);
            escapedName = this.removeBadSpaces(rawName);
            DemangledType parentNamespace = new DemangledType(this.mangledSource, this.demangledSource, escapedName);
            namespace.setNamespace(parentNamespace);
            namespace = parentNamespace;
        }
        return myNamespace;
    }

    private class CondensedString {
        private String sourceText;
        private String condensedText;
        private List<Part> parts = new ArrayList<Part>();

        CondensedString(String input) {
            this.sourceText = input;
            this.condensedText = this.convertGenericSpace(input);
        }

        private String convertGenericSpace(String name) {
            int depth = 0;
            char last = '\u0000';
            for (int i = 0; i < name.length(); ++i) {
                Part part = new Part();
                this.parts.add(part);
                char ch = name.charAt(i);
                part.condensed = part.original = Character.toString(ch);
                if (ch == '<' || ch == '(') {
                    ++depth;
                } else if ((ch == '>' || ch == ')') && depth != 0) {
                    --depth;
                }
                if (depth > 0 && ch == ' ') {
                    char next = i + 1 < name.length() ? name.charAt(i + 1) : (char)'\u0000';
                    part.condensed = this.isSurroundedByCharacters(last, next) ? "_" : "";
                }
                last = ch;
            }
            return this.parts.stream().map(p -> p.condensed).collect(Collectors.joining()).trim();
        }

        private boolean isSurroundedByCharacters(char last, char next) {
            if (last == '\u0000' || next == '\u0000') {
                return false;
            }
            return Character.isLetterOrDigit(last) && Character.isLetterOrDigit(next);
        }

        String getCondensedText() {
            return this.condensedText;
        }

        public String toString() {
            return Json.toString((Object)this);
        }

        private class Part {
            String original;
            String condensed = "";

            private Part() {
            }

            public String toString() {
                return Json.toString((Object)this);
            }
        }
    }
}

