/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefinedDataIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class RustStringAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Rust String Analyzer";
    private static final String DESCRIPTION = "Analyzer to split rust static strings into slices";

    public RustStringAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.LOW_PRIORITY);
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis(true);
    }

    @Override
    public boolean canAnalyze(Program program) {
        String name = program.getCompiler();
        return name.contains("rustc");
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        DefinedDataIterator dataIterator = DefinedDataIterator.definedStrings((Program)program);
        for (Data data : dataIterator) {
            Address start = data.getAddress();
            int length = data.getLength();
            RustStringAnalyzer.recurseString(program, start, length);
            monitor.checkCancelled();
        }
        return true;
    }

    @Override
    public void registerOptions(Options options, Program program) {
    }

    @Override
    public void optionsChanged(Options options, Program program) {
    }

    private static void recurseString(Program program, Address start, int maxLen) {
        int newLength = RustStringAnalyzer.getMaxStringLength(program, start, maxLen);
        if (newLength <= 0) {
            return;
        }
        ArrayDataType dt = new ArrayDataType((DataType)CharDataType.dataType, newLength, CharDataType.dataType.getLength());
        try {
            DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)0, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
            if (newLength < maxLen) {
                RustStringAnalyzer.recurseString(program, start.add((long)newLength), maxLen - newLength);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getMaxStringLength(Program program, Address address, int maxLen) {
        AddressIterator refIter = program.getReferenceManager().getReferenceDestinationIterator(address.next(), true);
        Address next = refIter.next();
        if (next == null) {
            return -1;
        }
        long len = -1L;
        try {
            len = next.subtract(address);
            if (len > (long)maxLen) {
                len = maxLen;
            }
            return (int)len;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (int)len;
        }
    }
}

