/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tool;

import docking.ComponentProvider;
import docking.action.DockingActionIf;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.tool.ListingMergePanelProvider;
import ghidra.app.merge.tool.ViewInstructionDetailsAction;
import ghidra.framework.main.ProgramaticUseOnly;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.util.ProgramLocation;

@PluginInfo(status=PluginStatus.STABLE, packageName="Ghidra Core", category="Testing", shortDescription="Listing Merge", description="Merge Panel for Listing", eventsConsumed={ProgramLocationPluginEvent.class})
public class ListingMergePanelPlugin
extends Plugin
implements ProgramaticUseOnly {
    private ListingMergePanelProvider provider;

    public ListingMergePanelPlugin(PluginTool tool, ListingMergePanel mergePanel) {
        super(tool);
        this.createProvider(mergePanel);
        this.firePluginEvent(new ProgramActivatedPluginEvent(this.getName(), mergePanel.getProgram(0)));
        this.createActions();
    }

    private void createActions() {
        ViewInstructionDetailsAction viewDetailsAction = new ViewInstructionDetailsAction(this);
        this.tool.addAction((DockingActionIf)viewDetailsAction);
    }

    public ComponentProvider getProvider() {
        return this.provider;
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
            this.firePluginEvent(new ProgramActivatedPluginEvent(this.getName(), null));
        }
    }

    public static String getDescription() {
        return "Listing Merge";
    }

    public static String getDescriptiveName() {
        return "Merge Panel for Listing";
    }

    public static String getCategory() {
        return "Test Unmanaged";
    }

    private void createProvider(ListingMergePanel mergePanel) {
        this.provider = new ListingMergePanelProvider(this.tool, this, this.getName(), mergePanel);
        this.tool.addComponentProvider((ComponentProvider)this.provider, false);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent evt = (ProgramLocationPluginEvent)event;
            ProgramLocation location = evt.getLocation();
            ListingMergePanel mergePanel = (ListingMergePanel)this.provider.getComponent();
            mergePanel.goTo(location, true);
        }
    }
}

