/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToolBarData;
import docking.menu.MultiActionDockingAction;
import docking.menu.MultipleActionDockingToolbarButton;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.ColorIcon3D;
import resources.icons.EmptyIcon;
import resources.icons.TranslateIcon;

public class SetVertexMostRecentColorAction
extends MultiActionDockingAction {
    private final FGController controller;
    private final FGVertex vertex;
    private Icon colorIcon;
    private DockingAction chooseColorAction;
    private DockingAction clearColorAction;

    SetVertexMostRecentColorAction(final FGController controller, FGVertex vertex) {
        super("Set Graph Vertex Color", FunctionGraphPlugin.class.getName());
        this.controller = controller;
        this.vertex = vertex;
        this.setDescription("Set this block's background color");
        this.colorIcon = new ColorIcon3D((Color)new GColor("color.bg.plugin.functiongraph.paint.icon"), 12, 12){

            public Color getColor() {
                return controller.getMostRecentColor();
            }
        };
        EmptyIcon blankIcon = new EmptyIcon(16, 16);
        MultiIcon multiIcon = new MultiIcon((Icon)blankIcon);
        GIcon paintBrushImage = new GIcon("icon.plugin.functiongraph.action.vertex.choose.color");
        Icon scaledBrush = ResourceManager.getScaledIcon((Icon)paintBrushImage, (int)16, (int)16);
        Point point = this.getLowerLeftIconOffset((Icon)blankIcon, this.colorIcon);
        TranslateIcon translateIcon = new TranslateIcon(this.colorIcon, point.x, point.y);
        multiIcon.addIcon((Icon)translateIcon);
        point = this.getRightIconOffset((Icon)blankIcon, scaledBrush);
        translateIcon = new TranslateIcon(scaledBrush, point.x, point.y);
        multiIcon.addIcon((Icon)translateIcon);
        this.colorIcon = multiIcon;
        this.setToolBarData(new ToolBarData(this.colorIcon));
        this.createActions();
    }

    Icon getToolbarIcon() {
        return this.colorIcon;
    }

    private void createActions() {
        this.chooseColorAction = new DockingAction("Set Vertex Color", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                Color oldColor;
                FGColorProvider colorProvider = SetVertexMostRecentColorAction.this.controller.getColorProvider();
                Color newColor = colorProvider.getColorFromUser(oldColor = SetVertexMostRecentColorAction.this.vertex.getBackgroundColor());
                if (newColor == null) {
                    return;
                }
                if (oldColor.equals(newColor)) {
                    return;
                }
                colorProvider.setVertexColor(SetVertexMostRecentColorAction.this.vertex, newColor);
            }
        };
        GIcon imageIcon = new GIcon("icon.plugin.functiongraph.action.vertex.choose.color.palette");
        this.chooseColorAction.setMenuBarData(new MenuData(new String[]{"Choose New Color"}, (Icon)imageIcon));
        this.chooseColorAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Color"));
        this.clearColorAction = new DockingAction("Clear Vertex Color", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                FGColorProvider colorProvider = SetVertexMostRecentColorAction.this.controller.getColorProvider();
                colorProvider.clearVertexColor(SetVertexMostRecentColorAction.this.vertex);
            }
        };
        this.clearColorAction.setMenuBarData(new MenuData(new String[]{"Clear Background Color"}));
        this.clearColorAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Color"));
    }

    public void dispose() {
        super.dispose();
        this.chooseColorAction.dispose();
        this.clearColorAction.dispose();
    }

    private Point getLowerLeftIconOffset(Icon primaryIcon, Icon overlayIcon) {
        int primaryHeight = primaryIcon.getIconHeight();
        int overlayHeight = overlayIcon.getIconHeight();
        return new Point(0, primaryHeight - overlayHeight);
    }

    private Point getRightIconOffset(Icon primaryIcon, Icon overlayIcon) {
        int primaryWidth = primaryIcon.getIconWidth();
        int overlayWidth = overlayIcon.getIconWidth();
        return new Point(primaryWidth - overlayWidth, 0);
    }

    public void actionPerformed(ActionContext context) {
        FGColorProvider colorProvider = this.controller.getColorProvider();
        colorProvider.setVertexColor(this.vertex, colorProvider.getMostRecentColor());
    }

    public List<DockingActionIf> getActionList(ActionContext context) {
        ArrayList<DockingActionIf> actionList = new ArrayList<DockingActionIf>();
        List<Color> recentColors = this.controller.getRecentColors();
        for (Color color : recentColors) {
            actionList.add((DockingActionIf)new SetVertexColorAction(this.vertex, color));
        }
        actionList.add(SetVertexMostRecentColorAction.createSeparator());
        actionList.add((DockingActionIf)this.chooseColorAction);
        actionList.add((DockingActionIf)this.clearColorAction);
        return actionList;
    }

    public JButton doCreateButton() {
        return new MultipleActionDockingToolbarButton((MultiActionDockingActionIf)this){

            public void setIcon(Icon icon) {
                super.setIcon(SetVertexMostRecentColorAction.this.colorIcon);
            }

            public Point getLocationOnScreen() {
                if (SetVertexMostRecentColorAction.this.vertex.isFullScreenMode()) {
                    return super.getLocationOnScreen();
                }
                Point buttonPointInVertexComponent = this.getButtonLocationInGraphComponentPanel();
                Point vertexViewLocation = SetVertexMostRecentColorAction.this.controller.getViewerPointFromVertexPoint(SetVertexMostRecentColorAction.this.vertex, buttonPointInVertexComponent);
                Container vertexParent = SetVertexMostRecentColorAction.this.vertex.getComponent().getParent();
                Point point = new Point(vertexViewLocation.x, vertexViewLocation.y);
                SwingUtilities.convertPointToScreen(point, vertexParent);
                return point;
            }

            public Point getPopupPoint() {
                if (SetVertexMostRecentColorAction.this.vertex.isFullScreenMode()) {
                    return super.getPopupPoint();
                }
                Point buttonUpperLeftCorner = SetVertexMostRecentColorAction.this.controller.getViewerPointFromVertexPoint(SetVertexMostRecentColorAction.this.vertex, new Point(0, 0));
                Point buttonBottomLeftCorner = SetVertexMostRecentColorAction.this.controller.getViewerPointFromVertexPoint(SetVertexMostRecentColorAction.this.vertex, new Point(0, this.getHeight()));
                int y = buttonBottomLeftCorner.y - buttonUpperLeftCorner.y;
                return new Point(0, y);
            }

            private Point getButtonLocationInGraphComponentPanel() {
                JComponent vertexComponentPanel = SetVertexMostRecentColorAction.this.vertex.getComponent();
                int x = this.getX();
                int y = this.getY();
                for (Container parent = this.getParent(); parent != vertexComponentPanel; parent = parent.getParent()) {
                    x += parent.getX();
                    y += parent.getY();
                }
                return new Point(x, y);
            }
        };
    }

    private class SetVertexColorAction
    extends DockingAction {
        private final Color color;
        private final FGVertex actionVertex;

        public SetVertexColorAction(FGVertex vertex, Color color) {
            super("SetVertexColor", "");
            this.actionVertex = vertex;
            this.color = color;
            this.setMenuBarData(new MenuData(new String[]{"Select Color"}, (Icon)new ColorIcon3D(color)));
        }

        public void actionPerformed(ActionContext context) {
            FGColorProvider colorProvider = SetVertexMostRecentColorAction.this.controller.getColorProvider();
            colorProvider.setVertexColor(this.actionVertex, this.color);
        }
    }
}

