/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaExport;
import agent.frida.model.iface2.FridaModelTargetExportContainer;
import agent.frida.model.impl.FridaModelTargetExportImpl;
import agent.frida.model.impl.FridaModelTargetModuleImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ExportContainer", elements={@TargetElementType(type=FridaModelTargetExportImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetExportContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetExportContainer {
    protected final FridaModelTargetModuleImpl module;

    public FridaModelTargetExportContainerImpl(FridaModelTargetModuleImpl module) {
        super(module.getModel(), (TargetObject)module, "Exports", "ExportContainer");
        this.module = module;
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listModuleExports(this.module.getModule()).thenAccept(byName -> {
            List symbols;
            FridaModelTargetExportContainerImpl fridaModelTargetExportContainerImpl = this;
            synchronized (fridaModelTargetExportContainerImpl) {
                symbols = byName.values().stream().map(this::getTargetExport).collect(Collectors.toList());
            }
            this.setElements(symbols, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized FridaModelTargetExportImpl getTargetExport(FridaExport symbol) {
        TargetObject targetObject = this.getMapObject(symbol);
        if (targetObject != null) {
            FridaModelTargetExportImpl targetExport = (FridaModelTargetExportImpl)targetObject;
            targetExport.setModelObject(symbol);
            return targetExport;
        }
        return new FridaModelTargetExportImpl(this, symbol);
    }
}

