/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.model.iface2.FridaModelTargetAvailableProcess;
import agent.frida.model.iface2.FridaModelTargetAvailableProcessesContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="AvailableProcess", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class FridaModelTargetAvailableProcessImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetAvailableProcess {
    protected final String pid;
    protected final String name;
    private Integer base = 10;

    protected static String keyAttachable(String pid) {
        return PathUtils.makeKey((String)pid);
    }

    public FridaModelTargetAvailableProcessImpl(FridaModelTargetAvailableProcessesContainer parent, String pid, String name) {
        super(parent.getModel(), (TargetObject)parent, FridaModelTargetAvailableProcessImpl.keyAttachable(pid), name);
        this.name = name;
        this.pid = pid;
        this.changeAttributes(List.of(), List.of(), Map.of("_pid", Long.parseLong(pid, 10), "_display", this.getDisplay()), "Initialized");
    }

    public FridaModelTargetAvailableProcessImpl(FridaModelTargetAvailableProcessesContainer parent, String pid) {
        super(parent.getModel(), (TargetObject)parent, FridaModelTargetAvailableProcessImpl.keyAttachable(pid), "Attachable");
        this.pid = pid;
        this.name = "";
        this.changeAttributes(List.of(), List.of(), Map.of("_pid", Long.parseLong(pid, 10), "_display", FridaModelTargetAvailableProcessImpl.keyAttachable(pid)), "Initialized");
    }

    @Override
    @TargetAttributeType(name="_pid", hidden=true)
    public Long getPid() {
        return Long.parseLong(this.pid);
    }

    public String getDisplay() {
        Long p = Long.decode(this.pid);
        Object pidstr = "";
        pidstr = this.base == 16 ? "0x" + Long.toHexString(p) : this.pid;
        return "[" + (String)pidstr + "] : " + this.name.trim();
    }

    @Override
    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }
}

