/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaKernelMemoryRegionInfo;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class FridaListKernelMemoryRegionsCommand
extends AbstractFridaCommand<Void> {
    private List<FridaKernelMemoryRegionInfo> regions = new ArrayList<FridaKernelMemoryRegionInfo>();

    public FridaListKernelMemoryRegionsCommand(FridaManagerImpl manager) {
        super(manager);
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "list_ranges", "result = Kernel.enumerateRanges('---');");
        for (FridaKernelMemoryRegionInfo region : this.regions) {
            this.manager.addKernelMemoryRegionIfAbsent(region);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaKernelMemoryRegionInfo region = new FridaKernelMemoryRegionInfo();
        JsonObject memDetails = element.getAsJsonObject();
        region.setRangeAddress(memDetails.get("base").getAsString());
        region.setRangeSize(memDetails.get("size").getAsLong());
        region.setProtection(memDetails.get("protection").getAsString());
        this.regions.add(region);
    }
}

