/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.SystemUtilities;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class LRUMap<K, V>
implements Map<K, V> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected HashMap<K, Entry<K, V>> map;
    private int cacheSize;
    private Entry<K, V> head;
    private volatile long modificationID = 0L;

    public LRUMap(int cacheSize) {
        this.cacheSize = cacheSize;
        int initialCapacity = (int)((float)cacheSize / 0.75f) + 1;
        this.map = new HashMap(initialCapacity, 0.75f);
        this.head = new Entry<Object, Object>(null, null);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (V mapValue : this.values()) {
            if (!Objects.equals(value, mapValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        this.addToTop(entry);
        return entry.value;
    }

    @Override
    public V put(K key, V value) {
        V oldValue = null;
        Entry<K, V> entry = this.map.get(key);
        if (entry != null) {
            oldValue = entry.value;
            this.removeEntry(entry);
            entry.value = value;
        } else {
            entry = new Entry<K, V>(key, value);
            this.map.put(key, entry);
        }
        this.addToTop(entry);
        this.removeOldEntries();
        ++this.modificationID;
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> entry = this.map.remove(key);
        ++this.modificationID;
        if (entry != null) {
            this.removeEntry(entry);
            return entry.value;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> mapEntry : m.entrySet()) {
            this.put(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.head.previous = this.head;
        this.head.next = this.head.previous;
        ++this.modificationID;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return LRUMap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                return LRUMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                return LRUMap.this.remove(o) != null;
            }

            @Override
            public void clear() {
                LRUMap.this.clear();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return LRUMap.this.map.size();
            }

            @Override
            public void clear() {
                LRUMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return LRUMap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = LRUMap.this.get(key);
                return SystemUtilities.isEqual(e.getValue(), value);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                return LRUMap.this.remove(key) != null;
            }

            @Override
            public void clear() {
                LRUMap.this.clear();
            }
        };
    }

    private void removeOldEntries() {
        Entry eldest = this.head.previous;
        if (this.removeEldestEntry(eldest)) {
            this.map.remove(eldest.key);
            this.removeEntry(eldest);
            this.eldestEntryRemoved(eldest);
        }
    }

    private void addToTop(Entry<K, V> entry) {
        entry.previous = this.head;
        entry.next = this.head.next;
        this.head.next.previous = entry;
        this.head.next = entry;
    }

    private void removeEntry(Entry<K, V> entry) {
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        entry.next = null;
        entry.previous = null;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.map.size() > this.cacheSize;
    }

    protected void eldestEntryRemoved(Map.Entry<K, V> eldest) {
    }

    public String toString() {
        return this.map.toString();
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        Entry<K, V> next;
        Entry<K, V> previous;
        V value;
        K key;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
            this.next = this;
            this.previous = this;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        public String toString() {
            return this.key + ", " + this.value;
        }
    }

    private class EntryIterator
    extends LinkedIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Entry<K, V> next() {
            this.advance();
            return this.current;
        }
    }

    private class ValueIterator
    extends LinkedIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            this.advance();
            return this.current.getValue();
        }
    }

    private class KeyIterator
    extends LinkedIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            this.advance();
            return this.current.getKey();
        }
    }

    private abstract class LinkedIterator<T>
    implements Iterator<T> {
        private Entry<K, V> next;
        protected Entry<K, V> current;
        private long startModificactionID;

        private LinkedIterator() {
            this.next = LRUMap.this.head.next;
            this.current = null;
            this.startModificactionID = LRUMap.this.modificationID;
        }

        @Override
        public boolean hasNext() {
            return this.next != LRUMap.this.head;
        }

        protected void advance() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (LRUMap.this.modificationID != this.startModificactionID) {
                throw new ConcurrentModificationException();
            }
            this.current = this.next;
            this.next = this.current.next;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (LRUMap.this.modificationID != this.startModificactionID) {
                throw new ConcurrentModificationException();
            }
            LRUMap.this.remove(this.current.getKey());
            this.current = null;
            this.startModificactionID = LRUMap.this.modificationID;
        }
    }
}

