/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import ghidra.util.Swing;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;

public class WindowUtilities {
    public static String getTitle(Window w) {
        if (w == null) {
            return null;
        }
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public static Window windowForComponent(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return SwingUtilities.getWindowAncestor(c);
    }

    public static Rectangle getVirtualScreenBounds() {
        GraphicsDevice[] gs;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle gcBounds = gc.getBounds();
            virtualBounds = virtualBounds.union(gcBounds);
        }
        return virtualBounds;
    }

    public static Shape getVisibleScreenBounds() {
        GraphicsDevice[] gs;
        Area area = new Area();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle gcBounds = gc.getBounds();
            area.add(new Area(gcBounds));
        }
        return area;
    }

    public static Rectangle getScreenBounds(Component c) {
        Point p = WindowUtilities.getScreenLocation(c);
        if (p == null) {
            return null;
        }
        ScreenBounds screenBounds = WindowUtilities.doGetScreenBounds(p);
        return screenBounds.getUsableBounds();
    }

    private static Point getScreenLocation(Component c) {
        if (c instanceof Window) {
            return c.getLocation();
        }
        if (!c.isShowing()) {
            return null;
        }
        Window w = WindowUtilities.windowForComponent(c);
        if (w == null) {
            return null;
        }
        Point p = c.getLocationOnScreen();
        return p;
    }

    public static Point centerOnScreen(Dimension d) {
        GraphicsDevice defaultDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration config = defaultDevice.getDefaultConfiguration();
        Rectangle bounds = config.getBounds();
        return WindowUtilities.center(bounds, d);
    }

    public static Point centerOnScreen(Component c, Dimension d) {
        Rectangle bounds = WindowUtilities.getScreenBounds(c);
        if (bounds == null) {
            throw new IllegalArgumentException("Component is not on screen: " + c);
        }
        return WindowUtilities.center(bounds, d);
    }

    private static Point center(Rectangle area, Dimension d) {
        Rectangle b = area;
        int userWidth = Math.min(b.width, d.width);
        int userHeigh = Math.min(b.height, d.height);
        int halfScreenWidth = b.width / 2;
        int halfUserWidth = userWidth / 2;
        int halfScreenHeight = b.height / 2;
        int halfUserHeight = userHeigh / 2;
        int widthOffset = halfScreenWidth - halfUserWidth;
        int heightOffset = halfScreenHeight - halfUserHeight;
        int x = b.x + widthOffset;
        int y = b.y + heightOffset;
        return new Point(x, y);
    }

    public static Point centerOnComponent(Component parent, Component child) {
        Dimension parentSize = parent.getSize();
        Dimension childSize = child.getSize();
        int x = (parentSize.width >> 1) - (childSize.width >> 1);
        int y = (parentSize.height >> 1) - (childSize.height >> 1);
        Point point = new Point(x, y);
        if (child instanceof Window) {
            SwingUtilities.convertPointToScreen(point, parent);
        } else {
            point = SwingUtilities.convertPoint(parent, point, child.getParent());
        }
        return point;
    }

    public static void ensureOnScreen(Component c) {
        Rectangle bounds = c.getBounds();
        WindowUtilities.ensureOnScreen(c, bounds);
        c.setBounds(bounds);
    }

    public static void ensureEntirelyOnScreen(Component c) {
        Rectangle bounds = c.getBounds();
        WindowUtilities.ensureEntirelyOnScreen(c, bounds);
        c.setBounds(bounds);
    }

    public static void ensureOnScreen(Component c, Rectangle bounds) {
        Shape visibleScreenBounds = WindowUtilities.getVisibleScreenBounds();
        if (visibleScreenBounds.intersects(bounds)) {
            return;
        }
        Rectangle screen = WindowUtilities.getScreenBounds(c);
        if (screen == null) {
            throw new IllegalArgumentException("Component is not on screen: " + c);
        }
        Point newPoint = WindowUtilities.center(screen, bounds.getSize());
        bounds.setLocation(newPoint);
    }

    public static void ensureEntirelyOnScreen(Component c, Rectangle bounds) {
        Shape visibleScreenBounds = WindowUtilities.getVisibleScreenBounds();
        if (visibleScreenBounds.contains(bounds)) {
            return;
        }
        Rectangle screen = WindowUtilities.getScreenBounds(c);
        if (screen == null) {
            throw new IllegalArgumentException("Component is not on screen: " + c);
        }
        Point newPoint = WindowUtilities.center(screen, bounds.getSize());
        bounds.setLocation(newPoint);
    }

    private static ScreenBounds doGetScreenBounds(Point p) {
        GraphicsConfiguration gc = WindowUtilities.getGraphicsConfigurationForPoint(p);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle bounds = gc.getBounds();
        Insets insets = toolkit.getScreenInsets(gc);
        return new ScreenBounds(bounds, insets);
    }

    private static GraphicsConfiguration getGraphicsConfigurationForPoint(Point p) {
        GraphicsDevice[] devices;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = ge.getScreenDevices()) {
            GraphicsConfiguration config;
            if (device.getType() != 0 || !(config = device.getDefaultConfiguration()).getBounds().contains(p)) continue;
            return config;
        }
        GraphicsDevice defaultDevice = ge.getDefaultScreenDevice();
        return defaultDevice.getDefaultConfiguration();
    }

    public static boolean areModalDialogsVisible() {
        return WindowUtilities.getOpenModalDialogs().size() > 0;
    }

    public static Dialog findModalestDialog() {
        List<Dialog> openModalDialogs = WindowUtilities.getOpenModalDialogs();
        if (openModalDialogs.size() == 0) {
            return null;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component permanentFocusOwner = kfm.getPermanentFocusOwner();
        if (permanentFocusOwner == null) {
            return WindowUtilities.pickAModalDialog(openModalDialogs);
        }
        Dialog theModalest = WindowUtilities.findParentModalDialog(permanentFocusOwner, openModalDialogs);
        theModalest = WindowUtilities.findYoungestChildDialogOfParentDialog(theModalest, openModalDialogs);
        if ((theModalest = WindowUtilities.checkForActiveModalDialog(theModalest)) != null) {
            return theModalest;
        }
        return WindowUtilities.pickAModalDialog(openModalDialogs);
    }

    private static Dialog checkForActiveModalDialog(Dialog theModalest) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (!(activeWindow instanceof Dialog)) {
            return theModalest;
        }
        Dialog dialog = (Dialog)activeWindow;
        if (dialog.isModal()) {
            return dialog;
        }
        return theModalest;
    }

    private static void getOpenModalDialogChildren(Frame frame, List<Dialog> openModalDialogs) {
        Window[] ownedWindows;
        for (Window window : ownedWindows = frame.getOwnedWindows()) {
            WindowUtilities.getOpenModalDialogChidrenForWindow(window, openModalDialogs);
        }
    }

    private static void getOpenModalDialogChidrenForWindow(Window window, List<Dialog> openModalDialogs) {
        Window[] childWindows;
        Dialog dialog;
        if (window instanceof Dialog && (dialog = (Dialog)window).isVisible() && dialog.isModal()) {
            openModalDialogs.add(dialog);
        }
        for (Window childWindow : childWindows = window.getOwnedWindows()) {
            WindowUtilities.getOpenModalDialogChidrenForWindow(childWindow, openModalDialogs);
        }
    }

    public static List<Dialog> getOpenModalDialogsFor(Frame parent) {
        Objects.requireNonNull(parent);
        ArrayList<Dialog> openModalDialogs = new ArrayList<Dialog>();
        WindowUtilities.getOpenModalDialogChildren(parent, openModalDialogs);
        return openModalDialogs;
    }

    private static List<Dialog> getOpenModalDialogs() {
        Frame[] frames = Frame.getFrames();
        ArrayList<Dialog> openModalDialogs = new ArrayList<Dialog>();
        for (Frame nextFrame : frames) {
            WindowUtilities.getOpenModalDialogChildren(nextFrame, openModalDialogs);
        }
        return openModalDialogs;
    }

    private static Dialog findParentModalDialog(Component permanentFocusOwner, List<Dialog> openModalDialogs) {
        for (Dialog dialog : openModalDialogs) {
            if (!SwingUtilities.isDescendingFrom(permanentFocusOwner, dialog)) continue;
            return dialog;
        }
        return null;
    }

    private static Dialog findYoungestChildDialogOfParentDialog(Dialog parentDialog, List<Dialog> openModalDialogs) {
        if (parentDialog == null) {
            return null;
        }
        for (Dialog potentialChildDialog : openModalDialogs) {
            if (parentDialog == potentialChildDialog || !SwingUtilities.isDescendingFrom(potentialChildDialog, parentDialog)) continue;
            return WindowUtilities.findYoungestChildDialogOfParentDialog(potentialChildDialog, openModalDialogs);
        }
        return parentDialog;
    }

    private static Dialog pickAModalDialog(List<Dialog> openModalDialogs) {
        Dialog dialog = openModalDialogs.get(openModalDialogs.size() - 1);
        return WindowUtilities.findYoungestChildDialogOfParentDialog(dialog, openModalDialogs);
    }

    public static void bringModalestDialogToFront(Window activeWindow) {
        Swing.runLater(() -> WindowUtilities.doBringModalestDialogToFront(activeWindow));
    }

    private static void doBringModalestDialogToFront(Window activeWindow) {
        Dialog modalestDialog = WindowUtilities.findModalestDialog();
        if (modalestDialog == null) {
            return;
        }
        Swing.runLater(modalestDialog::toFront);
    }

    private static class ScreenBounds {
        private Rectangle fullBounds;
        private Rectangle usableBounds;

        public ScreenBounds(Rectangle bounds, Insets insets) {
            this.fullBounds = bounds;
            int x = this.fullBounds.x + insets.left;
            int y = this.fullBounds.y + insets.top;
            int width = this.fullBounds.width - Math.abs(insets.left + insets.right);
            int height = this.fullBounds.height - Math.abs(insets.top + insets.bottom);
            this.usableBounds = new Rectangle(x, y, width, height);
        }

        Rectangle getUsableBounds() {
            return this.usableBounds;
        }
    }
}

