/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.evt;

import agent.gdb.manager.GdbInferiorThreadGroup;
import agent.gdb.manager.GdbProcessThreadGroup;
import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class GdbCommandDoneEvent
extends AbstractGdbCompletedCommandEvent {
    private static Long parseLong(String nullable) {
        return nullable == null ? null : Long.valueOf(Long.parseLong(nullable));
    }

    public GdbCommandDoneEvent(CharSequence tail) throws GdbParsingUtils.GdbParseError {
        super(tail);
    }

    public List<GdbInferiorThreadGroup> assumeInferiorGroups() {
        List<GdbMiParser.GdbMiFieldList> groups = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(GdbMiParser.GdbMiFieldList.class, "groups");
        ArrayList<GdbInferiorThreadGroup> iids = new ArrayList<GdbInferiorThreadGroup>();
        for (GdbMiParser.GdbMiFieldList groupInfo : groups) {
            String gid = groupInfo.getString("id");
            if (!gid.startsWith("i")) continue;
            int iid = GdbParsingUtils.parseInferiorId(gid);
            String type = groupInfo.getString("type");
            String pid = groupInfo.getString("pid");
            String exitCode = groupInfo.getString("exit-code");
            String executable = groupInfo.getString("executable");
            iids.add(new GdbInferiorThreadGroup(iid, type, GdbCommandDoneEvent.parseLong(pid), GdbCommandDoneEvent.parseLong(exitCode), executable));
        }
        return iids;
    }

    public List<GdbProcessThreadGroup> assumeProcessGroups() {
        List<GdbMiParser.GdbMiFieldList> groups = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(GdbMiParser.GdbMiFieldList.class, "groups");
        ArrayList<GdbProcessThreadGroup> pids = new ArrayList<GdbProcessThreadGroup>();
        for (GdbMiParser.GdbMiFieldList groupInfo : groups) {
            if (!"process".equals(groupInfo.getString("type"))) {
                Msg.error((Object)this, (Object)("Unexpected type in available thread groups: " + groupInfo));
                continue;
            }
            String gid = groupInfo.getString("id");
            String desc = groupInfo.getString("description");
            try {
                pids.add(new GdbProcessThreadGroup(Integer.parseInt(gid), desc));
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Unexpected group id in available thread groups: " + groupInfo));
            }
        }
        return pids;
    }

    public List<Integer> assumeThreadIds() {
        List<GdbMiParser.GdbMiFieldList> threads = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(GdbMiParser.GdbMiFieldList.class, "threads");
        ArrayList<Integer> tids = new ArrayList<Integer>();
        for (GdbMiParser.GdbMiFieldList threadInfo : threads) {
            String tid = threadInfo.getString("id");
            try {
                tids.add(Integer.parseInt(tid));
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Unexpected thread id in: " + threadInfo));
            }
        }
        return tids;
    }

    public Integer checkNewThreadId() {
        String newTid = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("new-thread-id");
        if (newTid == null) {
            return null;
        }
        try {
            return Integer.parseInt(newTid);
        }
        catch (NumberFormatException e) {
            Msg.error((Object)this, (Object)("Unexpected thread id in: " + newTid));
            return null;
        }
    }

    public GdbMiParser.GdbMiFieldList checkFrame() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getFieldList("frame");
    }

    public String assumeValue() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("value");
    }

    public String maybeValue() {
        if (((GdbMiParser.GdbMiFieldList)this.getInfo()).containsKey("value")) {
            return this.assumeValue();
        }
        return null;
    }

    public GdbMiParser.GdbMiFieldList assumeOSDataTable() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getFieldList("OSDataTable");
    }

    public List<String> assumeRegisterNameList() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(String.class, "register-names");
    }

    public List<GdbMiParser.GdbMiFieldList> assumeRegisterValueList() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(GdbMiParser.GdbMiFieldList.class, "register-values");
    }

    public List<GdbMiParser.GdbMiFieldList> assumeMemoryContentsList() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(GdbMiParser.GdbMiFieldList.class, "memory");
    }

    public List<GdbMiParser.GdbMiFieldList> assumeThreadInfoList() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getListOf(GdbMiParser.GdbMiFieldList.class, "threads");
    }

    public GdbMiParser.GdbMiFieldList assumeBreakpointTable() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getFieldList("BreakpointTable");
    }

    public GdbMiParser.GdbMiFieldList assumeStack() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getFieldList("stack");
    }
}

