/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugProcessRecord;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.DbgModule;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.DbgAttachCommand;
import agent.dbgeng.manager.cmd.DbgContinueCommand;
import agent.dbgeng.manager.cmd.DbgDetachCommand;
import agent.dbgeng.manager.cmd.DbgEvaluateCommand;
import agent.dbgeng.manager.cmd.DbgFileExecAndSymbolsCommand;
import agent.dbgeng.manager.cmd.DbgKillCommand;
import agent.dbgeng.manager.cmd.DbgListMappingsCommand;
import agent.dbgeng.manager.cmd.DbgListModulesCommand;
import agent.dbgeng.manager.cmd.DbgListThreadsCommand;
import agent.dbgeng.manager.cmd.DbgReadMemoryCommand;
import agent.dbgeng.manager.cmd.DbgRunCommand;
import agent.dbgeng.manager.cmd.DbgStepCommand;
import agent.dbgeng.manager.cmd.DbgWriteMemoryCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgModuleImpl;
import agent.dbgeng.manager.impl.DbgSectionImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import generic.ULongSpan;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.comm.util.BitmaskSet;
import ghidra.dbg.target.TargetAttachable;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public class DbgProcessImpl
implements DbgProcess {
    private final Map<DebugThreadId, DbgThreadImpl> threads = new LinkedHashMap<DebugThreadId, DbgThreadImpl>();
    private final Map<DebugThreadId, DbgThread> unmodifiableThreads = Collections.unmodifiableMap(this.threads);
    private final Map<String, DbgModuleImpl> modules = new LinkedHashMap<String, DbgModuleImpl>();
    private final Map<String, DbgModule> unmodifiableModules = Collections.unmodifiableMap(this.modules);
    private final NavigableMap<Long, DbgSectionImpl> mappings = new TreeMap<Long, DbgSectionImpl>();
    private final NavigableMap<Long, DbgSectionImpl> unmodifiableMappings = Collections.unmodifiableNavigableMap(this.mappings);
    private DbgManagerImpl manager;
    private DebugProcessId id;
    private Long pid;
    private Long exitCode;
    private Long offset;
    private String name;

    public DbgProcessImpl(DbgManagerImpl manager, DebugProcessId id, long pid, String name) {
        this.manager = manager;
        this.id = id;
        this.pid = pid;
        this.name = name;
    }

    public DbgProcessImpl(DbgManagerImpl manager, DebugProcessId id, long pid) {
        this.manager = manager;
        this.id = id;
        this.pid = pid;
    }

    public DbgProcessImpl(DbgManagerImpl manager) {
        this.manager = manager;
    }

    public String toString() {
        return "<DbgProcess id=" + this.id + ",pid=" + this.pid + ",exitCode=" + this.exitCode + ">";
    }

    @Override
    public DebugProcessId getId() {
        return this.id;
    }

    public void setId(DebugProcessId id) {
        this.id = id;
    }

    @Override
    public Long getPid() {
        return this.pid;
    }

    public void setExitCode(Long exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public Long getExitCode() {
        return this.exitCode;
    }

    public void add() {
        this.manager.processes.put(this.id, this);
    }

    public void remove(DbgCause cause) {
        this.manager.removeProcess(this.id, cause);
    }

    @Override
    public CompletableFuture<Void> remove() {
        return this.manager.removeProcess(this);
    }

    public void addThread(DbgThreadImpl thread) {
        assert (thread.getProcess().equals(this));
        DbgThreadImpl exists = this.threads.get(thread.getId());
        if (exists != null) {
            Msg.warn((Object)this, (Object)("Adding pre-existing thread " + exists));
        }
        this.threads.put(thread.getId(), thread);
    }

    @Override
    public DbgThreadImpl getThread(DebugThreadId tid) {
        DbgThreadImpl result = this.threads.get(tid);
        if (result == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
        return result;
    }

    public void removeThread(DebugThreadId tid) {
        if (this.threads.remove(tid) == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
    }

    public void addModule(DbgModuleImpl module) {
        DbgModuleImpl exists = this.modules.get(module.getInfo().toString());
        if (exists != null) {
            throw new IllegalArgumentException("There is already module " + exists);
        }
        this.modules.put(module.getInfo().toString(), module);
    }

    @Override
    public DbgModuleImpl getModule(String id) {
        DbgModuleImpl result = this.modules.get(id);
        if (result == null) {
            throw new IllegalArgumentException("There is no module with id " + id);
        }
        return result;
    }

    public void removeModule(String id) {
        if (this.modules.remove(id) == null) {
            throw new IllegalArgumentException("There is no module with id " + id);
        }
    }

    @Override
    public Map<DebugThreadId, DbgThread> getKnownThreads() {
        return this.unmodifiableThreads;
    }

    public Map<DebugThreadId, DbgThreadImpl> getKnownThreadsImpl() {
        return this.threads;
    }

    @Override
    public CompletableFuture<Map<DebugThreadId, DbgThread>> listThreads() {
        if (this.manager.isKernelMode() && !this.id.isSystem()) {
            return CompletableFuture.completedFuture(this.getKnownThreads());
        }
        return this.manager.execute(new DbgListThreadsCommand(this.manager, this));
    }

    @Override
    public Map<String, DbgModule> getKnownModules() {
        return this.unmodifiableModules;
    }

    @Override
    public CompletableFuture<Map<String, DbgModule>> listModules() {
        return this.manager.execute(new DbgListModulesCommand(this.manager, this));
    }

    @Override
    public Map<Long, DbgSectionImpl> getKnownMappings() {
        return this.unmodifiableMappings;
    }

    @Override
    public CompletableFuture<Map<Long, DbgSectionImpl>> listMappings() {
        return this.manager.execute(new DbgListMappingsCommand(this.manager, this));
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return this.manager.setActiveProcess(this);
    }

    @Override
    public CompletableFuture<Void> fileExecAndSymbols(String file) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgFileExecAndSymbolsCommand(this.manager, file)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<DbgThread> run() {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.cls(DbgThread.class)).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgRunCommand(this.manager)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Set<DbgThread>> attach(long toPid) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.cls(DbgThread.class).set()).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> {
            this.id = new DebugProcessRecord(toPid);
            this.pid = toPid;
            this.manager.execute(new DbgAttachCommand(this.manager, this, (BitmaskSet<DebugClient.DebugAttachFlags>)BitmaskSet.of((Enum[])new DebugClient.DebugAttachFlags[]{DebugClient.DebugAttachFlags.DEFAULT}))).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1));
        }).finish();
    }

    @Override
    public CompletableFuture<Set<DbgThread>> reattach(TargetAttachable attachable) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.cls(DbgThread.class).set()).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgAttachCommand(this.manager, this, (BitmaskSet<DebugClient.DebugAttachFlags>)BitmaskSet.of((Enum[])new DebugClient.DebugAttachFlags[]{DebugClient.DebugAttachFlags.EXISTING}))).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Void> detach() {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgDetachCommand(this.manager, this)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Void> kill() {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgKillCommand(this.manager)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Void> cont() {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgContinueCommand(this.manager)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Void> step(DbgManager.ExecSuffix suffix) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgStepCommand(this.manager, null, suffix)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Void> step(Map<String, ?> args) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.setActive().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1))).then(seq -> this.manager.execute(new DbgStepCommand(this.manager, null, args)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    protected <T> CompletableFuture<T> preferThread(Function<DbgThreadImpl, CompletableFuture<T>> viaThread, Supplier<CompletableFuture<T>> viaThis) {
        Optional<DbgThreadImpl> first = this.threads.values().stream().findFirst();
        if (first.isPresent()) {
            return viaThread.apply(first.get());
        }
        return this.setActive().thenCompose(__ -> (CompletionStage)viaThis.get());
    }

    @Override
    public CompletableFuture<ULongSpan.ULongSpanSet> readMemory(long addr, ByteBuffer buf, int len) {
        return this.preferThread(t -> t.readMemory(addr, buf, len), () -> this.manager.execute(new DbgReadMemoryCommand(this.manager, addr, buf, len)));
    }

    @Override
    public CompletableFuture<Void> writeMemory(long addr, ByteBuffer buf, int len) {
        return this.preferThread(t -> t.writeMemory(addr, buf, len), () -> this.manager.execute(new DbgWriteMemoryCommand(this.manager, addr, buf, len)));
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return null;
    }

    protected void moduleLoaded(DebugModuleInfo info) {
        if (!this.modules.containsKey(info.getModuleName())) {
            DbgModuleImpl module = new DbgModuleImpl(this.manager, this, info);
            this.modules.put(info.toString(), module);
        }
    }

    protected void moduleUnloaded(DebugModuleInfo info) {
        this.modules.remove(info.toString());
    }

    protected void threadCreated(DbgThreadImpl thread) {
        this.threads.put(thread.getId(), thread);
    }

    public void threadExited(DebugThreadId id) {
        this.threads.remove(id);
    }

    @Override
    public CompletableFuture<String> evaluate(String expression) {
        return this.manager.execute(new DbgEvaluateCommand(this.manager, expression));
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Override
    public String getExecutableName() {
        return this.name;
    }

    @Override
    public void setExecutableName(String name) {
        this.name = name;
    }
}

