/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.client;

import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugAdvanced;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.dbgeng.DebugEventCallbacks;
import agent.dbgeng.dbgeng.DebugInputCallbacks;
import agent.dbgeng.dbgeng.DebugOutputCallbacks;
import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugRunningProcess;
import agent.dbgeng.dbgeng.DebugServerId;
import agent.dbgeng.dbgeng.DebugSymbols;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.impl.dbgeng.DebugRunningProcessImpl;
import agent.dbgeng.impl.dbgeng.advanced.DebugAdvancedInternal;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.impl.dbgeng.control.DebugControlInternal;
import agent.dbgeng.impl.dbgeng.dataspaces.DebugDataSpacesInternal;
import agent.dbgeng.impl.dbgeng.event.WrapCallbackIDebugEventCallbacks;
import agent.dbgeng.impl.dbgeng.io.WrapCallbackIDebugInputCallbacks;
import agent.dbgeng.impl.dbgeng.io.WrapCallbackIDebugOutputCallbacks;
import agent.dbgeng.impl.dbgeng.registers.DebugRegistersInternal;
import agent.dbgeng.impl.dbgeng.symbols.DebugSymbolsInternal;
import agent.dbgeng.impl.dbgeng.sysobj.DebugSystemObjectsInternal;
import agent.dbgeng.jna.dbgeng.client.IDebugClient;
import agent.dbgeng.jna.dbgeng.event.ListenerIDebugEventCallbacks;
import agent.dbgeng.jna.dbgeng.event.MarkerEventCallbacks;
import agent.dbgeng.jna.dbgeng.io.ListenerIDebugInputCallbacks;
import agent.dbgeng.jna.dbgeng.io.ListenerIDebugOutputCallbacks;
import agent.dbgeng.jna.dbgeng.io.MarkerInputCallbacks;
import agent.dbgeng.jna.dbgeng.io.MarkerOutputCallbacks;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.comm.util.BitmaskSet;
import java.util.ArrayList;
import java.util.List;

public class DebugClientImpl1
implements DebugClientInternal {
    private final DbgEng.OpaqueCleanable cleanable;
    private final IDebugClient jnaClient;
    private DebugAdvancedInternal advanced;
    private DebugControlInternal control;
    private DebugDataSpaces data;
    private DebugRegisters registers;
    private DebugSymbols symbols;
    private DebugSystemObjects sysobjs;
    protected MarkerOutputCallbacks listenerOutput;
    protected MarkerInputCallbacks listenerInput;
    protected MarkerEventCallbacks listenerEvent;

    public DebugClientImpl1(IDebugClient jnaClient) {
        this.cleanable = DbgEng.releaseWhenPhantom((Object)this, jnaClient);
        this.jnaClient = jnaClient;
    }

    @Override
    public IDebugClient getJNAClient() {
        return this.jnaClient;
    }

    @Override
    public DebugAdvanced getAdvanced() {
        if (this.advanced == null) {
            this.advanced = DebugAdvancedInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
        }
        return this.advanced;
    }

    @Override
    public DebugControlInternal getControlInternal() {
        if (this.control == null) {
            this.control = DebugControlInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
        }
        return this.control;
    }

    @Override
    public DebugControl getControl() {
        return this.getControlInternal();
    }

    @Override
    public DebugDataSpaces getDataSpaces() {
        if (this.data == null) {
            this.data = DebugDataSpacesInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
        }
        return this.data;
    }

    @Override
    public DebugRegisters getRegisters() {
        if (this.registers == null) {
            this.registers = DebugRegistersInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
        }
        return this.registers;
    }

    @Override
    public DebugSymbols getSymbols() {
        if (this.symbols == null) {
            this.symbols = DebugSymbolsInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
        }
        return this.symbols;
    }

    @Override
    public DebugSystemObjects getSystemObjects() {
        if (this.sysobjs == null) {
            this.sysobjs = DebugSystemObjectsInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
        }
        return this.sysobjs;
    }

    @Override
    public DebugServerId getLocalServer() {
        return new DebugServerId(0L);
    }

    @Override
    public void startProcessServer(String options) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.StartProcessServer(new WinDef.ULONG((long)DebugClientInternal.DebugClass.USER_WINDOWS.ordinal()), options, null));
    }

    @Override
    public DebugServerId connectProcessServer(String options) {
        WinDef.ULONGLONGByReference pulServer = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.ConnectProcessServer(options, pulServer));
        return new DebugServerId(pulServer.getValue().longValue());
    }

    @Override
    public List<DebugRunningProcess> getRunningProcesses(DebugServerId si) {
        WinDef.ULONGLONG server = new WinDef.ULONGLONG(si.id);
        WinDef.ULONGByReference actualCount = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.GetRunningProcessSystemIds(server, null, new WinDef.ULONG(0L), actualCount));
        int[] ids = new int[actualCount.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.GetRunningProcessSystemIds(server, ids, actualCount.getValue(), null));
        ArrayList<DebugRunningProcess> result = new ArrayList<DebugRunningProcess>(ids.length);
        for (int id : ids) {
            result.add(new DebugRunningProcessImpl(this, si, id));
        }
        return result;
    }

    @Override
    public DebugRunningProcess.Description getProcessDescription(DebugServerId si, int systemId, BitmaskSet<DebugRunningProcess.Description.ProcessDescriptionFlags> flags) {
        WinDef.ULONGLONG ullServer = new WinDef.ULONGLONG(si.id);
        WinDef.ULONG ulId = new WinDef.ULONG((long)systemId);
        WinDef.ULONG ulFlags = new WinDef.ULONG(flags.getBitmask());
        WinDef.ULONGByReference actualExeNameSize = new WinDef.ULONGByReference();
        WinDef.ULONGByReference actualDescriptionSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.GetRunningProcessDescription(ullServer, ulId, ulFlags, null, new WinDef.ULONG(0L), actualExeNameSize, null, new WinDef.ULONG(0L), actualDescriptionSize));
        byte[] exeName = new byte[actualExeNameSize.getValue().intValue()];
        byte[] description = new byte[actualDescriptionSize.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.GetRunningProcessDescription(ullServer, ulId, ulFlags, exeName, actualExeNameSize.getValue(), null, description, actualDescriptionSize.getValue(), null));
        return new DebugRunningProcess.Description(systemId, Native.toString((byte[])exeName), Native.toString((byte[])description));
    }

    @Override
    public void attachProcess(DebugServerId si, long processId, BitmaskSet<DebugClient.DebugAttachFlags> attachFlags) {
        WinDef.ULONGLONG ullServer = new WinDef.ULONGLONG(si.id);
        WinDef.ULONG ulPid = new WinDef.ULONG(processId);
        WinDef.ULONG ulFlags = new WinDef.ULONG(attachFlags.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.AttachProcess(ullServer, ulPid, ulFlags));
    }

    @Override
    public void createProcess(DebugServerId si, String commandLine, String unusedInitialDirectory, String unusedEnvironment, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, BitmaskSet<DebugClient.DebugEngCreateFlags> unusedEngCreateFlags, BitmaskSet<DebugClient.DebugVerifierFlags> unusedVerifierFlags) {
        WinDef.ULONGLONG ullServer = new WinDef.ULONGLONG(si.id);
        WinDef.ULONG ulFlags = new WinDef.ULONG(createFlags.getBitmask());
        if (unusedInitialDirectory != null && unusedInitialDirectory.length() > 0) {
            throw new UnsupportedOperationException("IDebugClient1 does not support 'initial directory'");
        }
        if (unusedEnvironment != null && unusedEnvironment.length() > 0) {
            throw new UnsupportedOperationException("IDebugClient1 does not support 'environment'");
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.CreateProcess(ullServer, commandLine, ulFlags));
    }

    @Override
    public void createProcessAndAttach(DebugServerId si, String commandLine, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, int processId, BitmaskSet<DebugClient.DebugAttachFlags> attachFlags) {
        WinDef.ULONGLONG ullServer = new WinDef.ULONGLONG(si.id);
        WinDef.ULONG ulFlags1 = new WinDef.ULONG(createFlags.getBitmask());
        WinDef.ULONG ulPid = new WinDef.ULONG((long)processId);
        WinDef.ULONG ulFlags2 = new WinDef.ULONG(attachFlags.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.CreateProcessAndAttach(ullServer, commandLine, ulFlags1, ulPid, ulFlags2));
    }

    @Override
    public void startServer(String options) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.StartServer(options));
    }

    @Override
    public boolean dispatchCallbacks(int timeout) {
        WinNT.HRESULT hr = this.jnaClient.DispatchCallbacks(new WinDef.ULONG((long)timeout));
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return hr.equals((Object)WinNT.S_OK);
    }

    @Override
    public void flushCallbacks() {
        WinNT.HRESULT hr = this.jnaClient.FlushCallbacks();
        COMUtils.checkRC((WinNT.HRESULT)hr);
    }

    @Override
    public void exitDispatch(DebugClient client) {
        DebugClientInternal ic = (DebugClientInternal)client;
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.ExitDispatch(ic.getJNAClient()));
    }

    @Override
    public DebugClient createClient() {
        PointerByReference ppClient = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.CreateClient(ppClient));
        return DebugClientInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugClient)this.jnaClient).QueryInterface(arg_0, arg_1));
    }

    @Override
    public void setInputCallbacks(DebugInputCallbacks cb) {
        ListenerIDebugInputCallbacks listener = null;
        if (cb != null) {
            WrapCallbackIDebugInputCallbacks callback = new WrapCallbackIDebugInputCallbacks(this, cb);
            listener = new ListenerIDebugInputCallbacks(callback);
            callback.setListener(listener);
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.SetInputCallbacks(listener));
        this.listenerInput = listener;
    }

    @Override
    public void setOutputCallbacks(DebugOutputCallbacks cb) {
        ListenerIDebugOutputCallbacks listener = null;
        if (cb != null) {
            WrapCallbackIDebugOutputCallbacks callback = new WrapCallbackIDebugOutputCallbacks(cb);
            listener = new ListenerIDebugOutputCallbacks(callback);
            callback.setListener(listener);
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.SetOutputCallbacks(listener));
        this.listenerOutput = listener;
    }

    @Override
    public void setEventCallbacks(DebugEventCallbacks cb) {
        ListenerIDebugEventCallbacks listener = null;
        if (cb != null) {
            WrapCallbackIDebugEventCallbacks callback = new WrapCallbackIDebugEventCallbacks(this, cb);
            listener = new ListenerIDebugEventCallbacks(callback);
            callback.setListener(listener);
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.SetEventCallbacks(listener));
        this.listenerEvent = listener;
    }

    @Override
    public void terminateCurrentProcess() {
        throw new UnsupportedOperationException("Not implemented by this interface");
    }

    @Override
    public void detachCurrentProcess() {
        throw new UnsupportedOperationException("Not implemented by this interface");
    }

    @Override
    public void abandonCurrentProcess() {
        throw new UnsupportedOperationException("Not implemented by this interface");
    }

    @Override
    public void waitForProcessServerEnd(int timeout) {
        throw new UnsupportedOperationException("Not implemented by this interface");
    }

    @Override
    public void endSession(DebugClient.DebugEndSessionFlags flags) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.EndSession(new WinDef.ULONG(flags.getValue())));
    }

    @Override
    public void connectSession(int flags) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.ConnectSession(new WinDef.ULONG((long)flags), new WinDef.ULONG(10000L)));
    }

    @Override
    public void openDumpFileWide(String fileName) {
        throw new UnsupportedOperationException("Not implemented by this interface");
    }

    @Override
    public void attachKernel(long flags, String options) {
        throw new UnsupportedOperationException("Not implemented by this interface");
    }
}

