/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.indexedscrollpane.IndexScrollListener;
import docking.widgets.indexedscrollpane.IndexedScrollable;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

class CompositePanel
extends JPanel
implements IndexedScrollable,
IndexScrollListener {
    FieldPanel indexPanel;
    BoundedRangeModel verticalScrollBarModel;
    BoundedRangeModel horizontalScrollBarModel;
    List<ByteViewerComponent> viewList = new ArrayList<ByteViewerComponent>();
    List<FieldPanel> allPanels = new ArrayList<FieldPanel>();
    private boolean processingIndexRangeChanged;

    CompositePanel(FieldPanel indexPanel) {
        super((LayoutManager)new HorizontalLayout(0));
        this.indexPanel = indexPanel;
        indexPanel.addIndexScrollListener((IndexScrollListener)this);
        this.addMouseWheelListener(e -> {
            Layout firstLayout = indexPanel.getLayoutModel().getLayout(BigInteger.ZERO);
            int layoutScrollHt = firstLayout != null ? firstLayout.getScrollableUnitIncrement(0, 1) : 0;
            double wheelRotation = e.getPreciseWheelRotation();
            int scrollAmount = (int)(wheelRotation * (double)layoutScrollHt * 3.0);
            indexPanel.scrollView(scrollAmount);
            e.consume();
        });
        this.allPanels.add(indexPanel);
        this.rebuildPanels();
    }

    public void swapView(int fromIndex, int toIndex) {
        FieldPanel from = this.allPanels.get(fromIndex);
        FieldPanel to = this.allPanels.get(toIndex);
        this.allPanels.set(fromIndex, to);
        this.allPanels.set(toIndex, from);
        this.rebuildPanels();
    }

    void addByteViewerComponent(ByteViewerComponent comp) {
        comp.addIndexScrollListener(this);
        this.viewList.add(comp);
        this.allPanels.add(comp);
        this.rebuildPanels();
    }

    void removeByteViewerComponent(ByteViewerComponent comp) {
        comp.removeIndexScrollListener(this);
        this.viewList.remove((Object)comp);
        this.allPanels.remove((Object)comp);
        this.rebuildPanels();
    }

    private void rebuildPanels() {
        this.removeAll();
        int count = 0;
        for (FieldPanel panel : this.allPanels) {
            if (count++ != 0) {
                super.add(new JSeparator(1));
            }
            super.add((Component)panel);
        }
        this.invalidate();
    }

    @Override
    public Component add(Component comp) {
        throw new UnsupportedOperationException("External call to add(Component) not allowed");
    }

    @Override
    public void remove(Component comp) {
        throw new UnsupportedOperationException("External call to remove(Component) not allowed");
    }

    public void addIndexScrollListener(IndexScrollListener listener) {
        this.indexPanel.addIndexScrollListener(listener);
    }

    public int getHeight(BigInteger index) {
        return this.indexPanel.getHeight(index);
    }

    public BigInteger getIndexAfter(BigInteger index) {
        return this.indexPanel.getIndexAfter(index);
    }

    public BigInteger getIndexBefore(BigInteger index) {
        return this.indexPanel.getIndexBefore(index);
    }

    public BigInteger getIndexCount() {
        return this.indexPanel.getIndexCount();
    }

    public boolean isUniformIndex() {
        return true;
    }

    public void removeIndexScrollListener(IndexScrollListener listener) {
        this.indexPanel.removeIndexScrollListener(listener);
    }

    public void scrollLineDown() {
        this.indexPanel.scrollLineDown();
    }

    public void scrollLineUp() {
        this.indexPanel.scrollLineUp();
    }

    public void scrollPageDown() {
        this.indexPanel.scrollPageDown();
    }

    public void scrollPageUp() {
        this.indexPanel.scrollPageUp();
    }

    public void showIndex(BigInteger index, int verticalOffset) {
        this.indexPanel.showIndex(index, verticalOffset);
    }

    public void indexModelChanged() {
    }

    public void indexModelDataChanged(BigInteger start, BigInteger end) {
    }

    public void mouseWheelMoved(double preciseWheelRotation, boolean isHorizontal) {
        this.indexPanel.mouseWheelMoved(preciseWheelRotation, isHorizontal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexRangeChanged(BigInteger startIndex, BigInteger endIndex, int yStart, int yEnd) {
        if (this.processingIndexRangeChanged) {
            return;
        }
        this.processingIndexRangeChanged = true;
        try {
            for (FieldPanel fieldPanel : this.allPanels) {
                fieldPanel.showIndex(startIndex, yStart);
            }
        }
        finally {
            this.processingIndexRangeChanged = false;
        }
    }
}

