/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.GhidraOptions;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.DataModelInfo;
import ghidra.app.plugin.core.byteviewer.OptionsAction;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.byteviewer.ToggleEditAction;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.app.services.MarkerService;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class ByteViewerComponentProvider
extends ComponentProviderAdapter
implements OptionsChangeListener {
    protected static final String BLOCK_NUM = "Block Num";
    protected static final String BLOCK_OFFSET = "Block Offset";
    protected static final String BLOCK_COLUMN = "Block Column";
    protected static final String INDEX = "Index";
    protected static final String X_OFFSET = "X Offset";
    protected static final String Y_OFFSET = "Y Offset";
    private static final String VIEW_NAMES = "View Names";
    private static final String HEX_VIEW_GROUPSIZE = "Hex view groupsize";
    private static final String BYTES_PER_LINE_NAME = "Bytes Per Line";
    private static final String OFFSET_NAME = "Offset";
    static final int DEFAULT_NUMBER_OF_CHARS = 8;
    static final String DEFAULT_FONT_ID = "font.byteviewer";
    static final int DEFAULT_BYTES_PER_LINE = 16;
    static final String FG = "byteviewer.color.fg";
    static final String CURSOR = "byteviewer.color.cursor";
    static final GColor SEPARATOR_COLOR = new GColor("color.fg.byteviewer.separator");
    static final GColor CHANGED_VALUE_COLOR = new GColor("color.fg.byteviewer.changed");
    static final GColor CURSOR_ACTIVE_COLOR = new GColor("color.cursor.byteviewer.focused.active");
    static final GColor CURSOR_NON_ACTIVE_COLOR = new GColor("color.cursor.byteviewer.focused.not.active");
    static final GColor CURSOR_NOT_FOCUSED_COLOR = new GColor("color.cursor.byteviewer.unfocused");
    static final GColor CURRENT_LINE_COLOR = GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    static final String DEFAULT_INDEX_NAME = "Addresses";
    static final String SEPARATOR_COLOR_OPTION_NAME = "Block Separator Color";
    static final String CHANGED_VALUE_COLOR_OPTION_NAME = "Changed Values Color";
    static final String CURSOR_ACTIVE_COLOR_OPTION_NAME = "Active Cursor Color";
    static final String CURSOR_NON_ACTIVE_COLOR_OPTION_NAME = "Non-Active Cursor Color";
    static final String CURSOR_NOT_FOCUSED_COLOR_OPTION_NAME = "Non-Focused Cursor Color";
    static final String OPTION_FONT = "Font";
    private static final String DEFAULT_VIEW = "Hex";
    private static final String CURRENT_LINE_COLOR_OPTION_NAME = "Highlight Cursor Line Color";
    private static final String OPTION_HIGHLIGHT_CURSOR_LINE = "Highlight Cursor Line";
    protected ByteViewerPanel panel;
    private int bytesPerLine;
    private int offset;
    private int hexGroupSize = 1;
    protected Map<String, ByteViewerComponent> viewMap = new HashMap<String, ByteViewerComponent>();
    protected ToggleDockingAction editModeAction;
    protected OptionsAction setOptionsAction;
    protected ProgramByteBlockSet blockSet;
    protected final AbstractByteViewerPlugin<?> plugin;
    protected SwingUpdateManager updateManager;
    private Map<String, Class<? extends DataFormatModel>> dataFormatModelClassMap;

    protected ByteViewerComponentProvider(PluginTool tool, AbstractByteViewerPlugin<?> plugin, String name, Class<?> contextType) {
        super(tool, name, plugin.getName(), contextType);
        this.plugin = plugin;
        this.registerAdjustableFontId(DEFAULT_FONT_ID);
        this.initializedDataFormatModelClassMap();
        this.panel = this.newByteViewerPanel();
        this.bytesPerLine = 16;
        this.setIcon((Icon)new GIcon("icon.plugin.byteviewer.provider"));
        this.setOptions();
        this.createActions();
        this.updateManager = new SwingUpdateManager(1000, 3000, () -> this.refreshView());
        this.addView(DEFAULT_VIEW);
        this.setWindowMenuGroup("Byte Viewer");
    }

    protected ByteViewerPanel newByteViewerPanel() {
        return new ByteViewerPanel(this);
    }

    private void initializedDataFormatModelClassMap() {
        this.dataFormatModelClassMap = new HashMap<String, Class<? extends DataFormatModel>>();
        Set<DataFormatModel> models = this.getDataFormatModels();
        for (DataFormatModel model : models) {
            this.dataFormatModelClassMap.put(model.getName(), model.getClass());
        }
    }

    private void createActions() {
        this.editModeAction = new ToggleEditAction(this, this.plugin);
        this.setOptionsAction = new OptionsAction(this, this.plugin);
        this.addLocalAction((DockingActionIf)this.editModeAction);
        this.addLocalAction((DockingActionIf)this.setOptionsAction);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "ByteViewerPlugin");
    }

    protected ByteBlock[] getByteBlocks() {
        return this.blockSet == null ? null : this.blockSet.getBlocks();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (options.getName().equals("ByteViewer")) {
            if (optionName.equals(OPTION_FONT)) {
                this.setFont(SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue)));
            }
        } else if (options.getName().equals("Listing Fields")) {
            if (optionName.equals("Cursor Text Highlight.Mouse Button To Activate")) {
                GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)newValue;
                this.panel.setHighlightButton(mouseButton.getMouseEventID());
            } else if (optionName.equals("Cursor Text Highlight.Highlight Color")) {
                this.panel.setMouseButtonHighlightColor((Color)newValue);
            }
        }
    }

    private void setFont(Font font) {
        FontMetrics fm = this.panel.getFontMetrics(font);
        this.panel.setFontMetrics(fm);
        this.tool.setConfigChanged(true);
    }

    private void setOptions() {
        ToolOptions opt = this.tool.getOptions("ByteViewer");
        HelpLocation help = new HelpLocation("ByteViewerPlugin", "Option");
        opt.setOptionsHelpLocation(help);
        opt.registerThemeColorBinding(SEPARATOR_COLOR_OPTION_NAME, SEPARATOR_COLOR.getId(), help, "Color used for separator shown between memory blocks.");
        opt.registerThemeColorBinding(CHANGED_VALUE_COLOR_OPTION_NAME, CHANGED_VALUE_COLOR.getId(), new HelpLocation("ByteViewerPlugin", "EditColor"), "Color of changed bytes when editing.");
        opt.registerThemeColorBinding(CURSOR_ACTIVE_COLOR_OPTION_NAME, CURSOR_ACTIVE_COLOR.getId(), help, "Color of cursor in the active view.");
        opt.registerThemeColorBinding(CURSOR_NON_ACTIVE_COLOR_OPTION_NAME, CURSOR_NON_ACTIVE_COLOR.getId(), help, "Color of cursor in the non-active views.");
        opt.registerThemeColorBinding(CURSOR_NOT_FOCUSED_COLOR_OPTION_NAME, CURSOR_NOT_FOCUSED_COLOR.getId(), help, "Color of cursor when the byteview does not have focus.");
        opt.registerThemeColorBinding(CURRENT_LINE_COLOR_OPTION_NAME, GhidraOptions.DEFAULT_CURSOR_LINE_COLOR.getId(), help, "Color of the line containing the cursor");
        opt.registerThemeFontBinding(OPTION_FONT, DEFAULT_FONT_ID, help, "Font used in the views.");
        opt.registerOption(OPTION_HIGHLIGHT_CURSOR_LINE, (Object)true, help, "Toggles highlighting background color of line containing the cursor");
        Color separatorColor = opt.getColor(SEPARATOR_COLOR_OPTION_NAME, (Color)SEPARATOR_COLOR);
        this.panel.setSeparatorColor(separatorColor);
        this.panel.setCurrentCursorColor((Color)CURSOR_ACTIVE_COLOR);
        this.panel.setNonFocusCursorColor((Color)CURSOR_NOT_FOCUSED_COLOR);
        this.panel.setCursorColor((Color)CURSOR_NON_ACTIVE_COLOR);
        this.panel.setCurrentCursorLineColor((Color)CURRENT_LINE_COLOR);
        Font font = Gui.getFont((String)DEFAULT_FONT_ID);
        FontMetrics fm = this.panel.getFontMetrics(font);
        this.panel.restoreConfigState(fm, (Color)CHANGED_VALUE_COLOR);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        opt = this.tool.getOptions("Listing Fields");
        GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)opt.getEnum("Cursor Text Highlight.Mouse Button To Activate", (Enum)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE);
        this.panel.setHighlightButton(mouseButton.getMouseEventID());
        this.panel.setMouseButtonHighlightColor(opt.getColor("Cursor Text Highlight.Highlight Color", (Color)GhidraOptions.DEFAULT_HIGHLIGHT_COLOR));
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    void setBlockOffset(int blockOffset) {
        if (blockOffset == this.offset) {
            return;
        }
        int newOffset = blockOffset;
        if (newOffset > this.bytesPerLine) {
            newOffset %= this.bytesPerLine;
        }
        this.offset = newOffset;
        this.panel.setOffset(newOffset);
        this.tool.setConfigChanged(true);
    }

    ByteBlockInfo getCursorLocation() {
        return this.panel.getCursorLocation();
    }

    ByteBlockSelection getBlockSelection() {
        return this.panel.getViewerSelection();
    }

    void setBlockSelection(ByteBlockSelection selection) {
        this.panel.setViewerSelection(selection);
    }

    ByteBlockSet getByteBlockSet() {
        return this.blockSet;
    }

    int getBytesPerLine() {
        return this.bytesPerLine;
    }

    int getOffset() {
        return this.offset;
    }

    Color getCursorColor() {
        return CURSOR_NON_ACTIVE_COLOR;
    }

    int getGroupSize() {
        return this.hexGroupSize;
    }

    void setGroupSize(int groupSize) {
        if (groupSize == this.hexGroupSize) {
            return;
        }
        this.hexGroupSize = groupSize;
        ByteViewerComponent component = this.viewMap.get(DEFAULT_VIEW);
        if (component != null) {
            component.setGroupSize(groupSize);
            component.invalidate();
            this.panel.repaint();
        }
        this.tool.setConfigChanged(true);
    }

    void setBytesPerLine(int bytesPerLine) {
        if (this.bytesPerLine != bytesPerLine) {
            this.bytesPerLine = bytesPerLine;
            this.panel.setBytesPerLine(bytesPerLine);
            this.tool.setConfigChanged(true);
        }
    }

    protected void writeConfigState(SaveState saveState) {
        DataModelInfo info = this.panel.getDataModelInfo();
        saveState.putStrings(VIEW_NAMES, info.getNames());
        saveState.putInt(HEX_VIEW_GROUPSIZE, this.hexGroupSize);
        saveState.putInt(BYTES_PER_LINE_NAME, this.bytesPerLine);
        saveState.putInt(OFFSET_NAME, this.offset);
    }

    protected void readConfigState(SaveState saveState) {
        String[] names = saveState.getStrings(VIEW_NAMES, new String[0]);
        this.hexGroupSize = saveState.getInt(HEX_VIEW_GROUPSIZE, 1);
        this.restoreViews(names, false);
        this.bytesPerLine = saveState.getInt(BYTES_PER_LINE_NAME, 16);
        this.offset = saveState.getInt(OFFSET_NAME, 0);
        this.panel.restoreConfigState(this.bytesPerLine, this.offset);
    }

    private void restoreViews(String[] viewNames, boolean updateViewPosition) {
        for (String viewName : this.viewMap.keySet()) {
            this.removeView(viewName, false);
        }
        for (String viewName : viewNames) {
            DataFormatModel dataFormatModel = this.getDataFormatModel(viewName);
            if (dataFormatModel == null) continue;
            this.addView(dataFormatModel, false, updateViewPosition);
        }
        if (this.viewMap.isEmpty()) {
            this.addView(DEFAULT_VIEW);
        }
    }

    void addView(String modelName) {
        DataFormatModel dataFormatModel = this.getDataFormatModel(modelName);
        if (dataFormatModel != null) {
            this.addView(dataFormatModel, false, true);
        }
    }

    private ByteViewerComponent addView(DataFormatModel model, boolean configChanged, boolean updateViewPosition) {
        if (model.getName().equals(DEFAULT_VIEW)) {
            model.setGroupSize(this.hexGroupSize);
        }
        String viewName = model.getName();
        ByteViewerComponent bvc = this.panel.addView(viewName, model, this.editModeAction.isSelected(), updateViewPosition);
        this.viewMap.put(viewName, bvc);
        if (configChanged) {
            this.tool.setConfigChanged(true);
        }
        return bvc;
    }

    void removeView(String viewName, boolean configChanged) {
        ByteViewerComponent bvc = this.viewMap.remove(viewName);
        if (bvc == null) {
            return;
        }
        this.panel.removeView(bvc);
        if (configChanged) {
            this.tool.setConfigChanged(true);
        }
    }

    protected abstract void updateLocation(ByteBlock var1, BigInteger var2, int var3, boolean var4);

    protected abstract void updateSelection(ByteBlockSelection var1);

    void dispose() {
        this.updateManager.dispose();
        this.updateManager = null;
        if (this.blockSet != null) {
            this.blockSet.dispose();
        }
        this.blockSet = null;
    }

    public Set<String> getCurrentViews() {
        DataModelInfo info = this.panel.getDataModelInfo();
        HashSet<String> currentViewNames = new HashSet<String>(Arrays.asList(info.getNames()));
        return currentViewNames;
    }

    private void refreshView() {
        if (this.tool == null) {
            return;
        }
        if (this.tool.isVisible((ComponentProvider)this)) {
            this.panel.refreshView();
        }
    }

    protected ByteViewerPanel getByteViewerPanel() {
        return this.panel;
    }

    void setStatusMessage(String message) {
        this.plugin.setStatusMessage(message);
    }

    void setEditMode(boolean isEditable) {
        this.panel.setEditMode(isEditable);
    }

    protected Set<DataFormatModel> getDataFormatModels() {
        HashSet<DataFormatModel> set = new HashSet<DataFormatModel>();
        set.addAll(ClassSearcher.getInstances(UniversalDataFormatModel.class));
        return set;
    }

    public List<String> getDataFormatNames() {
        ArrayList<String> names = new ArrayList<String>(this.dataFormatModelClassMap.keySet());
        Collections.sort(names);
        return names;
    }

    public DataFormatModel getDataFormatModel(String formatName) {
        Class<? extends DataFormatModel> classy = this.dataFormatModelClassMap.get(formatName);
        if (classy == null) {
            return null;
        }
        try {
            return classy.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected error loading ByteViewer model formats", (Throwable)e);
            return null;
        }
    }

    public MarkerService getMarkerService() {
        return (MarkerService)this.tool.getService(MarkerService.class);
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.panel.addDisplayListener(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.panel.removeDisplayListener(listener);
    }
}

