/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.satellite;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.layout.ObservableCachingLayout;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import generic.theme.GThemeDefaults;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.renderer.VisualVertexSatelliteRenderer;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.LinkedList;

public class CachingSatelliteGraphViewer<V extends VisualVertex, E extends VisualEdge<V>>
extends SatelliteGraphViewer<V, E> {
    private BufferedImage bufferedBackgroundImage = null;
    private BufferedImage bufferedOverlayImage = null;
    private VisualVertexSatelliteRenderer<V, E> highlightRenderer = new VisualVertexSatelliteRenderer();
    private SwingUpdateManager satelliteUpdateManager = new SwingUpdateManager(750, () -> {
        this.clearCache();
        VisualGraphViewUpdater updater = this.graphViewer.getViewUpdater();
        updater.fitGraphToViewerLater(this);
        this.repaint();
    });

    public CachingSatelliteGraphViewer(GraphViewer<V, E> masterViewer, Dimension preferredSize) {
        super(masterViewer, preferredSize);
        this.preRenderers.clear();
        Layout layout = masterViewer.getGraphLayout();
        if (layout instanceof ObservableCachingLayout) {
            ObservableCachingLayout cachingLayout = (ObservableCachingLayout)layout;
            cachingLayout.addChangeListener(e -> this.satelliteUpdateManager.updateNow());
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.clearCache();
        super.setBounds(x, y, width, height);
    }

    @Override
    public Renderer.Vertex<V, E> getPreferredVertexRenderer() {
        return new VisualVertexSatelliteRenderer<V, E>(){

            @Override
            protected void paintHighlight(RenderContext<V, E> rc, V vertex, GraphicsDecorator g, Rectangle bounds) {
            }
        };
    }

    private void clearCache() {
        this.bufferedBackgroundImage = null;
        this.bufferedOverlayImage = null;
    }

    private void refreshBufferedImageAsNeeded(Graphics g) {
        if (this.bufferedBackgroundImage != null && this.bufferedOverlayImage != null) {
            return;
        }
        this.bufferedBackgroundImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics = (Graphics2D)this.bufferedBackgroundImage.getGraphics();
        this.setBackground(this.options.getGraphBackgroundColor());
        this.renderGraph(graphics);
        graphics.dispose();
        this.bufferedOverlayImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        graphics = (Graphics2D)this.bufferedOverlayImage.getGraphics();
        this.setBackground((Color)GThemeDefaults.Colors.Palette.WHITE);
        this.renderGraph(graphics);
        this.setBackground(this.options.getGraphBackgroundColor());
        graphics.dispose();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(this.renderingHints);
        this.refreshBufferedImageAsNeeded(g);
        g.drawImage(this.bufferedBackgroundImage, 0, 0, null);
        MultiLayerTransformer myMultiLayerTransformer = this.renderContext.getMultiLayerTransformer();
        MutableTransformer masterViewTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
        MutableTransformer masterLayoutTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
        MutableTransformer vvLayoutTransformer = myMultiLayerTransformer.getTransformer(Layer.LAYOUT);
        Shape lens = this.master.getBounds();
        lens = masterViewTransformer.inverseTransform(lens);
        lens = masterLayoutTransformer.inverseTransform(lens);
        lens = vvLayoutTransformer.transform(lens);
        Shape lensClip = this.master.getBounds();
        lensClip = myMultiLayerTransformer.getTransformer(Layer.VIEW).transform(lens);
        Shape originalClip = g2d.getClip();
        Rectangle clip = lensClip.getBounds();
        g2d.setClip(clip);
        g2d.drawImage((Image)this.bufferedOverlayImage, 0, 0, null);
        g2d.setClip(originalClip);
        this.paintSelectedVertices(g2d);
    }

    private void paintSelectedVertices(Graphics2D g2d) {
        GraphicsDecorator graphicsContext = this.renderContext.getGraphicsContext();
        if (graphicsContext == null) {
            return;
        }
        Layout layout = this.model.getGraphLayout();
        Graph graph = layout.getGraph();
        Collection vertices = graph.getVertices();
        LinkedList<VisualVertex> selectedVertices = new LinkedList<VisualVertex>();
        for (VisualVertex vertex : vertices) {
            if (!vertex.isSelected()) continue;
            selectedVertices.add(vertex);
        }
        graphicsContext.setDelegate(g2d);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.renderContext.getMultiLayerTransformer().getTransformer(Layer.VIEW).getTransform());
        g2d.setTransform(newXform);
        for (VisualVertex vertex : selectedVertices) {
            this.highlightRenderer.paintVertex(this.renderContext, layout, vertex);
        }
        g2d.setTransform(oldXform);
    }
}

