/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import com.google.common.base.Function;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.MinMaxRowColumn;
import ghidra.graph.viewer.layout.Row;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class LayoutLocationMap<V, E> {
    private int numRows;
    private int numColumns;
    private TreeMap<Integer, Row<V>> rowsByIndex = new TreeMap();
    private TreeMap<Integer, Column> columnsByIndex = new TreeMap();
    private boolean isCondensed = false;
    private GridLocationMap<V, E> gridLocations;

    public LayoutLocationMap(GridLocationMap<V, E> gridLocations, Function<V, Shape> transformer, boolean isCondensed, TaskMonitor monitor) throws CancelledException {
        this.isCondensed = isCondensed;
        this.gridLocations = gridLocations;
        Set<V> vertices = gridLocations.vertices();
        Set<E> edges = gridLocations.edges();
        MinMaxRowColumn minMax = this.getMinMaxRowColumnValues(vertices, edges, monitor);
        this.numRows = minMax.maxRow + 1;
        this.numColumns = minMax.maxCol + 1;
        this.initializeLayoutLocations(transformer, vertices, monitor);
    }

    private LayoutLocationMap() {
    }

    public LayoutLocationMap<V, E> copy() {
        LayoutLocationMap<V, E> map = new LayoutLocationMap<V, E>();
        map.isCondensed = this.isCondensed;
        map.numRows = this.numRows;
        map.numColumns = this.numColumns;
        map.rowsByIndex = new TreeMap<Integer, Row<Row<V>>>(this.rowsByIndex);
        map.columnsByIndex = new TreeMap<Integer, Column>((SortedMap<Integer, Column>)this.columnsByIndex);
        map.gridLocations = this.gridLocations.copy();
        return map;
    }

    public void dispose() {
        this.rowsByIndex.clear();
        this.columnsByIndex.clear();
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public Column col(V v) {
        Integer col = this.gridLocations.col(v);
        return this.doGetColumn(col);
    }

    public Column col(int gridX) {
        return this.doGetColumn(gridX);
    }

    public Column getColumnContaining(int x) {
        Column column = null;
        Collection<Column> values = this.columnsByIndex.values();
        for (Column nextColumn : values) {
            if (x < nextColumn.x) {
                return column;
            }
            column = nextColumn;
        }
        return column;
    }

    private Column doGetColumn(int index) {
        Column column = this.columnsByIndex.get(index);
        if (column == null) {
            column = new Column(index);
            this.columnsByIndex.put(index, column);
        }
        return column;
    }

    public Collection<Column> columns() {
        ArrayList<Column> result = new ArrayList<Column>();
        Collection<Column> values = this.columnsByIndex.values();
        for (Column column : values) {
            result.add(column);
        }
        return result;
    }

    public Collection<Row<V>> rows() {
        ArrayList<Row<V>> results = new ArrayList<Row<V>>();
        Collection<Row<V>> values = this.rowsByIndex.values();
        for (Row<V> row : values) {
            results.add(row);
        }
        return results;
    }

    public Column lastColumn() {
        Map.Entry<Integer, Column> lastEntry = this.columnsByIndex.lastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getValue();
    }

    public Column nextColumn(Column column) {
        Column nextColumn = this.doGetColumn(column.index + 1);
        if (!nextColumn.isInitialized()) {
            nextColumn.x = column.x + column.getPaddedWidth(this.isCondensed);
        }
        return nextColumn;
    }

    public List<Point> articulations(E e) {
        return this.gridLocations.getArticulations(e);
    }

    public Row<V> row(V v) {
        Integer row = this.gridLocations.row(v);
        return this.doGetRow(row);
    }

    public Row<V> lastRow() {
        Map.Entry<Integer, Row<V>> lastEntry = this.rowsByIndex.lastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getValue();
    }

    public Row<V> row(int gridY) {
        return this.doGetRow(gridY);
    }

    private Row<V> doGetRow(int index) {
        Row<V> row = this.rowsByIndex.get(index);
        if (row == null) {
            row = new Row(index);
            this.rowsByIndex.put(index, row);
        }
        return row;
    }

    public int gridX(Column col) {
        return col.index;
    }

    public int gridY(Row<V> row) {
        return row.index;
    }

    public List<Integer> getRowOffsets() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Row<V> row : this.rowsByIndex.values()) {
            list.add(row.y);
        }
        return list;
    }

    public List<Integer> getColOffsets() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Column column : this.columnsByIndex.values()) {
            list.add(column.x);
        }
        return list;
    }

    public boolean isCondensed() {
        return this.isCondensed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\n\trows=" + this.rowsByIndex + "\n\tcolumns=" + this.columnsByIndex + "]";
    }

    private MinMaxRowColumn getMinMaxRowColumnValues(Collection<V> vertices, Collection<E> edges, TaskMonitor monitor) throws CancelledException {
        MinMaxRowColumn minMax = new MinMaxRowColumn();
        for (V v : vertices) {
            int column;
            monitor.checkCancelled();
            int row = this.gridLocations.row(v);
            if (row > minMax.maxRow) {
                minMax.maxRow = row;
            }
            if (row < minMax.minRow) {
                minMax.minRow = row;
            }
            if ((column = this.gridLocations.col(v)) > minMax.maxCol) {
                minMax.maxCol = column;
            }
            if (column >= minMax.minCol) continue;
            minMax.minCol = column;
        }
        for (Object edge : edges) {
            monitor.checkCancelled();
            List<Point> articulations = this.gridLocations.getArticulations(edge);
            if (articulations.isEmpty()) continue;
            for (Point location : articulations) {
                int column;
                int row = location.y;
                if (row > minMax.maxRow) {
                    minMax.maxRow = row;
                }
                if (row < minMax.minRow) {
                    minMax.minRow = row;
                }
                if ((column = location.x) > minMax.maxCol) {
                    minMax.maxCol = column;
                }
                if (column >= minMax.minCol) continue;
                minMax.minCol = column;
            }
        }
        return minMax;
    }

    private void initializeLayoutLocations(Function<V, Shape> transformer, Collection<V> vertices, TaskMonitor monitor) throws CancelledException {
        int i;
        Column column;
        List<Row<V>> gridRows = this.gridLocations.rows();
        for (Row<V> row : gridRows) {
            this.rowsByIndex.put(row.index, row);
        }
        for (Row<V> vertex : vertices) {
            monitor.checkCancelled();
            Row<Row<V>> row = this.row(vertex);
            column = this.col(vertex);
            Shape shape = (Shape)transformer.apply(vertex);
            Rectangle bounds = shape.getBounds();
            if (bounds.width > column.width) {
                column.width = bounds.width;
            }
            if (bounds.height <= row.height) continue;
            row.height = bounds.height;
        }
        int offset = 0;
        int n = this.getRowCount();
        for (i = 0; i < n; ++i) {
            monitor.checkCancelled();
            Row<V> row = this.row(i);
            row.y = offset;
            offset += row.getPaddedHeight(this.isCondensed);
        }
        offset = 0;
        n = this.getColumnCount();
        for (i = 0; i < n; ++i) {
            monitor.checkCancelled();
            column = this.col(i);
            column.x = offset;
            offset += column.getPaddedWidth(this.isCondensed);
        }
    }
}

