/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.FunctionDatabase;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BSimServerInfo
implements Comparable<BSimServerInfo> {
    public static final int DEFAULT_POSTGRES_PORT = 5432;
    public static final int DEFAULT_ELASTIC_PORT = 9200;
    public static final String H2_FILE_EXTENSION = ".mv.db";
    private final DBType dbType;
    private final String host;
    private final int port;
    private final String dbName;
    private String shortDbName;

    public BSimServerInfo(DBType dbType, String host, int port, String dbName) {
        Objects.requireNonNull(dbType, "DBType must be specified");
        this.dbType = dbType;
        if ((dbType == DBType.postgres || dbType == DBType.elastic) && StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("host required");
        }
        this.host = host;
        if (port <= 0) {
            port = -1;
        }
        if (dbType == DBType.postgres && port <= 0) {
            port = 5432;
        }
        if (dbType == DBType.elastic && port <= 0) {
            port = 9200;
        }
        this.port = port;
        if (StringUtils.isEmpty((CharSequence)(dbName = ((String)dbName).trim()))) {
            throw new IllegalArgumentException("Non-empty dbName required");
        }
        if (dbType == DBType.file) {
            if (!((String)(dbName = ((String)dbName).replace("\\", "/"))).startsWith("/") && !BSimServerInfo.isWindowsFilePath((String)dbName) || ((String)dbName).endsWith("/")) {
                throw new IllegalArgumentException("Invalid absolute file path: " + (String)dbName);
            }
            if (!((String)dbName).endsWith(H2_FILE_EXTENSION)) {
                dbName = (String)dbName + H2_FILE_EXTENSION;
            }
        } else if (((String)dbName).contains("/") || ((String)dbName).contains("\\")) {
            throw new IllegalArgumentException("Invalid " + dbType + " dbName: " + (String)dbName);
        }
        this.dbName = dbName;
    }

    public BSimServerInfo(URL url) throws IllegalArgumentException {
        DBType t = null;
        Object path = url.getPath();
        String protocol = url.getProtocol();
        if (protocol.equals("postgresql")) {
            t = DBType.postgres;
            this.host = BSimServerInfo.checkURLField(url.getHost(), "host");
            int p = url.getPort();
            this.port = p <= 0 ? 5432 : p;
        } else if (protocol.equals("https") || protocol.equals("elastic")) {
            t = DBType.elastic;
            this.host = BSimServerInfo.checkURLField(url.getHost(), "host");
            int p = url.getPort();
            this.port = p <= 0 ? 9200 : p;
        } else if (protocol.startsWith("file")) {
            t = DBType.file;
            this.host = null;
            this.port = -1;
            if (!"".equals(url.getHost())) {
                throw new IllegalArgumentException("Remote file URL not supported: " + url);
            }
        } else {
            throw new IllegalArgumentException("Unsupported BSim URL protocol: " + protocol);
        }
        this.dbType = t;
        if (this.dbType == DBType.postgres || this.dbType == DBType.elastic) {
            if (!((String)path).startsWith("/")) {
                throw new IllegalArgumentException("Missing dbName in URL: " + url);
            }
            path = ((String)path).substring(1).strip();
        }
        path = BSimServerInfo.checkURLField((String)path, "path");
        if (this.dbType == DBType.file) {
            if (((String)path).endsWith("/")) {
                throw new IllegalArgumentException("Missing DB filepath in URL: " + url);
            }
            if (!((String)path).endsWith(H2_FILE_EXTENSION)) {
                path = (String)path + H2_FILE_EXTENSION;
            }
        } else if (((String)path).contains("/")) {
            throw new IllegalArgumentException("Invalid dbName in URL: " + (String)path);
        }
        this.dbName = path;
    }

    private static String checkURLField(String val, String name) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new IllegalArgumentException("Invalid " + name + " in URL");
        }
        return val.trim();
    }

    public boolean isWindowsFilePath() {
        return this.dbType == DBType.file && BSimServerInfo.isWindowsFilePath(this.dbName);
    }

    private static boolean isWindowsFilePath(String path) {
        if (path.length() < 4) {
            return false;
        }
        if (!Character.isLetter(path.charAt(0)) || path.charAt(1) != ':') {
            return false;
        }
        char c = path.charAt(2);
        if (c != '/') {
            return false;
        }
        c = path.charAt(3);
        return c != '/';
    }

    public String toURLString() {
        switch (this.dbType) {
            case postgres: {
                return "postgresql://" + this.host + this.getPortString() + "/" + this.dbName;
            }
            case elastic: {
                return "https://" + this.host + this.getPortString() + "/" + this.dbName;
            }
            case file: {
                return "file:" + this.dbName;
            }
        }
        throw new RuntimeException("Unsupported DBType: " + this.dbType);
    }

    private String getPortString() {
        return this.port > 0 ? ":" + Integer.toString(this.port) : "";
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toURLString());
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public String getServerName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getShortDBName() {
        int ix;
        if (this.shortDbName != null) {
            return this.shortDbName;
        }
        this.shortDbName = this.dbName;
        if (this.dbType == DBType.file && (ix = this.dbName.lastIndexOf(47)) >= 0) {
            this.shortDbName = this.dbName.substring(ix + 1);
        }
        return this.shortDbName;
    }

    public int hashCode() {
        return Objects.hash(this.dbName, this.dbType.ordinal(), this.host, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BSimServerInfo) {
            BSimServerInfo other = (BSimServerInfo)obj;
            return Objects.equals(this.dbName, other.dbName) && this.dbType == other.dbType && Objects.equals(this.host, other.host) && this.port == other.port;
        }
        return false;
    }

    public String toString() {
        switch (this.dbType) {
            case file: {
                return this.getShortDBName() + "  (" + this.dbName + ");";
            }
        }
        return this.dbName + "  (" + this.dbType + ": " + this.host + ")";
    }

    public FunctionDatabase getFunctionDatabase(boolean async) {
        return BSimClientFactory.buildClient(this, async);
    }

    @Override
    public int compareTo(BSimServerInfo o) {
        return this.toString().compareTo(o.toString());
    }

    public static enum DBType {
        postgres,
        elastic,
        file;

    }
}

