/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.widgets.EmptyBorderButton;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import resources.Icons;
import utility.function.Callback;

public class FilterWidget
extends JPanel {
    private GhidraComboBox<BSimFilterType> filterComboBox;
    private JPanel contentPanel;
    private BSimFilterType filterType;
    private BSimValueEditor editor;
    private ItemListener comboChangeListener = this::comboChanged;
    private Callback changeListener;

    public FilterWidget(List<BSimFilterType> filterTypes, Consumer<FilterWidget> removeConsumer, Callback changeListener) {
        this.changeListener = changeListener;
        this.filterType = filterTypes.get(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createFilterComboBox(filterTypes), "West");
        this.add(this.buildFilterContentPanel(), "Center");
        this.add(this.buildDeleteButton(removeConsumer), "East");
    }

    public void setFilters(List<BSimFilterType> filters) {
        if (filters == null || filters.isEmpty()) {
            filters = List.of(BSimFilterType.BLANK);
        }
        this.filterComboBox.removeItemListener(this.comboChangeListener);
        DefaultComboBoxModel<BSimFilterType> model = new DefaultComboBoxModel<BSimFilterType>();
        model.addAll(filters);
        this.filterComboBox.setModel(model);
        if (this.filterType == null || !filters.contains(this.filterType)) {
            this.filterType = filters.get(0);
            this.createInputField(this.filterType);
        }
        this.filterComboBox.setSelectedItem((Object)this.filterType);
        this.filterComboBox.addItemListener(this.comboChangeListener);
    }

    public void setFilter(BSimFilterType filter, List<String> values) {
        ComboBoxModel model = this.filterComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            BSimFilterType newFilterType = (BSimFilterType)model.getElementAt(i);
            if (!filter.equals(newFilterType)) continue;
            this.filterComboBox.setSelectedIndex(i);
            this.editor.setValues(values);
            break;
        }
    }

    public BSimFilterType getSelectedFilter() {
        return this.filterType;
    }

    public List<String> getValues() {
        return this.editor.getValues();
    }

    private void createInputField(BSimFilterType filter) {
        this.contentPanel.removeAll();
        this.editor = this.createEditor(filter, null);
        this.contentPanel.add((Component)this.editor.getComponent(), "Center");
        this.revalidate();
    }

    private BSimValueEditor createEditor(BSimFilterType filter, List<String> initialValues) {
        if (filter == null) {
            return null;
        }
        return filter.getEditor(initialValues, this.changeListener);
    }

    private GhidraComboBox<BSimFilterType> createFilterComboBox(List<BSimFilterType> filters) {
        this.filterComboBox = new GhidraComboBox();
        this.setFilters(filters);
        return this.filterComboBox;
    }

    private Component buildDeleteButton(Consumer<FilterWidget> removeConsumer) {
        EmptyBorderButton deleteButton = new EmptyBorderButton(Icons.DELETE_ICON);
        deleteButton.setToolTipText("Delete filter");
        deleteButton.setName("Delete Filter");
        deleteButton.addActionListener(e -> removeConsumer.accept(this));
        return deleteButton;
    }

    private Component buildFilterContentPanel() {
        this.editor = this.createEditor(this.filterType, null);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.contentPanel.add(this.editor.getComponent());
        return this.contentPanel;
    }

    private void comboChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.filterType = (BSimFilterType)e.getItem();
            this.createInputField(this.filterType);
            this.notifyChangeListener();
        }
    }

    private void notifyChangeListener() {
        Swing.runLater(() -> this.changeListener.call());
    }

    public boolean isBlank() {
        return this.filterType.isBlank();
    }

    public boolean hasValidValue() {
        return this.editor.hasValidValues();
    }

    List<BSimFilterType> getChoosableFilterTypes() {
        ComboBoxModel model = this.filterComboBox.getModel();
        ArrayList<BSimFilterType> types = new ArrayList<BSimFilterType>();
        for (int i = 0; i < model.getSize(); ++i) {
            types.add((BSimFilterType)model.getElementAt(i));
        }
        return types;
    }
}

