/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.features.bsim.gui.search.dialog.BSimServerManager;
import ghidra.features.bsim.gui.search.dialog.BSimServerManagerListener;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.program.model.listing.Program;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class BSimServerTableModel
extends GDynamicColumnTableModel<BSimServerInfo, Object> {
    private List<BSimServerInfo> servers;
    private BSimServerManager serverManager;
    private BSimServerManagerListener listener = new BSimServerManagerListener(){

        @Override
        public void serverListChanged() {
            BSimServerTableModel.this.updateServers();
        }
    };

    public BSimServerTableModel(BSimServerManager serverManager) {
        super((ServiceProvider)new ServiceProviderStub());
        this.serverManager = serverManager;
        serverManager.addListener(this.listener);
        this.servers = new ArrayList<BSimServerInfo>(serverManager.getServerInfos());
    }

    public String getName() {
        return "BSim Servers";
    }

    public List<BSimServerInfo> getModelData() {
        return this.servers;
    }

    public boolean isSortable(int columnIndex) {
        return columnIndex != 0;
    }

    protected TableColumnDescriptor<BSimServerInfo> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new DatabaseNameColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new TypeColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new HostColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PortColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ActiveConnectionColumn());
        return descriptor;
    }

    public Object getDataSource() {
        return null;
    }

    private void updateServers() {
        this.servers = new ArrayList<BSimServerInfo>(this.serverManager.getServerInfos());
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.serverManager.removeListener(this.listener);
        super.dispose();
    }

    private class DatabaseNameColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimServerInfo, String> {
        private GColumnRenderer<String> renderer = new AbstractGColumnRenderer<String>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                BSimServerInfo info = (BSimServerInfo)data.getRowObject();
                if (info.getDBType() == BSimServerInfo.DBType.file) {
                    label.setToolTipText(info.getDBName());
                } else {
                    label.setToolTipText("");
                }
                return label;
            }

            public String getFilterString(String value, Settings settings) {
                return value;
            }
        };

        private DatabaseNameColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
            return serverInfo.getShortDBName();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class TypeColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimServerInfo, String> {
        private TypeColumn() {
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
            return serverInfo.getDBType().toString();
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    private class HostColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimServerInfo, String> {
        private HostColumn() {
        }

        public String getColumnName() {
            return "Host";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
            return serverInfo.getServerName();
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    private class PortColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimServerInfo, Integer> {
        private PortColumn() {
        }

        public String getColumnName() {
            return "Port";
        }

        public Integer getValue(BSimServerInfo serverInfo, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
            int port = serverInfo.getPort();
            if (port <= 0) {
                return null;
            }
            return port;
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    private class ActiveConnectionColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimServerInfo, Integer> {
        private ActiveConnectionColumn() {
        }

        public String getColumnName() {
            return "Active Connections";
        }

        public Integer getValue(BSimServerInfo serverInfo, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
            int activeConnections = BSimServerManager.getActiveConnections(serverInfo);
            if (activeConnections < 0) {
                return null;
            }
            return activeConnections;
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }
}

