/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.overview;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.protocol.SimilarityVectorResult;
import ghidra.program.model.address.Address;

public class BSimOverviewRowObject {
    private Address addr;
    private FunctionDescription func;
    private SimilarityVectorResult simvec;
    private double selfsignif;
    private long vectorHash;

    public BSimOverviewRowObject(SimilarityVectorResult result, Address ad, LSHVectorFactory vectorFactory) {
        this.addr = ad;
        this.simvec = result;
        this.func = this.simvec.getBase();
        this.selfsignif = 0.0;
        SignatureRecord sigrec = this.func.getSignatureRecord();
        if (sigrec != null) {
            this.selfsignif = vectorFactory.getSelfSignificance(sigrec.getLSHVector());
        }
        LSHVector lshVector = this.func.getSignatureRecord().getLSHVector();
        this.vectorHash = lshVector.calcUniqueHash();
    }

    public String getFunctionName() {
        return this.func.getFunctionName();
    }

    public Address getFunctionEntryPoint() {
        return this.addr;
    }

    public int getHitCount() {
        return this.simvec.getTotalCount();
    }

    public double getSelfSignificance() {
        return this.selfsignif;
    }

    public long getVectorHash() {
        return this.vectorHash;
    }
}

