/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.AbstractCreateRttiDataModel;
import ghidra.app.cmd.data.rtti.Rtti1Model;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import java.util.ArrayList;
import java.util.List;

public class Rtti2Model
extends AbstractCreateRttiDataModel {
    public static final String DATA_TYPE_NAME = "RTTIBaseClassArray";
    private DataType dataType;
    private DataType simpleIndividualEntryDataType;
    private int entrySize;
    private List<Rtti1Model> rtti1Models;

    public Rtti2Model(Program program, int rtti1Count, Address rtti2Address, DataValidationOptions validationOptions) {
        super(program, rtti1Count, rtti2Address, validationOptions);
        this.simpleIndividualEntryDataType = Rtti2Model.getSimpleIndividualEntryDataType(program);
        this.entrySize = this.simpleIndividualEntryDataType.getLength();
        this.rtti1Models = new ArrayList<Rtti1Model>();
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        Address startAddress = this.getAddress();
        long numEntries = this.getCount();
        Memory memory = program.getMemory();
        if (numEntries == 0L) {
            numEntries = this.getNumEntries(program, startAddress);
        }
        if (numEntries == 0L || !this.validRefData(memory, startAddress)) {
            this.invalid();
        }
        boolean validateReferredToData = this.validationOptions.shouldValidateReferredToData();
        this.validateAllRtti1RefEntries(program, startAddress, numEntries, validateReferredToData);
    }

    private void validateAllRtti1RefEntries(Program program, Address startAddress, long numEntries, boolean validateReferredToData) throws InvalidDataTypeException {
        Memory memory = program.getMemory();
        Address addr = startAddress;
        int ordinal = 0;
        while ((long)ordinal < numEntries && addr != null && this.validRefData(memory, addr)) {
            this.validateRtti1ReferenceEntry(program, validateReferredToData, addr);
            try {
                addr = addr.add((long)this.entrySize);
            }
            catch (AddressOutOfBoundsException e) {
                if ((long)ordinal >= numEntries - 1L) break;
                this.invalid();
                break;
            }
            ++ordinal;
        }
    }

    private void validateRtti1ReferenceEntry(Program program, boolean validateReferredToData, Address addr) throws InvalidDataTypeException {
        Address rtti1Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)addr);
        if (rtti1Address == null) {
            this.invalid();
        }
        Rtti1Model rtti1Model = new Rtti1Model(program, rtti1Address, this.validationOptions);
        this.rtti1Models.add(rtti1Model);
        if (validateReferredToData) {
            rtti1Model.validate();
        } else if (!rtti1Model.isLoadedAndInitializedAddress()) {
            this.rtti1Models.clear();
            this.invalid("Data referencing RTTIBaseClassDescriptor data type isn't a loaded and initialized address " + rtti1Address + ".");
        }
    }

    public static DataType getIndividualEntryDataType(Program program, DataType rtti1Dt) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        return MSDataTypeUtils.is64Bit((Program)program) ? IBO32DataType.createIBO32PointerTypedef((DataType)rtti1Dt) : new PointerDataType(rtti1Dt, (DataTypeManager)dataTypeManager);
    }

    static DataType getSimpleIndividualEntryDataType(Program program) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        return MSDataTypeUtils.is64Bit((Program)program) ? IBO32DataType.dataType : new PointerDataType((DataTypeManager)dataTypeManager);
    }

    public DataType getDataType(Program program) {
        DataType rtti1Dt = Rtti1Model.getDataType(program);
        return this.getDataType(program, rtti1Dt);
    }

    private DataType getDataType(Program program, DataType rtti1Dt) {
        this.setIsDataTypeAlreadyBasedOnCount(true);
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        int numElements = this.getCount();
        if (numElements == 0) {
            numElements = this.getNumEntries(program, this.getAddress());
        }
        if (numElements <= 0) {
            return null;
        }
        DataType individualEntryDataType = Rtti2Model.getIndividualEntryDataType(program, rtti1Dt);
        ArrayDataType array = new ArrayDataType(individualEntryDataType, numElements, rtti1Dt.getLength(), (DataTypeManager)dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)array);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        DataType dt = this.getDataType();
        return dt != null ? dt.getLength() : 0;
    }

    @Override
    public boolean refersToRtti0(Address rtti0Address) {
        long numEntries;
        try {
            this.checkValidity();
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        Program program = this.getProgram();
        long rtti1Count = this.getCount();
        Address rtti2Address = this.getAddress();
        long l = numEntries = rtti1Count != 0L ? rtti1Count : (long)this.getNumEntries(program, rtti2Address);
        if (numEntries == 0L) {
            return false;
        }
        if (this.validationOptions.shouldValidateReferredToData()) {
            for (Rtti1Model rtti1Model : this.rtti1Models) {
                if (!rtti1Model.refersToRtti0(rtti0Address)) continue;
                return true;
            }
            return false;
        }
        Address addr = rtti2Address;
        Memory memory = program.getMemory();
        int ordinal = 0;
        while ((long)ordinal < numEntries && addr != null && this.validRefData(memory, addr)) {
            Address rtti1Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)addr);
            if (rtti1Address == null) {
                return false;
            }
            Rtti1Model rtti1Model = new Rtti1Model(program, rtti1Address, this.validationOptions);
            if (rtti1Model.refersToRtti0(rtti0Address)) {
                return true;
            }
            addr = addr.add(4L);
            ++ordinal;
        }
        return false;
    }

    private int getNumEntries(Program program, Address rtti2Address) {
        Memory memory = program.getMemory();
        Address addr = rtti2Address;
        boolean shouldValidateReferredToData = this.validationOptions.shouldValidateReferredToData();
        int ordinal = 0;
        while (addr != null && this.validRefData(memory, addr)) {
            Address rtti1Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)addr);
            if (rtti1Address == null) {
                return ordinal;
            }
            Rtti1Model rtti1Model = new Rtti1Model(program, rtti1Address, this.validationOptions);
            if (shouldValidateReferredToData) {
                try {
                    rtti1Model.validate();
                }
                catch (InvalidDataTypeException e1) {
                    return ordinal;
                }
            } else if (!rtti1Model.isLoadedAndInitializedAddress()) {
                return ordinal;
            }
            try {
                addr = addr.add((long)this.entrySize);
            }
            catch (AddressOutOfBoundsException e) {
                return ordinal + 1;
            }
            ++ordinal;
        }
        return ordinal;
    }

    private boolean validRefData(Memory memory, Address addr) {
        Program program = memory.getProgram();
        boolean is64Bit = MSDataTypeUtils.is64Bit((Program)program);
        DumbMemBufferImpl refBuffer = new DumbMemBufferImpl(memory, addr);
        Settings settings = this.simpleIndividualEntryDataType.getDefaultSettings();
        Object value = this.simpleIndividualEntryDataType.getValue((MemBuffer)refBuffer, settings, 4);
        if (value instanceof Address) {
            Address address = (Address)value;
            if (is64Bit && program.getImageBase().equals((Object)address)) {
                return false;
            }
            if (!is64Bit && address.getOffset() == 0L) {
                return false;
            }
            return memory.getLoadedAndInitializedAddressSet().contains(address);
        }
        return false;
    }

    public List<String> getBaseClassTypes() throws InvalidDataTypeException {
        ArrayList<String> names = new ArrayList<String>();
        Program program = this.getProgram();
        long rtti1Count = this.getCount();
        int rtti1Index = 0;
        while ((long)rtti1Index < rtti1Count) {
            TypeDescriptorModel rtti0ModelForRtti1;
            String structName;
            Address rtti1Address = this.getRtti1Address(rtti1Index);
            Rtti1Model rtti1Model = new Rtti1Model(program, rtti1Address, this.validationOptions);
            if (this.validationOptions != null) {
                try {
                    rtti1Model.validate();
                }
                catch (Exception e) {
                    this.invalid("Not a valid RTTIBaseClassDescriptor @" + rtti1Address);
                }
            }
            if ((structName = (rtti0ModelForRtti1 = rtti1Model.getRtti0Model()).getDescriptorName()) == null) {
                return new ArrayList<String>();
            }
            names.add(structName);
            ++rtti1Index;
        }
        return names;
    }

    public Address getRtti1Address(int rtti1Index) throws InvalidDataTypeException {
        this.checkValidity();
        Address rtti1Address = this.getAddress().add((long)(rtti1Index * this.entrySize));
        return MSDataTypeUtils.getReferencedAddress((Program)this.getProgram(), (Address)rtti1Address);
    }

    public TypeDescriptorModel getRtti0Model() throws InvalidDataTypeException {
        this.checkValidity();
        if (!this.rtti1Models.isEmpty()) {
            Rtti1Model rtti1Model = this.rtti1Models.get(0);
            return rtti1Model.getRtti0Model();
        }
        throw new InvalidDataTypeException(this.getDefaultInvalidMessage() + " The array needs at least one entry.");
    }

    public Rtti1Model getRtti1Model(int rtti1Index) throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti1Models.get(rtti1Index);
    }
}

