/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emulate;

import generic.stl.ComparableMapSTL;
import generic.stl.IteratorSTL;
import generic.stl.MapSTL;
import generic.stl.Pair;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emulate.BreakCallBack;
import ghidra.pcode.emulate.BreakTable;
import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.pcoderaw.PcodeOpRaw;
import ghidra.program.model.address.Address;

public class BreakTableCallBack
implements BreakTable {
    public static final String DEFAULT_NAME = "*";
    private Emulate emulate;
    private SleighLanguage language;
    private MapSTL<Address, BreakCallBack> addressCallback = new ComparableMapSTL();
    private MapSTL<Long, BreakCallBack> pcodeCallback = new ComparableMapSTL();
    private BreakCallBack defaultPcodeCallback;

    public BreakTableCallBack(SleighLanguage language) {
        this.language = language;
    }

    public void registerPcodeCallback(String name, BreakCallBack func) {
        func.setEmulate(this.emulate);
        if (DEFAULT_NAME.equals(name)) {
            this.defaultPcodeCallback = func;
            return;
        }
        int numUserOps = this.language.getNumberOfUserDefinedOpNames();
        for (int i = 0; i < numUserOps; ++i) {
            if (!name.equals(this.language.getUserDefinedOpName(i))) continue;
            this.pcodeCallback.add((Object)i, (Object)func);
            return;
        }
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < numUserOps; ++i) {
            names.append(this.language.getUserDefinedOpName(i));
            if (i >= numUserOps - 1) continue;
            names.append(", ");
        }
        throw new LowlevelError("Bad userop name: " + name + "\nMust be one of:\n" + names);
    }

    public void unregisterPcodeCallback(String name) {
        if (DEFAULT_NAME.equals(name)) {
            this.defaultPcodeCallback = null;
            return;
        }
        int numUserOps = this.language.getNumberOfUserDefinedOpNames();
        for (int i = 0; i < numUserOps; ++i) {
            if (!name.equals(this.language.getUserDefinedOpName(i))) continue;
            this.pcodeCallback.remove((Object)i);
            return;
        }
        throw new LowlevelError("Bad userop name: " + name);
    }

    public void registerAddressCallback(Address addr, BreakCallBack func) {
        func.setEmulate(this.emulate);
        this.addressCallback.add((Object)addr, (Object)func);
    }

    public void unregisterAddressCallback(Address addr) {
        this.addressCallback.remove((Object)addr);
    }

    @Override
    public void setEmulate(Emulate emu) {
        this.emulate = emu;
        IteratorSTL iter1 = this.addressCallback.begin();
        while (!iter1.isEnd()) {
            ((BreakCallBack)((Pair)iter1.get()).second).setEmulate(emu);
            iter1.increment();
        }
        if (this.defaultPcodeCallback != null) {
            this.defaultPcodeCallback.setEmulate(emu);
        }
        IteratorSTL iter2 = this.pcodeCallback.begin();
        while (!iter2.isEnd()) {
            ((BreakCallBack)((Pair)iter2.get()).second).setEmulate(emu);
            iter2.increment();
        }
    }

    @Override
    public boolean doPcodeOpBreak(PcodeOpRaw curop) {
        long val = curop.getInput(0).getOffset();
        IteratorSTL iter = this.pcodeCallback.find((Object)val);
        if (iter.isEnd()) {
            if (this.defaultPcodeCallback != null) {
                return this.defaultPcodeCallback.pcodeCallback(curop);
            }
            return false;
        }
        return ((BreakCallBack)((Pair)iter.get()).second).pcodeCallback(curop);
    }

    @Override
    public boolean doAddressBreak(Address addr) {
        IteratorSTL iter = this.addressCallback.find((Object)addr);
        if (iter.isEnd()) {
            return false;
        }
        return ((BreakCallBack)((Pair)iter.get()).second).addressCallback(addr);
    }
}

