/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import java.awt.Font;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.BiFunction;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.text.View;

public class CustomToStringCellRenderer<T>
extends AbstractGColumnRenderer<T> {
    public static final DateFormat TIME_FORMAT_24HMSms = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final CustomToStringCellRenderer<Date> TIME_24HMSms = new CustomToStringCellRenderer<Date>(CustomFont.DEFAULT, Date.class, (v, s) -> v == null ? "<null>" : TIME_FORMAT_24HMSms.format((Date)v), false);
    public static final CustomToStringCellRenderer<String> HTML = new CustomToStringCellRenderer<String>(CustomFont.DEFAULT, String.class, (v, s) -> v == null ? "<null>" : v, true);
    public static final CustomToStringCellRenderer<Object> MONO_OBJECT = new CustomToStringCellRenderer<Object>(CustomFont.MONOSPACED, Object.class, (v, s) -> v == null ? "<null>" : v.toString(), false);
    public static final CustomToStringCellRenderer<String> MONO_HTML = new CustomToStringCellRenderer<String>(CustomFont.MONOSPACED, String.class, (v, s) -> v == null ? "<null>" : v, true);
    public static final CustomToStringCellRenderer<Long> MONO_LONG_HEX = new CustomToStringCellRenderer<Long>(CustomFont.MONOSPACED, Long.class, (v, s) -> v == null ? "<null>" : CustomToStringCellRenderer.longToPrefixedHexString(v), false);
    public static final CustomToStringCellRenderer<Long> MONO_ULONG_HEX = new CustomToStringCellRenderer<Long>(CustomFont.MONOSPACED, Long.class, (v, s) -> v == null ? "<null>" : "0x" + Long.toUnsignedString(v, 16), false);
    public static final CustomToStringCellRenderer<BigInteger> MONO_BIG_HEX = new CustomToStringCellRenderer<BigInteger>(CustomFont.MONOSPACED, BigInteger.class, (v, s) -> v == null ? "<null>" : CustomToStringCellRenderer.bigIntToPrefixedHexString(v), false);
    private final CustomFont customFont;
    private final Class<T> cls;
    private final BiFunction<T, Settings, String> toString;
    private final JPanel panelForSize = new JPanel();
    private final BoxLayout layoutForSize = new BoxLayout(this.panelForSize, 1);

    public static String longToPrefixedHexString(long v) {
        return v < 0L ? "-0x" + Long.toString(-v, 16) : "0x" + Long.toString(v, 16);
    }

    public static String bigIntToPrefixedHexString(BigInteger v) {
        return v.signum() < 0 ? "-0x" + v.negate().toString(16) : "0x" + v.toString(16);
    }

    public CustomToStringCellRenderer(Class<T> cls, BiFunction<T, Settings, String> toString, boolean enableHtml) {
        this(null, cls, toString, enableHtml);
    }

    public CustomToStringCellRenderer(CustomFont font, Class<T> cls, BiFunction<T, Settings, String> toString, boolean enableHtml) {
        this.setHTMLRenderingEnabled(enableHtml);
        this.customFont = font;
        this.cls = cls;
        this.toString = toString;
        this.panelForSize.setLayout(this.layoutForSize);
    }

    protected void configureFont(JTable table, TableModel model, int column) {
        this.setFont(this.getCustomFont());
    }

    protected Font getCustomFont() {
        switch (this.customFont) {
            default: {
                return this.defaultFont;
            }
            case MONOSPACED: {
                return this.fixedWidthFont;
            }
            case BOLD: 
        }
        return this.boldFont;
    }

    public String getFilterString(T t, Settings settings) {
        return this.toString.apply(t, settings);
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        this.setText(this.toString.apply(this.cls.cast(data.getValue()), data.getColumnSettings()));
        if (this.isHTMLRenderingEnabled()) {
            this.setVerticalAlignment(1);
        } else {
            this.setVerticalAlignment(0);
        }
        return this;
    }

    public int getRowHeight(int colWidth) {
        View v = (View)this.getClientProperty("html");
        if (v == null) {
            return 0;
        }
        v.setSize(colWidth, 32767.0f);
        return (int)v.getPreferredSpan(1);
    }

    public static enum CustomFont {
        DEFAULT,
        MONOSPACED,
        BOLD;

    }
}

