/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.ImmutableValueBox;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueShape;
import ghidra.trace.database.target.ValueSpace;
import ghidra.trace.database.target.ValueTriple;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.hyper.AbstractHyperBoxQuery;
import ghidra.util.database.spatial.hyper.EuclideanHyperSpace;
import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperDirection;
import java.util.Objects;

public class TraceObjectValueQuery
extends AbstractHyperBoxQuery<ValueTriple, ValueShape, ValueBox, TraceObjectValueQuery> {
    public TraceObjectValueQuery(ValueBox ls, ValueBox us, HyperDirection direction) {
        super((HyperBox)ls, (HyperBox)us, (EuclideanHyperSpace)ls.space(), direction);
    }

    public boolean testData(ValueShape shape) {
        ValueBox bounds = (ValueBox)shape.getBounds();
        if (!((ValueBox)this.ls).contains((ValueTriple)bounds.lCorner())) {
            return false;
        }
        return ((ValueBox)this.us).contains((ValueTriple)bounds.uCorner());
    }

    protected TraceObjectValueQuery create(ValueBox ir1, ValueBox ir2, HyperDirection newDirection) {
        return new TraceObjectValueQuery(ir1, ir2, newDirection);
    }

    public static TraceObjectValueQuery all() {
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)ValueSpace.FULL, (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }

    public static TraceObjectValueQuery canonicalParents(DBTraceObject child, Lifespan lifespan) {
        Objects.requireNonNull(child);
        TraceObjectKeyPath path = child.getCanonicalPath();
        String entryKey = path.isRoot() ? "" : path.key();
        long childKey = child.getKey();
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)new ImmutableValueBox(new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMin(), childKey, entryKey, lifespan.lmin(), ValueSpace.AddressDimension.INSTANCE.absoluteMin()), new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMax(), childKey, entryKey, lifespan.lmax(), ValueSpace.AddressDimension.INSTANCE.absoluteMax())), (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }

    public static TraceObjectValueQuery parents(DBTraceObject child, Lifespan lifespan) {
        Objects.requireNonNull(child);
        long childKey = child.getKey();
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)new ImmutableValueBox(new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMin(), childKey, ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), lifespan.lmin(), ValueSpace.AddressDimension.INSTANCE.absoluteMin()), new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMax(), childKey, ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), lifespan.lmax(), ValueSpace.AddressDimension.INSTANCE.absoluteMax())), (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }

    public static TraceObjectValueQuery values(DBTraceObject parent, Lifespan lifespan) {
        Objects.requireNonNull(parent);
        long parentKey = parent.getKey();
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)new ImmutableValueBox(new ValueTriple(parentKey, ValueSpace.ChildKeyDimension.INSTANCE.absoluteMin(), ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), lifespan.lmin(), ValueSpace.AddressDimension.INSTANCE.absoluteMin()), new ValueTriple(parentKey, ValueSpace.ChildKeyDimension.INSTANCE.absoluteMax(), ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), lifespan.lmax(), ValueSpace.AddressDimension.INSTANCE.absoluteMax())), (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }

    public static TraceObjectValueQuery values(DBTraceObject parent, String minKey, String maxKey, Lifespan lifespan) {
        Objects.requireNonNull(parent);
        long parentKey = parent.getKey();
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)new ImmutableValueBox(new ValueTriple(parentKey, ValueSpace.ChildKeyDimension.INSTANCE.absoluteMin(), minKey, lifespan.lmin(), ValueSpace.AddressDimension.INSTANCE.absoluteMin()), new ValueTriple(parentKey, ValueSpace.ChildKeyDimension.INSTANCE.absoluteMax(), maxKey, lifespan.lmax(), ValueSpace.AddressDimension.INSTANCE.absoluteMax())), (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }

    public static TraceObjectValueQuery intersecting(String minKey, String maxKey, Lifespan lifespan, DBCachedObjectStoreFactory.RecAddress minAddress, DBCachedObjectStoreFactory.RecAddress maxAddress) {
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)new ImmutableValueBox(new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMin(), ValueSpace.ChildKeyDimension.INSTANCE.absoluteMin(), minKey, lifespan.lmin(), minAddress), new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMax(), ValueSpace.ChildKeyDimension.INSTANCE.absoluteMax(), maxKey, lifespan.lmax(), maxAddress)), (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }

    public static TraceObjectValueQuery intersecting(String minKey, String maxKey, Lifespan lifespan, AddressRange range) {
        return TraceObjectValueQuery.intersecting(minKey, maxKey, lifespan, DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)range.getMinAddress()), DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)range.getMaxAddress()));
    }

    public static TraceObjectValueQuery intersecting(Lifespan lifespan, AddressRange range) {
        return TraceObjectValueQuery.intersecting(ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), lifespan, range);
    }

    public static TraceObjectValueQuery at(String entryKey, long snap, Address address) {
        return (TraceObjectValueQuery)AbstractHyperBoxQuery.intersecting((HyperBox)new ImmutableValueBox(new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMin(), ValueSpace.ChildKeyDimension.INSTANCE.absoluteMin(), entryKey, snap, DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)address)), new ValueTriple(ValueSpace.ParentKeyDimension.INSTANCE.absoluteMax(), ValueSpace.ChildKeyDimension.INSTANCE.absoluteMax(), entryKey, snap, DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)address))), (HyperDirection)HyperDirection.DEFAULT, TraceObjectValueQuery::new);
    }
}

