/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import db.StringField;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointLocation;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointSpec;
import ghidra.trace.database.memory.DBTraceObjectMemoryRegion;
import ghidra.trace.database.memory.DBTraceObjectRegister;
import ghidra.trace.database.module.DBTraceObjectModule;
import ghidra.trace.database.module.DBTraceObjectSection;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.stack.DBTraceObjectStack;
import ghidra.trace.database.stack.DBTraceObjectStackFrame;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValPath;
import ghidra.trace.database.target.DBTraceObjectValueData;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.database.target.TraceObjectValueQuery;
import ghidra.trace.database.target.ValueSpace;
import ghidra.trace.database.target.visitors.AllPathsVisitor;
import ghidra.trace.database.target.visitors.AncestorsRelativeVisitor;
import ghidra.trace.database.target.visitors.AncestorsRootVisitor;
import ghidra.trace.database.target.visitors.CanonicalSuccessorsRelativeVisitor;
import ghidra.trace.database.target.visitors.OrderedSuccessorsVisitor;
import ghidra.trace.database.target.visitors.SuccessorsRelativeVisitor;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.database.thread.DBTraceObjectThread;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.memory.TraceObjectRegister;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.DuplicateKeyException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceObject
extends DBAnnotatedObject
implements TraceObject {
    protected static final String TABLE_NAME = "Objects";
    private static final int VALUE_CACHE_SIZE = 50;
    protected static final Map<Class<? extends TraceObjectInterface>, Function<DBTraceObject, ? extends TraceObjectInterface>> CTORS = Map.ofEntries(DBTraceObject.safeEntry(TraceObjectThread.class, DBTraceObjectThread::new), DBTraceObject.safeEntry(TraceObjectMemoryRegion.class, DBTraceObjectMemoryRegion::new), DBTraceObject.safeEntry(TraceObjectModule.class, DBTraceObjectModule::new), DBTraceObject.safeEntry(TraceObjectSection.class, DBTraceObjectSection::new), DBTraceObject.safeEntry(TraceObjectBreakpointSpec.class, DBTraceObjectBreakpointSpec::new), DBTraceObject.safeEntry(TraceObjectBreakpointLocation.class, DBTraceObjectBreakpointLocation::new), DBTraceObject.safeEntry(TraceObjectStack.class, DBTraceObjectStack::new), DBTraceObject.safeEntry(TraceObjectStackFrame.class, DBTraceObjectStackFrame::new), DBTraceObject.safeEntry(TraceObjectRegister.class, DBTraceObjectRegister::new));
    static final String PATH_COLUMN_NAME = "Path";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedField(column="Path", codec=ObjectPathDBFieldCodec.class, indexed=true)
    private TraceObjectKeyPath path;
    protected final DBTraceObjectManager manager;
    private Map<Class<? extends TraceObjectInterface>, TraceObjectInterface> ifaces;
    private final Map<String, InternalTraceObjectValue> valueCache = new LinkedHashMap<String, InternalTraceObjectValue>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, InternalTraceObjectValue> eldest) {
            return this.size() > 50;
        }
    };
    private final Map<String, Long> nullCache = new LinkedHashMap<String, Long>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
            return this.size() > 50;
        }
    };
    private CachedLifespanValues cachedLifespanValues = null;
    private volatile Lifespan.MutableLifeSet cachedLife = null;

    protected static <T extends TraceObjectInterface> Map.Entry<Class<? extends T>, Function<DBTraceObject, ? extends T>> safeEntry(Class<T> cls, Function<DBTraceObject, ? extends T> ctor) {
        return Map.entry(cls, ctor);
    }

    public DBTraceObject(DBTraceObjectManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            return;
        }
        if (this.path != null) {
            this.freshIfaces();
        }
    }

    public String toString() {
        return "TraceObject: " + this.getCanonicalPath();
    }

    protected void freshIfaces() {
        if (this.ifaces != null) {
            return;
        }
        Set targetIfaces = this.getTargetSchema().getInterfaces();
        this.ifaces = CTORS.entrySet().stream().filter(e -> targetIfaces.contains(TraceObjectInterfaceUtils.toTargetIf((Class)e.getKey()))).collect(Collectors.toUnmodifiableMap(e -> (Class)e.getKey(), e -> (TraceObjectInterface)((Function)e.getValue()).apply(this)));
    }

    protected void set(TraceObjectKeyPath path) {
        this.path = path;
        this.update(PATH_COLUMN);
        this.freshIfaces();
    }

    @Override
    public DBTrace getTrace() {
        return this.manager.trace;
    }

    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getRoot() {
        return this.manager.getRootObject();
    }

    @Override
    public TraceObjectKeyPath getCanonicalPath() {
        try (LockHold hold = this.manager.trace.lockRead();){
            TraceObjectKeyPath traceObjectKeyPath = this.path;
            return traceObjectKeyPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lifespan.LifeSet getLife() {
        LockHold hold = this.manager.trace.lockRead();
        if (this.cachedLife != null) {
            Lifespan.MutableLifeSet mutableLifeSet = this.cachedLife;
            synchronized (mutableLifeSet) {
                Lifespan.DefaultLifeSet defaultLifeSet = Lifespan.DefaultLifeSet.copyOf(this.cachedLife);
                return defaultLifeSet;
            }
        }
        Lifespan.DefaultLifeSet result = new Lifespan.DefaultLifeSet();
        this.getCanonicalParents(Lifespan.ALL).forEach(v -> result.add(v.getLifespan()));
        this.cachedLife = result;
        Lifespan.DefaultLifeSet defaultLifeSet = result;
        synchronized (defaultLifeSet) {
            Lifespan.DefaultLifeSet defaultLifeSet2 = Lifespan.DefaultLifeSet.copyOf(result);
            return defaultLifeSet2;
        }
        finally {
            if (hold != null) {
                hold.close();
            }
        }
    }

    protected DBTraceObject doCreateCanonicalParentObject() {
        return this.manager.doCreateObject(this.path.parent());
    }

    protected DBTraceObject doGetCanonicalParentObject() {
        return this.manager.doGetObject(this.path.parent());
    }

    protected DBTraceObjectValPath doInsert(Lifespan lifespan, TraceObject.ConflictResolution resolution) {
        if (this.path.isRoot()) {
            return DBTraceObjectValPath.of();
        }
        DBTraceObject parent = this.doCreateCanonicalParentObject();
        InternalTraceObjectValue value = parent.setValue(lifespan, this.path.key(), this, resolution);
        DBTraceObjectValPath path = parent.doInsert(lifespan, resolution);
        return path.append(value);
    }

    @Override
    public DBTraceObjectValPath insert(Lifespan lifespan, TraceObject.ConflictResolution resolution) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            DBTraceObjectValPath dBTraceObjectValPath = this.doInsert(lifespan, resolution);
            return dBTraceObjectValPath;
        }
    }

    protected void doRemove(Lifespan span) {
        if (this.isRoot()) {
            throw new IllegalArgumentException("Cannot remove the root object");
        }
        DBTraceObject parent = this.doGetCanonicalParentObject();
        parent.setValue(span, this.path.key(), null);
    }

    @Override
    public void remove(Lifespan span) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.doRemove(span);
        }
    }

    protected void doRemoveTree(Lifespan span) {
        for (InternalTraceObjectValue internalTraceObjectValue : this.getParents(span)) {
            internalTraceObjectValue.doTruncateOrDeleteAndEmitLifeChange(span);
        }
        for (InternalTraceObjectValue internalTraceObjectValue : this.getValues(span)) {
            internalTraceObjectValue.doTruncateOrDeleteAndEmitLifeChange(span);
            if (!internalTraceObjectValue.isCanonical()) continue;
            internalTraceObjectValue.getChild().doRemoveTree(span);
        }
    }

    @Override
    public void removeTree(Lifespan span) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.doRemoveTree(span);
        }
    }

    @Override
    public TraceObjectValue getCanonicalParent(long snap) {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.isRoot()) {
                DBTraceObjectValueData dBTraceObjectValueData = this.manager.getRootValue();
                return dBTraceObjectValueData;
            }
            TraceObjectValue traceObjectValue = (TraceObjectValue)this.manager.valueMap.reduce(TraceObjectValueQuery.canonicalParents(this, Lifespan.at(snap))).firstValue();
            return traceObjectValue;
        }
    }

    public Stream<? extends InternalTraceObjectValue> getCanonicalParents(Lifespan lifespan) {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.isRoot()) {
                Stream<DBTraceObjectValueData> stream = Stream.of(this.manager.getRootValue());
                return stream;
            }
            List list = List.copyOf(this.manager.valueMap.reduce(TraceObjectValueQuery.canonicalParents(this, lifespan)).values());
            Stream stream = list.stream();
            return stream;
        }
    }

    @Override
    public boolean isRoot() {
        try (LockHold hold = this.manager.trace.lockRead();){
            boolean bl = this.path.isRoot();
            return bl;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getAllPaths(Lifespan span) {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.isRoot()) {
                Stream<DBTraceObjectValPath> stream = Stream.of(DBTraceObjectValPath.of());
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = this.doStreamVisitor(span, AllPathsVisitor.INSTANCE);
            return stream;
        }
    }

    @Override
    public Collection<Class<? extends TraceObjectInterface>> getInterfaces() {
        Set targetIfs = this.getTargetSchema().getInterfaces();
        return CTORS.keySet().stream().filter(iface -> targetIfs.contains(TraceObjectInterfaceUtils.toTargetIf(iface))).collect(Collectors.toSet());
    }

    @Override
    public <I extends TraceObjectInterface> I queryInterface(Class<I> ifCls) {
        return (I)((TraceObjectInterface)ifCls.cast(this.ifaces.get(ifCls)));
    }

    protected Collection<? extends InternalTraceObjectValue> doGetParents(Lifespan lifespan) {
        return List.copyOf(this.manager.valueMap.reduce(TraceObjectValueQuery.parents(this, lifespan)).values());
    }

    public Collection<? extends InternalTraceObjectValue> getParents(Lifespan lifespan) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.doGetParents(lifespan);
            return collection;
        }
    }

    protected boolean doHasAnyValues() {
        return !this.manager.valueMap.reduce(TraceObjectValueQuery.values(this, Lifespan.ALL)).isEmpty();
    }

    protected Collection<? extends InternalTraceObjectValue> doGetValues(Lifespan lifespan) {
        return this.manager.valueMap.reduce((TraceObjectValueQuery)TraceObjectValueQuery.values(this, lifespan).starting(ValueSpace.EntryKeyDimension.FORWARD)).values();
    }

    protected Collection<? extends InternalTraceObjectValue> cachedDoGetValues(Lifespan lifespan) {
        if (Long.compareUnsigned(lifespan.lmax() - lifespan.lmin(), 10L) > 0) {
            return List.copyOf(this.doGetValues(lifespan));
        }
        if (this.cachedLifespanValues == null || !this.cachedLifespanValues.span.encloses(lifespan)) {
            long max;
            long min = lifespan.lmin() - 10L;
            if (min > lifespan.lmin()) {
                min = Lifespan.ALL.lmin();
            }
            if ((max = lifespan.lmax() + 10L) < lifespan.lmax()) {
                max = Lifespan.ALL.lmax();
            }
            Lifespan expanded = Lifespan.span(min, max);
            this.cachedLifespanValues = new CachedLifespanValues(expanded, new HashSet<InternalTraceObjectValue>(this.doGetValues(expanded)));
        }
        return this.cachedLifespanValues.values.stream().filter(v -> v.getLifespan().intersects(lifespan)).toList();
    }

    protected boolean doHasAnyParents() {
        return !this.manager.valueMap.reduce(TraceObjectValueQuery.parents(this, Lifespan.ALL)).isEmpty();
    }

    protected boolean doIsConnected() {
        return this.doHasAnyParents() || this.doHasAnyValues();
    }

    public Collection<? extends InternalTraceObjectValue> getValues(Lifespan lifespan) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.cachedDoGetValues(lifespan);
            return collection;
        }
    }

    public Collection<? extends InternalTraceObjectValue> getElements(Lifespan lifespan) {
        return this.getValues(lifespan).stream().filter(v -> PathUtils.isIndex((String)v.getEntryKey())).toList();
    }

    public Collection<? extends InternalTraceObjectValue> getAttributes(Lifespan lifespan) {
        return this.getValues(lifespan).stream().filter(v -> PathUtils.isName((String)v.getEntryKey())).toList();
    }

    protected void doCheckConflicts(Lifespan span, String key, Object value) {
        for (InternalTraceObjectValue internalTraceObjectValue : this.doGetValues(span, key, true)) {
            if (Objects.equals(value, internalTraceObjectValue.getValue())) continue;
            throw new DuplicateKeyException(key);
        }
    }

    protected Lifespan doAdjust(Lifespan span, String key, Object value) {
        for (InternalTraceObjectValue internalTraceObjectValue : this.doGetValues(span, key, true)) {
            if (Objects.equals(value, internalTraceObjectValue.getValue()) || internalTraceObjectValue.getLifespan().contains((Long)span.min())) continue;
            return span.withMax(internalTraceObjectValue.getMinSnap() - 1L);
        }
        return span;
    }

    protected Collection<? extends InternalTraceObjectValue> doGetValues(Lifespan span, String key, boolean forward) {
        return this.manager.valueMap.reduce((TraceObjectValueQuery)TraceObjectValueQuery.values(this, key, key, span).starting(forward ? ValueSpace.SnapDimension.FORWARD : ValueSpace.SnapDimension.BACKWARD)).orderedValues();
    }

    public Collection<? extends InternalTraceObjectValue> getValues(Lifespan span, String key) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.doGetValues(span, key, true);
            return collection;
        }
    }

    @Override
    public InternalTraceObjectValue getValue(long snap, String key) {
        try (LockHold hold = this.manager.trace.lockRead();){
            InternalTraceObjectValue cached = this.valueCache.get(key);
            if (cached != null && !cached.isDeleted() && cached.getLifespan().contains(snap)) {
                InternalTraceObjectValue internalTraceObjectValue = cached;
                return internalTraceObjectValue;
            }
            Long nullSnap = this.nullCache.get(key);
            if (nullSnap != null && nullSnap == snap) {
                InternalTraceObjectValue internalTraceObjectValue = null;
                return internalTraceObjectValue;
            }
            InternalTraceObjectValue found = (InternalTraceObjectValue)this.manager.valueMap.reduce(TraceObjectValueQuery.values(this, key, key, Lifespan.at(snap))).firstValue();
            if (found == null) {
                this.nullCache.put(key, snap);
            } else {
                this.valueCache.put(key, found);
            }
            InternalTraceObjectValue internalTraceObjectValue = found;
            return internalTraceObjectValue;
        }
    }

    public Stream<? extends InternalTraceObjectValue> getOrderedValues(Lifespan span, String key, boolean forward) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends InternalTraceObjectValue> stream = this.doGetValues(span, key, forward).stream();
            return stream;
        }
    }

    @Override
    public InternalTraceObjectValue getElement(long snap, String index) {
        return this.getValue(snap, PathUtils.makeKey((String)index));
    }

    @Override
    public InternalTraceObjectValue getElement(long snap, long index) {
        return this.getElement(snap, PathUtils.makeIndex((long)index));
    }

    @Override
    public TraceObjectValue getAttribute(long snap, String name) {
        if (!PathUtils.isName((String)name)) {
            throw new IllegalArgumentException("name cannot be an index");
        }
        return this.getValue(snap, name);
    }

    protected Stream<? extends TraceObjectValPath> doStreamVisitor(Lifespan span, TreeTraversal.Visitor visitor) {
        return TreeTraversal.INSTANCE.walkObject(visitor, this, span, DBTraceObjectValPath.of());
    }

    @Override
    public Stream<? extends TraceObjectValPath> getAncestors(Lifespan span, PathPredicates relativePredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> ancestors = this.doStreamVisitor(span, new AncestorsRelativeVisitor(relativePredicates));
            if (relativePredicates.matches(List.of())) {
                Stream<? extends TraceObjectValPath> stream = Stream.concat(Stream.of(DBTraceObjectValPath.of()), ancestors);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = ancestors;
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getAncestorsRoot(Lifespan span, PathPredicates rootPredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> stream = this.doStreamVisitor(span, new AncestorsRootVisitor(rootPredicates));
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getSuccessors(Lifespan span, PathPredicates relativePredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> succcessors = this.doStreamVisitor(span, new SuccessorsRelativeVisitor(relativePredicates));
            if (relativePredicates.matches(List.of())) {
                Stream<? extends TraceObjectValPath> stream = Stream.concat(Stream.of(DBTraceObjectValPath.of()), succcessors);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = succcessors;
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getOrderedSuccessors(Lifespan span, TraceObjectKeyPath relativePath, boolean forward) {
        DBTraceObjectValPath empty = DBTraceObjectValPath.of();
        try (LockHold hold = this.manager.trace.lockRead();){
            if (relativePath.isRoot()) {
                Stream<DBTraceObjectValPath> stream = Stream.of(empty);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = this.doStreamVisitor(span, new OrderedSuccessorsVisitor(relativePath, forward));
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getCanonicalSuccessors(PathPredicates relativePredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> successors = this.doStreamVisitor(Lifespan.ALL, new CanonicalSuccessorsRelativeVisitor(relativePredicates));
            if (relativePredicates.matches(List.of())) {
                Stream<? extends TraceObjectValPath> stream = Stream.concat(Stream.of(DBTraceObjectValPath.of()), successors);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = successors;
            return stream;
        }
    }

    protected InternalTraceObjectValue doCreateValue(Lifespan lifespan, String key, Object value) {
        Long nullSnap = this.nullCache.get(key);
        if (nullSnap != null && lifespan.contains(nullSnap)) {
            this.nullCache.remove(key);
        }
        return this.manager.doCreateValue(lifespan, this, key, value);
    }

    @Override
    public InternalTraceObjectValue setValue(Lifespan lifespan, final String key, Object value, TraceObject.ConflictResolution resolution) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            if (this.isDeleted()) {
                throw new IllegalStateException("Cannot set value on deleted object.");
            }
            if (resolution == TraceObject.ConflictResolution.DENY) {
                this.doCheckConflicts(lifespan, key, value);
            } else if (resolution == TraceObject.ConflictResolution.ADJUST) {
                lifespan = this.doAdjust(lifespan, key, value);
            }
            var setter = new InternalTraceObjectValue.ValueLifespanSetter(lifespan, value){
                DBTraceObject canonicalLifeChanged;
                {
                    super(range, value);
                    this.canonicalLifeChanged = null;
                }

                protected Iterable<InternalTraceObjectValue> getIntersecting(Long lower, Long upper) {
                    return Collections.unmodifiableCollection(DBTraceObject.this.doGetValues(Lifespan.span(lower, upper), key, true));
                }

                @Override
                protected void remove(InternalTraceObjectValue entry) {
                    if (entry.isCanonical()) {
                        this.canonicalLifeChanged = entry.getChild();
                    }
                    super.remove(entry);
                }

                @Override
                protected InternalTraceObjectValue put(Lifespan range, Object value) {
                    InternalTraceObjectValue entry = super.put(range, value);
                    if (entry != null && entry.isCanonical()) {
                        this.canonicalLifeChanged = entry.getChild();
                    }
                    return entry;
                }

                @Override
                protected InternalTraceObjectValue create(Lifespan range, Object value) {
                    return DBTraceObject.this.doCreateValue(range, key, value);
                }
            };
            InternalTraceObjectValue result = (InternalTraceObjectValue)setter.set(lifespan, value);
            DBTraceObject child = setter.canonicalLifeChanged;
            if (child != null) {
                child.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(Trace.TraceObjectChangeType.LIFE_CHANGED, null, child));
            }
            InternalTraceObjectValue internalTraceObjectValue = result;
            return internalTraceObjectValue;
        }
    }

    @Override
    public TraceObjectValue setValue(Lifespan lifespan, String key, Object value) {
        return this.setValue(lifespan, key, value, TraceObject.ConflictResolution.TRUNCATE);
    }

    @Override
    public TraceObjectValue setAttribute(Lifespan lifespan, String name, Object value) {
        if (!PathUtils.isName((String)name)) {
            throw new IllegalArgumentException("Attribute name must not be an index");
        }
        return this.setValue(lifespan, name, value);
    }

    @Override
    public TraceObjectValue setElement(Lifespan lifespan, String index, Object value) {
        return this.setValue(lifespan, PathUtils.makeKey((String)index), value);
    }

    @Override
    public TraceObjectValue setElement(Lifespan lifespan, long index, Object value) {
        return this.setElement(lifespan, PathUtils.makeIndex((long)index), value);
    }

    @Override
    public TargetObjectSchema getTargetSchema() {
        return this.manager.rootSchema.getSuccessorSchema(this.path.getKeyList());
    }

    @Override
    public Stream<? extends TraceObjectValPath> queryAncestorsTargetInterface(Lifespan span, Class<? extends TargetObject> targetIf) {
        PathMatcher matcher = this.getManager().getRootSchema().searchFor(targetIf, false);
        return this.getAncestorsRoot(span, (PathPredicates)matcher);
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryAncestorsInterface(Lifespan span, Class<I> ifClass) {
        return this.queryAncestorsTargetInterface(span, TraceObjectInterfaceUtils.toTargetIf(ifClass)).map(p -> p.getSource(this).queryInterface(ifClass));
    }

    public TraceObject queryOrCreateCanonicalAncestorTargetInterface(Class<? extends TargetObject> targetIf) {
        PathMatcher matcher = this.getManager().getRootSchema().searchFor(targetIf, false);
        return this.path.streamMatchingAncestry((PathPredicates)matcher).limit(1L).map(kp -> this.manager.createObject((TraceObjectKeyPath)kp)).findAny().orElseThrow();
    }

    public <I extends TraceObjectInterface> I queryOrCreateCanonicalAncestorInterface(Class<I> ifClass) {
        return this.queryOrCreateCanonicalAncestorTargetInterface(TraceObjectInterfaceUtils.toTargetIf(ifClass)).queryInterface(ifClass);
    }

    @Override
    public Stream<? extends TraceObject> queryCanonicalAncestorsTargetInterface(Class<? extends TargetObject> targetIf) {
        PathMatcher matcher = this.getManager().getRootSchema().searchFor(targetIf, false);
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<DBTraceObject> stream = this.path.streamMatchingAncestry((PathPredicates)matcher).map(kp -> this.manager.getObjectByCanonicalPath((TraceObjectKeyPath)kp));
            return stream;
        }
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryCanonicalAncestorsInterface(Class<I> ifClass) {
        return this.queryCanonicalAncestorsTargetInterface(TraceObjectInterfaceUtils.toTargetIf(ifClass)).map(o -> o.queryInterface(ifClass));
    }

    private boolean isActuallyInterface(TraceObjectValPath path, Class<? extends TargetObject> targetIf) {
        TraceObjectValue lastEntry = path.getLastEntry();
        if (lastEntry == null) {
            return this.getTargetSchema().getInterfaces().contains(targetIf);
        }
        if (!lastEntry.isObject()) {
            return false;
        }
        return lastEntry.getChild().getTargetSchema().getInterfaces().contains(targetIf);
    }

    @Override
    public Stream<? extends TraceObjectValPath> querySuccessorsTargetInterface(Lifespan span, Class<? extends TargetObject> targetIf, boolean requireCanonical) {
        PathMatcher matcher = this.getTargetSchema().searchFor(targetIf, requireCanonical);
        return this.getSuccessors(span, (PathPredicates)matcher).filter(p -> this.isActuallyInterface((TraceObjectValPath)p, targetIf));
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> querySuccessorsInterface(Lifespan span, Class<I> ifClass, boolean requireCanonical) {
        return this.querySuccessorsTargetInterface(span, TraceObjectInterfaceUtils.toTargetIf(ifClass), requireCanonical).map(p -> p.getDestination(this).queryInterface(ifClass));
    }

    protected void doDelete() {
        this.manager.doDeleteObject(this);
    }

    protected void doDeleteReferringValues() {
        for (InternalTraceObjectValue internalTraceObjectValue : this.getValues(Lifespan.ALL)) {
            internalTraceObjectValue.doDeleteAndEmit();
        }
        for (InternalTraceObjectValue internalTraceObjectValue : this.getParents(Lifespan.ALL)) {
            internalTraceObjectValue.doDeleteAndEmit();
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.doDeleteReferringValues();
            this.doDelete();
        }
    }

    protected void emitEvents(TraceChangeRecord<?, ?> rec) {
        this.manager.trace.setChanged(rec);
        for (TraceObjectInterface iface : this.ifaces.values()) {
            DBTraceObjectInterface dbIface = (DBTraceObjectInterface)iface;
            try {
                TraceChangeRecord<?, ?> evt = dbIface.translateEvent(rec);
                if (evt == null) continue;
                this.manager.trace.setChanged(evt);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Error while translating event " + rec + " for interface " + iface + ":" + t));
            }
        }
    }

    protected void notifyValueCreated(InternalTraceObjectValue value) {
        if (this.cachedLifespanValues != null && this.cachedLifespanValues.span.intersects(value.getLifespan())) {
            this.cachedLifespanValues.values.add(value);
        }
    }

    protected void notifyValueDeleted(InternalTraceObjectValue value) {
        if (this.cachedLifespanValues != null) {
            this.cachedLifespanValues.values.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParentValueCreated(InternalTraceObjectValue parent) {
        if (this.cachedLife != null && parent.isCanonical()) {
            Lifespan.MutableLifeSet mutableLifeSet = this.cachedLife;
            synchronized (mutableLifeSet) {
                this.cachedLife.add(parent.getLifespan());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParentValueDeleted(InternalTraceObjectValue parent) {
        if (this.cachedLife != null && parent.isCanonical()) {
            Lifespan.MutableLifeSet mutableLifeSet = this.cachedLife;
            synchronized (mutableLifeSet) {
                this.cachedLife.remove(parent.getLifespan());
            }
        }
    }

    record CachedLifespanValues(Lifespan span, Set<InternalTraceObjectValue> values) {
    }

    protected static final class ObjectPathDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<TraceObjectKeyPath, DBAnnotatedObject, StringField> {
        public ObjectPathDBFieldCodec(Class<DBAnnotatedObject> objectType, Field field, int column) {
            super(TraceObjectKeyPath.class, objectType, StringField.class, field, column);
        }

        protected String encode(TraceObjectKeyPath value) {
            return value == null ? null : value.toString();
        }

        protected TraceObjectKeyPath decode(String path) {
            return TraceObjectKeyPath.parse(path);
        }

        public void store(TraceObjectKeyPath value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(DBAnnotatedObject obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setString(this.column, this.encode((TraceObjectKeyPath)this.getValue(obj)));
        }

        protected void doLoad(DBAnnotatedObject obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, this.decode(record.getString(this.column)));
        }
    }
}

