/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemoryBlock;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpaceInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class DBTraceProgramViewMemoryRegionBlock
extends AbstractDBTraceProgramViewMemoryBlock {
    private final TraceMemoryRegion region;

    public DBTraceProgramViewMemoryRegionBlock(DBTraceProgramView program, TraceMemoryRegion region) {
        super(program);
        this.region = region;
    }

    @Override
    protected String getInfoDescription() {
        return "Trace region: " + this.region;
    }

    @Override
    protected AddressSpace getAddressSpace() {
        return this.region.getRange().getAddressSpace();
    }

    @Override
    public AddressRange getAddressRange() {
        return this.region.getRange();
    }

    public void setPermissions(boolean read, boolean write, boolean execute) {
        this.region.setRead(read);
        this.region.setWrite(write);
        this.region.setExecute(execute);
    }

    public int getPermissions() {
        int bits = 0;
        for (TraceMemoryFlag flag : this.region.getFlags()) {
            bits |= flag.getBits();
        }
        return bits;
    }

    @Override
    public InputStream getData() {
        AddressRange range = this.region.getRange();
        DBTraceMemorySpace space = this.program.trace.getMemoryManager().getMemorySpace(range.getAddressSpace(), false);
        if (space == null) {
            return null;
        }
        return new TraceMemorySpaceInputStream(this.program, space, range);
    }

    public Address getStart() {
        return this.region.getRange().getMinAddress();
    }

    public Address getEnd() {
        return this.region.getRange().getMaxAddress();
    }

    @Override
    public long getSize() {
        return this.region.getRange().getLength();
    }

    @Override
    public BigInteger getSizeAsBigInteger() {
        return this.region.getRange().getBigLength();
    }

    public String getName() {
        return this.region.getName();
    }

    public void setName(String name) throws LockException {
        this.region.setName(name);
    }

    public boolean isRead() {
        return this.region.isRead();
    }

    public void setRead(boolean r) {
        this.region.setRead(r);
    }

    public boolean isWrite() {
        return this.region.isWrite();
    }

    public void setWrite(boolean w) {
        this.region.setWrite(w);
    }

    public boolean isExecute() {
        return this.region.isExecute();
    }

    public void setExecute(boolean e) {
        this.region.setExecute(e);
    }

    public boolean isVolatile() {
        return this.region.isVolatile();
    }

    public void setVolatile(boolean v) {
        this.region.setVolatile(v);
    }
}

