/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceTimeViewport;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapOcclusionIntoPastIterable;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.memory.DBTraceMemBuffer;
import ghidra.trace.database.memory.DBTraceMemoryBlockEntry;
import ghidra.trace.database.memory.DBTraceMemoryBufferEntry;
import ghidra.trace.database.memory.DBTraceMemoryManager;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.memory.DBTraceMemoryStateEntry;
import ghidra.trace.database.memory.InternalTraceMemoryOperations;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.AddressIteratorAdapter;
import ghidra.util.ByteBufferUtils;
import ghidra.util.LockHold;
import ghidra.util.MathUtilities;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;

public class DBTraceMemorySpace
implements TraceMemorySpace,
InternalTraceMemoryOperations,
DBTraceSpaceBased {
    public static final int BLOCK_SHIFT = 12;
    public static final int BLOCK_SIZE = 4096;
    public static final int BLOCK_MASK = -4096;
    public static final int DEPENDENT_COMPRESSED_SIZE_TOLERANCE = 1024;
    public static final int BLOCKS_PER_BUFFER = 256;
    protected final DBTraceMemoryManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final TraceThread thread;
    protected final int frameLevel;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceMemoryRegion, DBTraceMemoryRegion> regionMapSpace;
    protected final DBCachedObjectIndex<String, DBTraceMemoryRegion> regionsByPath;
    protected final Collection<TraceMemoryRegion> regionView;
    protected final Map<DBTraceMemoryRegion, DBTraceMemoryRegion> regionCache = new FixedSizeHashMap(10);
    protected final DBTraceAddressSnapRangePropertyMapSpace<TraceMemoryState, DBTraceMemoryStateEntry> stateMapSpace;
    protected final DBCachedObjectStore<DBTraceMemoryBufferEntry> bufferStore;
    protected final DBCachedObjectStore<DBTraceMemoryBlockEntry> blockStore;
    protected final DBCachedObjectIndex<DBTraceUtils.OffsetSnap, DBTraceMemoryBlockEntry> blocksByOffset;
    protected final Map<DBTraceUtils.OffsetSnap, DBTraceMemoryBlockEntry> blockCacheMostRecent = new FixedSizeHashMap(10);
    protected final DBTraceTimeViewport viewport;

    public DBTraceMemorySpace(DBTraceMemoryManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent, TraceThread thread) throws IOException, VersionException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.thread = thread;
        this.frameLevel = ent.getFrameLevel();
        this.lock = manager.getLock();
        this.trace = manager.getTrace();
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        long threadKey = ent.getThreadKey();
        int frameLevel = ent.getFrameLevel();
        this.regionMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceMemoryRegion.tableName(space, threadKey), factory, this.lock, space, thread, frameLevel, DBTraceMemoryRegion.class, (t, s, r) -> new DBTraceMemoryRegion(this, t, s, r));
        this.regionView = Collections.unmodifiableCollection(this.regionMapSpace.values());
        this.regionsByPath = this.regionMapSpace.getUserIndex(String.class, DBTraceMemoryRegion.PATH_COLUMN);
        this.stateMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceMemoryStateEntry.tableName(space, threadKey, frameLevel), factory, this.lock, space, thread, frameLevel, DBTraceMemoryStateEntry.class, DBTraceMemoryStateEntry::new);
        this.bufferStore = factory.getOrCreateCachedStore(DBTraceMemoryBufferEntry.tableName(space, threadKey, frameLevel), DBTraceMemoryBufferEntry.class, (s, r) -> new DBTraceMemoryBufferEntry(dbh, s, r), true);
        this.blockStore = factory.getOrCreateCachedStore(DBTraceMemoryBlockEntry.tableName(space, threadKey, frameLevel), DBTraceMemoryBlockEntry.class, (s, r) -> new DBTraceMemoryBlockEntry(this, s, r), true);
        this.blocksByOffset = this.blockStore.getIndex(DBTraceUtils.OffsetSnap.class, DBTraceMemoryBlockEntry.LOCATION_COLUMN);
        this.viewport = this.trace.createTimeViewport();
    }

    @Override
    public AddressSpace getSpace() {
        return this.space;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public DBTraceMemoryRegion addRegion(String path, Lifespan lifespan, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException, DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            Collection<? extends DBTraceMemoryRegion> conflicts = this.getRegionsIntersecting(lifespan, range);
            if (!conflicts.isEmpty()) {
                throw new TraceOverlappedRegionException(conflicts);
            }
            if (!this.manager.getRegionsWithPathInLifespan(lifespan, path).isEmpty()) {
                throw new DuplicateNameException("A region having path '" + path + "' already exists within an overlapping snap");
            }
            DBTraceMemoryRegion region = this.regionMapSpace.put(new ImmutableTraceAddressSnapRange(range, lifespan), null);
            region.set(path, path, flags);
            this.trace.updateViewsAddRegionBlock(region);
            this.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.ADDED, this, region));
            DBTraceMemoryRegion dBTraceMemoryRegion = region;
            return dBTraceMemoryRegion;
        }
    }

    public Collection<TraceMemoryRegion> getAllRegions() {
        return this.regionView;
    }

    @Override
    public DBTraceMemoryRegion getLiveRegionByPath(long snap, String path) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (DBTraceMemoryRegion region : this.regionCache.keySet()) {
                if (!region.getLifespan().contains(snap) || !path.equals(region.getPath())) continue;
                DBTraceMemoryRegion dBTraceMemoryRegion = region;
                return dBTraceMemoryRegion;
            }
            for (DBTraceMemoryRegion region : this.regionsByPath.get((Object)path)) {
                if (!region.getLifespan().contains(snap)) continue;
                this.regionCache.put(region, region);
                DBTraceMemoryRegion dBTraceMemoryRegion = region;
                return dBTraceMemoryRegion;
            }
            Iterator<DBTraceMemoryRegion> iterator = null;
            return iterator;
        }
    }

    @Override
    public DBTraceMemoryRegion getRegionContaining(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (DBTraceMemoryRegion region : this.regionCache.keySet()) {
                if (!region.getShape().contains(address, snap)) continue;
                DBTraceMemoryRegion dBTraceMemoryRegion = region;
                return dBTraceMemoryRegion;
            }
            DBTraceMemoryRegion region = (DBTraceMemoryRegion)this.regionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).firstValue();
            if (region != null) {
                this.regionCache.put(region, region);
            }
            DBTraceMemoryRegion dBTraceMemoryRegion = region;
            return dBTraceMemoryRegion;
        }
    }

    public Collection<? extends DBTraceMemoryRegion> getRegionsIntersecting(Lifespan lifespan, AddressRange range) {
        return Collections.unmodifiableCollection(this.regionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, lifespan)).values());
    }

    public Collection<? extends DBTraceMemoryRegion> getRegionsAtSnap(long snap) {
        return Collections.unmodifiableCollection(this.regionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.atSnap(snap, this.space)).values());
    }

    @Override
    public AddressSetView getRegionsAddressSet(long snap) {
        return this.getRegionsAddressSetWith(snap, r -> true);
    }

    @Override
    public AddressSetView getRegionsAddressSetWith(long snap, Predicate<TraceMemoryRegion> predicate) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<TraceMemoryRegion>(this.space, this.lock, this.regionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.atSnap(snap, this.space)), predicate);
    }

    void deleteRegion(DBTraceMemoryRegion region) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.regionMapSpace.deleteData(region);
            this.regionCache.remove(region);
            this.trace.updateViewsDeleteRegionBlock(region);
            this.trace.setChanged(new TraceChangeRecord(Trace.TraceMemoryRegionChangeType.DELETED, this, region));
        }
    }

    @Override
    public DBTraceCodeSpace getCodeSpace(boolean createIfAbsent) {
        if (this.space.isRegisterSpace() && !this.space.isOverlaySpace()) {
            return this.trace.getCodeManager().getCodeRegisterSpace(this.thread, this.frameLevel, createIfAbsent);
        }
        return this.trace.getCodeManager().getCodeSpace(this.space, createIfAbsent);
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    protected void doSetState(final long snap, Address start, Address end, TraceMemoryState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        final var l = new Object(){
            boolean changed;
        };
        new DBTraceUtils.AddressRangeMapSetter<Map.Entry<TraceAddressSnapRange, TraceMemoryState>, TraceMemoryState>(){

            protected AddressRange getRange(Map.Entry<TraceAddressSnapRange, TraceMemoryState> entry) {
                return entry.getKey().getRange();
            }

            protected TraceMemoryState getValue(Map.Entry<TraceAddressSnapRange, TraceMemoryState> entry) {
                return entry.getValue();
            }

            protected void remove(Map.Entry<TraceAddressSnapRange, TraceMemoryState> entry) {
                DBTraceMemorySpace.this.stateMapSpace.remove(entry);
            }

            protected Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getIntersecting(Address lower, Address upper) {
                return DBTraceMemorySpace.this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(lower, upper, snap, snap)).entries();
            }

            protected Map.Entry<TraceAddressSnapRange, TraceMemoryState> put(AddressRange range, TraceMemoryState value) {
                l.changed = true;
                if (value != TraceMemoryState.UNKNOWN) {
                    DBTraceMemorySpace.this.stateMapSpace.put(new ImmutableTraceAddressSnapRange(range, snap), value);
                }
                return null;
            }
        }.set(start, end, (Object)state);
        if (l.changed) {
            this.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, TraceMemoryState>(Trace.TraceMemoryStateChangeType.CHANGED, this, new ImmutableTraceAddressSnapRange(start, end, snap, snap), state));
        }
    }

    protected void checkState(TraceMemoryState state) {
    }

    @Override
    public void setState(long snap, Address start, Address end, TraceMemoryState state) {
        this.checkState(state);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.doSetState(snap, start, end, state);
        }
    }

    @Override
    public void setState(long snap, AddressRange range, TraceMemoryState state) {
        this.checkState(state);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.doSetState(snap, range.getMinAddress(), range.getMaxAddress(), state);
        }
    }

    @Override
    public void setState(long snap, Address address, TraceMemoryState state) {
        this.checkState(state);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.doSetState(snap, address, address, state);
        }
    }

    @Override
    public void setState(long snap, AddressSetView set, TraceMemoryState state) {
        this.checkState(state);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (AddressRange range : set) {
                this.doSetState(snap, range.getMinAddress(), range.getMaxAddress(), state);
            }
        }
    }

    @Override
    public TraceMemoryState getState(long snap, Address address) {
        TraceMemoryState state = (TraceMemoryState)((Object)this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).firstValue());
        return state == null ? TraceMemoryState.UNKNOWN : state;
    }

    @Override
    public Map.Entry<Long, TraceMemoryState> getViewState(long snap, Address address) {
        for (Lifespan span : this.viewport.getOrderedSpans(snap)) {
            TraceMemoryState state = this.getState(span.lmax(), address);
            switch (state) {
                case KNOWN: 
                case ERROR: {
                    return Map.entry(span.lmax(), state);
                }
            }
            if (span.lmax() - span.lmin() <= 0L) continue;
            return Map.entry(snap, TraceMemoryState.UNKNOWN);
        }
        return Map.entry(snap, TraceMemoryState.UNKNOWN);
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getMostRecentStateEntry(long snap, Address address) {
        return this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.mostRecent(address, snap)).firstEntry();
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getViewMostRecentStateEntry(long snap, Address address) {
        for (Lifespan span : this.viewport.getOrderedSpans(snap)) {
            Map.Entry entry = this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.mostRecent(address, span)).firstEntry();
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public AddressSetView getAddressesWithState(long snap, Predicate<TraceMemoryState> predicate) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<TraceMemoryState>(this.space, this.lock, this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.atSnap(snap, this.space)), predicate);
    }

    @Override
    public AddressSetView getAddressesWithState(Lifespan lifespan, Predicate<TraceMemoryState> predicate) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<TraceMemoryState>(this.space, this.lock, this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(lifespan, this.space)), predicate);
    }

    @Override
    public AddressSetView getAddressesWithState(Lifespan span, AddressSetView set, Predicate<TraceMemoryState> predicate) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet remains = new AddressSet(set);
            AddressSet result = new AddressSet();
            while (!remains.isEmpty()) {
                AddressRange range = remains.getFirstRange();
                remains.delete(range);
                for (Map.Entry<TraceAddressSnapRange, TraceMemoryState> entry : this.doGetStates(span, range)) {
                    AddressRange foundRange = entry.getKey().getRange();
                    remains.delete(foundRange);
                    if (!predicate.test(entry.getValue())) continue;
                    result.add(foundRange);
                }
            }
            AddressSet addressSet = result;
            return addressSet;
        }
    }

    protected Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> doGetStates(Lifespan span, AddressRange range) {
        if (this.getAddressSpace().isRegisterSpace() && !range.getAddressSpace().isRegisterSpace()) {
            return this.trace.getMemoryManager().doGetStates(span, range);
        }
        return this.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).entries();
    }

    @Override
    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long snap, AddressRange range) {
        this.assertInSpace(range);
        return this.doGetStates(Lifespan.at(snap), range);
    }

    @Override
    public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(TraceAddressSnapRange within) {
        return new DBTraceAddressSnapRangePropertyMapOcclusionIntoPastIterable<TraceMemoryState>(this.stateMapSpace, within);
    }

    protected DBTraceMemoryBlockEntry findMostRecentBlockEntry(DBTraceUtils.OffsetSnap loc, boolean inclusive) {
        DBTraceMemoryBlockEntry ent = null;
        if (!inclusive) {
            loc = new DBTraceUtils.OffsetSnap(loc.offset, loc.snap - 1L);
        }
        if ((ent = this.blockCacheMostRecent.get(loc)) != null) {
            return ent;
        }
        Iterator it = this.blocksByOffset.head((Object)loc, true).descending().values().iterator();
        if (!it.hasNext()) {
            return null;
        }
        ent = (DBTraceMemoryBlockEntry)((Object)it.next());
        if (ent.getOffset() != loc.offset || ent.isScratch() != loc.isScratch()) {
            return null;
        }
        this.blockCacheMostRecent.put(loc, ent);
        return ent;
    }

    protected DBTraceMemoryBlockEntry findSoonestBlockEntry(DBTraceUtils.OffsetSnap loc, boolean inclusive) {
        Iterator it = inclusive ? this.blocksByOffset.tail((Object)loc, true).values().iterator() : this.blocksByOffset.tail((Object)new DBTraceUtils.OffsetSnap(loc.offset, loc.snap + 1L), true).values().iterator();
        if (!it.hasNext()) {
            return null;
        }
        DBTraceMemoryBlockEntry next = (DBTraceMemoryBlockEntry)((Object)it.next());
        if (next.getOffset() != loc.offset || next.isScratch() != loc.isScratch()) {
            return null;
        }
        return next;
    }

    protected void doPutBytes(DBTraceUtils.OffsetSnap loc, ByteBuffer buf, int dstOffset, int maxLen) throws IOException {
        DBTraceMemoryBlockEntry ent = this.findMostRecentBlockEntry(loc, true);
        if (ent != null) {
            if (ent.getSnap() == loc.snap) {
                ent.setBytes(buf, dstOffset, maxLen);
                return;
            }
            if (ent.cmpBytes(buf, dstOffset, maxLen) == 0) {
                buf.position(buf.position() + maxLen);
                return;
            }
            ent = ent.copy(loc);
            ent.setBytes(buf, dstOffset, maxLen);
            return;
        }
        ent = (DBTraceMemoryBlockEntry)this.blockStore.create();
        ent.setLoc(loc);
        this.blockCacheMostRecent.clear();
        this.blockCacheMostRecent.put(loc, ent);
        if (ent.cmpBytes(buf, dstOffset, maxLen) == 0) {
            buf.position(buf.position() + maxLen);
            return;
        }
        ent.setBytes(buf, dstOffset, maxLen);
    }

    protected void doPutFutureBytes(DBTraceUtils.OffsetSnap loc, ByteBuffer buf, int dstOffset, int maxLen, OutSnap lastSnap, Set<TraceAddressSnapRange> changed) throws IOException {
        DBTraceMemoryBlockEntry next;
        int pos = buf.position();
        Iterator it = this.blocksByOffset.tail((Object)new DBTraceUtils.OffsetSnap(loc.offset, loc.snap + 1L), true).values().iterator();
        AddressSet remaining = new AddressSet(this.space.getAddress(loc.offset + (long)dstOffset), this.space.getAddress(loc.offset + (long)dstOffset + (long)maxLen - 1L));
        while (it.hasNext() && (next = (DBTraceMemoryBlockEntry)((Object)it.next())).getOffset() == loc.offset && next.isScratch() == loc.isScratch()) {
            AddressSetView withState = this.getAddressesWithState(next.getSnap(), (AddressSetView)remaining, (TraceMemoryState state) -> true);
            remaining = remaining.subtract(withState);
            long endSnap = next.getSnap() - 1L;
            for (AddressRange rng : withState) {
                changed.add(new ImmutableTraceAddressSnapRange(rng, Lifespan.span(loc.snap, endSnap)));
            }
            if (remaining.isEmpty()) {
                lastSnap.snap = endSnap;
                break;
            }
            for (AddressRange rng : remaining) {
                int subOffset = (int)(rng.getMinAddress().getOffset() - loc.offset);
                buf.position(pos + subOffset - dstOffset);
                next.setBytes(buf, subOffset, (int)rng.getLength());
            }
        }
        if (!remaining.isEmpty()) {
            lastSnap.snap = Long.MAX_VALUE;
            for (AddressRange rng : remaining) {
                changed.add(new ImmutableTraceAddressSnapRange(rng, Lifespan.nowOnMaybeScratch(loc.snap)));
            }
        }
        buf.position(pos);
    }

    protected int doPutBytes(long snap, Address start, ByteBuffer buf, OutSnap lastSnap, Set<TraceAddressSnapRange> changed) throws IOException {
        int result = 0;
        try {
            Address cur = start;
            while (buf.hasRemaining()) {
                long offset = cur.getOffset();
                long roundOffset = offset & 0xFFFFFFFFFFFFF000L;
                int dstOffset = (int)(offset - roundOffset);
                int maxLen = Math.min(4096 - dstOffset, buf.remaining());
                DBTraceUtils.OffsetSnap loc = new DBTraceUtils.OffsetSnap(roundOffset, snap);
                this.doPutFutureBytes(loc, buf, dstOffset, maxLen, lastSnap, changed);
                this.doPutBytes(loc, buf, dstOffset, maxLen);
                result += maxLen;
                cur = cur.addNoWrap((long)maxLen);
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public int putBytes(long snap, Address start, ByteBuffer buf) {
        int n;
        block10: {
            this.assertInSpace(start);
            int pos = buf.position();
            LockHold hold = LockHold.lock((Lock)this.lock.writeLock());
            try {
                ByteBuffer oldBytes = ByteBuffer.allocate(buf.remaining());
                this.getBytes(snap, start, oldBytes);
                OutSnap lastSnap = new OutSnap(snap);
                HashSet<TraceAddressSnapRange> changed = new HashSet<TraceAddressSnapRange>();
                int result = this.doPutBytes(snap, start, buf, lastSnap, changed);
                if (result > 0) {
                    Address end = start.add((long)(result - 1));
                    this.doSetState(snap, start, end, TraceMemoryState.KNOWN);
                    byte[] bytes = new byte[result];
                    buf.get(pos, bytes);
                    ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange(start, start.add((long)(result - 1)), snap, lastSnap.snap);
                    this.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, byte[]>(Trace.TraceMemoryBytesChangeType.CHANGED, this, tasr, oldBytes.array(), bytes));
                    DBTraceCodeSpace codeSpace = (DBTraceCodeSpace)this.trace.getCodeManager().get(this, false);
                    if (codeSpace != null) {
                        codeSpace.bytesChanged(changed, snap, start, oldBytes.array(), bytes);
                    }
                    this.trace.updateViewsBytesChanged(tasr.getRange());
                }
                n = result;
                if (hold == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.blockStore.dbError(e);
                    return 0;
                }
            }
            hold.close();
        }
        return n;
    }

    protected void doGetBytes(DBTraceUtils.OffsetSnap loc, ByteBuffer buf, int srcOffset, int maxLen) throws IOException {
        DBTraceMemoryBlockEntry ent = this.findMostRecentBlockEntry(loc, true);
        if (ent == null) {
            buf.position(buf.position() + maxLen);
        } else {
            ent.getBytes(buf, srcOffset, maxLen);
        }
    }

    @Override
    public int getBytes(long snap, Address start, ByteBuffer buf) {
        this.assertInSpace(start);
        int result = 0;
        try (LockHold hold2 = LockHold.lock((Lock)this.lock.readLock());){
            Address cur = start;
            while (buf.hasRemaining()) {
                long offset = cur.getOffset();
                long roundOffset = offset & 0xFFFFFFFFFFFFF000L;
                int srcOffset = (int)(offset - roundOffset);
                int maxLen = Math.min(4096 - srcOffset, buf.remaining());
                DBTraceUtils.OffsetSnap loc = new DBTraceUtils.OffsetSnap(roundOffset, snap);
                this.doGetBytes(loc, buf, srcOffset, maxLen);
                result += maxLen;
                cur = cur.addNoWrap((long)maxLen);
            }
        }
        catch (AddressOverflowException hold2) {
        }
        catch (IOException e) {
            this.blockStore.dbError(e);
        }
        return result;
    }

    protected int truncateLen(int len, Address start) {
        long maxLen = start.getAddressSpace().getMaxAddress().subtract(start) + 1L;
        if (maxLen == 0L) {
            return len;
        }
        return MathUtilities.unsignedMin((int)len, (long)maxLen);
    }

    @Override
    public int getViewBytes(long snap, Address start, ByteBuffer buf) {
        AddressRangeImpl toRead;
        this.assertInSpace(start);
        int len = this.truncateLen(buf.remaining(), start);
        if (len == 0) {
            return 0;
        }
        try {
            toRead = new AddressRangeImpl(start, (long)len);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
        TreeMap<AddressRange, Long> sources = new TreeMap<AddressRange, Long>();
        AddressSet remains = new AddressSet((AddressRange)toRead);
        block2: for (Lifespan span : this.viewport.getOrderedSpans(snap)) {
            AddressRange rng;
            Iterator arit = this.getAddressesWithState(span, (TraceMemoryState s) -> s == TraceMemoryState.KNOWN).iterator(start, true);
            while (arit.hasNext() && (rng = (AddressRange)arit.next()).getMinAddress().compareTo((Object)toRead.getMaxAddress()) <= 0) {
                for (AddressRange sub : remains.intersectRange(rng.getMinAddress(), rng.getMaxAddress())) {
                    sources.put(sub, span.lmax());
                }
                remains.delete(rng);
                if (!remains.isEmpty()) continue;
                break block2;
            }
        }
        int lim = buf.limit();
        int pos = buf.position();
        for (Map.Entry ent : sources.entrySet()) {
            AddressRange rng = (AddressRange)ent.getKey();
            int offset = (int)rng.getMinAddress().subtract(toRead.getMinAddress());
            int length = (int)rng.getLength();
            buf.limit(pos + offset + length);
            while (buf.position() < pos + offset) {
                buf.put((byte)0);
            }
            int read = this.getBytes((long)((Long)ent.getValue()), rng.getMinAddress(), buf);
            if (read >= length) continue;
            break;
        }
        buf.limit(lim);
        while (buf.position() < pos + len) {
            buf.put((byte)0);
        }
        return len;
    }

    protected Address doFindBytesInRange(long snap, AddressRange range, ByteBuffer data, ByteBuffer mask, boolean forward, TaskMonitor monitor) {
        int len = data.capacity();
        assert (len != 0);
        if (range.getLength() > 0L && range.getLength() < (long)len) {
            return null;
        }
        AddressRangeImpl rangeOfStarts = new AddressRangeImpl(range.getMinAddress(), range.getMaxAddress().subtract((long)(len - 1)));
        ByteBuffer read = ByteBuffer.allocate(len);
        for (Address addr : AddressIteratorAdapter.forRange((AddressRange)rangeOfStarts, (boolean)forward)) {
            monitor.incrementProgress(1L);
            if (monitor.isCancelled()) {
                return null;
            }
            read.clear();
            int l = this.getBytes(snap, addr, read);
            if (l != len || !ByteBufferUtils.maskedEquals((ByteBuffer)mask, (ByteBuffer)data, (ByteBuffer)read)) continue;
            return addr;
        }
        return null;
    }

    @Override
    public Address findBytes(long snap, AddressRange range, ByteBuffer data, ByteBuffer mask, boolean forward, TaskMonitor monitor) {
        int len = data.capacity();
        if (mask != null && mask.capacity() != len) {
            throw new IllegalArgumentException("data and mask must have same capacity");
        }
        if (len == 0 || range.getLength() > 0L && range.getLength() < (long)len) {
            return null;
        }
        AddressSet known = new AddressSet(this.stateMapSpace.getAddressSetView(Lifespan.ALL, s -> s == TraceMemoryState.KNOWN)).intersect((AddressSetView)new AddressSet(range));
        monitor.initialize(known.getNumAddresses());
        for (AddressRange knownRange : known.getAddressRanges(forward)) {
            Address found = this.doFindBytesInRange(snap, knownRange, data, mask, forward, monitor);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected boolean doCheckBytesChanged(DBTraceUtils.OffsetSnap loc, int srcOffset, int maxLen, ByteBuffer eBuf, ByteBuffer pBuf) throws IOException {
        DBTraceMemoryBlockEntry ent = this.findMostRecentBlockEntry(loc, true);
        if (ent == null || ent.getSnap() < loc.snap) {
            return false;
        }
        DBTraceMemoryBlockEntry pre = this.findMostRecentBlockEntry(loc, false);
        int eLen = ent.getBytes(eBuf, srcOffset, maxLen);
        assert (eLen == maxLen);
        eBuf.flip();
        if (pre == null) {
            return !DBTraceMemoryBlockEntry.isZeroes(eBuf, eLen);
        }
        int pLen = pre.getBytes(pBuf, srcOffset, maxLen);
        pBuf.flip();
        assert (eLen == pLen);
        for (int i = 0; i < eLen; ++i) {
            if (eBuf.get(i) == pBuf.get(i)) continue;
            return true;
        }
        return false;
    }

    protected boolean doCheckBytesChanged(long snap, AddressRange range, ByteBuffer buf1, ByteBuffer buf2) throws IOException {
        try {
            Address cur = range.getMinAddress();
            while (cur.compareTo((Object)range.getMaxAddress()) <= 0) {
                int maxLen;
                int srcOffset;
                long offset = cur.getOffset();
                long roundOffset = offset & 0xFFFFFFFFFFFFF000L;
                DBTraceUtils.OffsetSnap loc = new DBTraceUtils.OffsetSnap(roundOffset, snap);
                if (this.doCheckBytesChanged(loc, srcOffset = (int)(offset - roundOffset), maxLen = (int)Math.min((long)(4096 - srcOffset), range.getMaxAddress().subtract(cur) + 1L), buf1, buf2)) {
                    return true;
                }
                cur = cur.addNoWrap((long)maxLen);
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Long getSnapOfMostRecentChangeToBlock(long snap, Address address) {
        this.assertInSpace(address);
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            long offset = address.getOffset();
            long roundOffset = offset & 0xFFFFFFFFFFFFF000L;
            DBTraceUtils.OffsetSnap loc = new DBTraceUtils.OffsetSnap(roundOffset, snap);
            DBTraceMemoryBlockEntry ent = this.findMostRecentBlockEntry(loc, true);
            if (ent == null) {
                Long l = null;
                return l;
            }
            Long l = ent.getSnap();
            return l;
        }
    }

    @Override
    public int getBlockSize() {
        return 4096;
    }

    protected boolean isCross(long lower, long upper) {
        return lower < 0L && upper >= 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFirstChange(Lifespan span, AddressRange range) {
        this.assertInSpace(range);
        long lower = span.lmin();
        long upper = span.lmax();
        if (lower == upper) {
            return Long.MIN_VALUE;
        }
        boolean cross = this.isCross(lower, upper);
        if (cross && lower == -1L) {
            return 0L;
        }
        Lifespan fwdOne = Lifespan.span(lower + 1L, cross ? -1L : upper);
        ByteBuffer buf1 = ByteBuffer.allocate(4096);
        ByteBuffer buf2 = ByteBuffer.allocate(4096);
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (TraceAddressSnapRange tasr : this.stateMapSpace.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, fwdOne).starting(Rectangle2DDirection.BOTTOMMOST)).orderedKeys()) {
                AddressRange toExamine = range.intersect(tasr.getRange());
                if (!this.doCheckBytesChanged(tasr.getY1(), toExamine, buf1, buf2)) continue;
                long l = tasr.getY1();
                return l;
            }
            long l = cross ? 0L : Long.MIN_VALUE;
            return l;
        }
        catch (IOException e) {
            this.blockStore.dbError(e);
            return 0L;
        }
    }

    @Override
    public void removeBytes(long snap, Address start, int len) {
        this.assertInSpace(start);
        if (len <= 0) {
            return;
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            ByteBuffer oldBytes = ByteBuffer.allocate(len);
            this.getBytes(snap, start, oldBytes);
            ByteBuffer newBytes = ByteBuffer.allocate(len);
            if (snap != 0L && snap != Long.MIN_VALUE) {
                this.getBytes(snap - 1L, start, newBytes);
                newBytes.flip();
            }
            OutSnap lastSnap = new OutSnap(snap);
            HashSet<TraceAddressSnapRange> changed = new HashSet<TraceAddressSnapRange>();
            this.doPutBytes(snap, start, newBytes, lastSnap, changed);
            Address end = start.add((long)(len - 1));
            this.doSetState(snap, start, end, TraceMemoryState.UNKNOWN);
            this.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, byte[]>(Trace.TraceMemoryBytesChangeType.CHANGED, this, new ImmutableTraceAddressSnapRange(start, start.add((long)(newBytes.position() - 1)), snap, lastSnap.snap), oldBytes.array(), newBytes.array()));
            DBTraceCodeSpace codeSpace = (DBTraceCodeSpace)this.trace.getCodeManager().get(this, false);
            if (codeSpace != null) {
                codeSpace.bytesChanged(changed, snap, start, oldBytes.array(), newBytes.array());
            }
        }
        catch (IOException e) {
            this.blockStore.dbError(e);
        }
    }

    @Override
    public MemBuffer getBufferAt(long snap, Address start, ByteOrder byteOrder) {
        return new DBTraceMemBuffer(this, snap, start, byteOrder);
    }

    @Override
    public void pack() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceMemoryBufferEntry bufEnt : this.bufferStore.asMap().values()) {
                bufEnt.compress();
            }
        }
        catch (IOException e) {
            this.bufferStore.dbError(e);
        }
    }

    @Override
    public void invalidateCache() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.regionMapSpace.invalidateCache();
            this.regionCache.clear();
            this.trace.updateViewsRefreshBlocks();
            this.trace.updateViewsBytesChanged(null);
            this.stateMapSpace.invalidateCache();
            this.bufferStore.invalidateCache();
            this.blockStore.invalidateCache();
            this.blockCacheMostRecent.clear();
        }
    }

    protected static class OutSnap {
        long snap;

        public OutSnap(long snap) {
            this.snap = snap;
        }
    }
}

