/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBStream;
import SWIG.SBValue;
import SWIG.StateType;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface2.LldbModelTargetRegister;
import agent.lldb.model.iface2.LldbModelTargetStackFrameRegisterBank;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameRegisterContainerImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameRegisterImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="RegisterValueBank", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=LldbModelTargetStackFrameRegisterImpl.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class LldbModelTargetStackFrameRegisterBankImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetStackFrameRegisterBank {
    public static final String NAME = "Registers";
    protected final LldbModelTargetStackFrameRegisterContainerImpl container;

    protected static String keyValue(SBValue value) {
        return PathUtils.makeKey((String)value.GetName());
    }

    public LldbModelTargetStackFrameRegisterBankImpl(LldbModelTargetStackFrameRegisterContainerImpl container, SBValue val) {
        super(container.getModel(), (TargetObject)container, val.GetName(), val, "StackFrameRegisterBank");
        this.container = container;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getName(), "_descriptions", container), "Initialized");
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBValue val = (SBValue)this.getModelObject();
        val.GetDescription(stream);
        return stream.GetData();
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        SBValue bank = (SBValue)this.getModelObject();
        return this.getManager().listStackFrameRegisters(bank).thenAccept(regs -> {
            List registers;
            if (regs.isEmpty()) {
                return;
            }
            LldbModelTargetStackFrameRegisterBankImpl lldbModelTargetStackFrameRegisterBankImpl = this;
            synchronized (lldbModelTargetStackFrameRegisterBankImpl) {
                registers = regs.values().stream().map(this::getTargetRegister).collect(Collectors.toList());
            }
            this.setElements(registers, Map.of(), "Refreshed");
            if (!this.getCachedElements().isEmpty()) {
                this.readRegistersNamed(this.getCachedElements().keySet());
            }
        });
    }

    @Override
    public LldbModelTargetRegister getTargetRegister(SBValue register) {
        TargetObject targetObject = this.getMapObject(register);
        if (targetObject != null) {
            LldbModelTargetRegister targetRegister = (LldbModelTargetRegister)targetObject;
            targetRegister.setModelObject(register);
            return targetRegister;
        }
        return new LldbModelTargetStackFrameRegisterImpl(this, register);
    }

    @Override
    public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        if (state.equals(StateType.eStateStopped)) {
            this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenAccept(__ -> this.readRegistersNamed(this.getCachedElements().keySet()));
        }
    }

    @Override
    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        Map elements = this.getCachedElements();
        for (String regname : names) {
            if (!elements.containsKey(regname)) continue;
            LldbModelTargetStackFrameRegisterImpl register = (LldbModelTargetStackFrameRegisterImpl)elements.get(regname);
            byte[] bytes = register.getBytes();
            result.put(regname, bytes);
        }
        this.broadcast().registersUpdated((TargetObject)this, result);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        Map elements = this.getCachedElements();
        for (Map.Entry<String, byte[]> ent : values.entrySet()) {
            String regname = ent.getKey();
            LldbModelTargetStackFrameRegisterImpl reg = (LldbModelTargetStackFrameRegisterImpl)elements.get(regname);
            if (reg == null) {
                throw new DebuggerRegisterAccessException("No such register: " + regname);
            }
            BigInteger val = new BigInteger(1, ent.getValue());
            reg.getRegister().SetValueFromCString(val.toString());
        }
        this.broadcast().registersUpdated((TargetObject)this.getProxy(), values);
        return AsyncUtils.nil();
    }

    public Object getContainer() {
        return this.container;
    }

    @Override
    public Map<String, byte[]> getCachedRegisters() {
        return LldbModelTargetStackFrameRegisterBank.super.getCachedRegisters();
    }
}

