/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBBreakpoint;
import SWIG.SBStream;
import agent.lldb.model.iface2.LldbModelTargetBreakpointContainer;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.impl.LldbModelTargetAbstractXpointSpec;
import agent.lldb.model.impl.LldbModelTargetBreakpointLocationImpl;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.ListenerSet;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="BreakpointSpec", elements={@TargetElementType(type=LldbModelTargetBreakpointLocationImpl.class)}, attributes={@TargetAttributeType(name="Type", type=String.class), @TargetAttributeType(name="Valid", type=Boolean.class), @TargetAttributeType(name="Enabled", type=Boolean.class), @TargetAttributeType(name="Count", type=Long.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetBreakpointSpecImpl
extends LldbModelTargetAbstractXpointSpec {
    protected final ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = new ListenerSet(TargetBreakpointSpec.TargetBreakpointAction.class, false);

    public LldbModelTargetBreakpointSpecImpl(LldbModelTargetBreakpointContainer breakpoints, Object info) {
        super(breakpoints, info, "BreakpointSpec");
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBBreakpoint bpt = (SBBreakpoint)this.getModelObject();
        bpt.GetDescription(stream);
        return stream.GetData();
    }

    @Override
    protected TargetBreakpointSpecContainer.TargetBreakpointKindSet computeKinds(Object from) {
        if (from instanceof SBBreakpoint) {
            SBBreakpoint bpt = (SBBreakpoint)from;
            return bpt.IsHardware() ? TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE}) : TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE});
        }
        return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of();
    }

    @Override
    public void updateInfo(Object info, String reason) {
        this.setModelObject(info);
        this.updateAttributesFromInfo(reason);
        this.getManager().listBreakpointLocations((SBBreakpoint)info).thenAccept(byNumber -> {
            List locs;
            if (!this.valid) {
                return;
            }
            LldbModelTargetBreakpointSpecImpl lldbModelTargetBreakpointSpecImpl = this;
            synchronized (lldbModelTargetBreakpointSpecImpl) {
                locs = byNumber.values().stream().map(this::getTargetBreakpointLocation).collect(Collectors.toList());
            }
            this.setElements(locs, Map.of(), "Refreshed");
        });
    }

    @Override
    public void updateAttributesFromInfo(String reason) {
        SBBreakpoint bpt = (SBBreakpoint)this.getModelObject();
        String description = this.getDescription(1);
        String[] split = description.split(",");
        if (split[1].contains("regex")) {
            this.expression = split[1];
            this.expression = this.expression.substring(this.expression.indexOf("'") + 1);
            this.expression = this.expression.substring(0, this.expression.indexOf("'"));
        }
        this.display = this.getDescription(0);
        this.kinds = this.computeKinds(bpt);
        this.enabled = bpt.IsEnabled();
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.display, "_kinds", this.kinds, "_enabled", this.enabled, "_expression", ""), reason);
        this.changeAttributes(List.of(), List.of(), Map.of("Type", bpt.IsHardware() ? "Hardware" : "Software", "Enabled", bpt.IsEnabled(), "Valid", bpt.IsValid(), "Count", bpt.GetHitCount()), reason);
        Map cachedElements = this.getCachedElements();
        if (!cachedElements.isEmpty()) {
            Object[] elements = cachedElements.values().toArray();
            LldbModelTargetBreakpointLocationImpl loc = (LldbModelTargetBreakpointLocationImpl)elements[0];
            this.changeAttributes(List.of(), List.of(), Map.of("_range", loc.range), reason);
        }
    }

    @Override
    public ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> getActions() {
        return this.actions;
    }

    @Override
    public LldbModelTargetBreakpointLocation findLocation(Object obj) {
        if (!(obj instanceof BigInteger)) {
            return null;
        }
        BigInteger id = (BigInteger)obj;
        for (LldbModelTargetBreakpointLocation bp : this.breaksBySub.values()) {
            if (bp.getLocationId() != id.intValue()) continue;
            return bp;
        }
        return null;
    }
}

