/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.lldb.DebugThreadInfo;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbProcessCreatedEvent;
import agent.lldb.manager.evt.LldbStoppedEvent;
import agent.lldb.manager.evt.LldbThreadCreatedEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.LinkedHashSet;
import java.util.Set;

public class LldbRemoteConnectionCommand
extends AbstractLldbCommand<Set<SBThread>> {
    private LldbProcessCreatedEvent created = null;
    private boolean completed = false;
    private String key;
    private boolean auto = true;
    private boolean async = false;
    private boolean kernel = false;

    public LldbRemoteConnectionCommand(LldbManagerImpl manager, String key) {
        this(manager, key, true, false, false);
    }

    public LldbRemoteConnectionCommand(LldbManagerImpl manager, String key, boolean auto, boolean async, boolean kernel) {
        super(manager);
        this.key = key;
        this.auto = auto;
        this.async = async;
        this.kernel = kernel;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof LldbProcessCreatedEvent) {
            this.created = (LldbProcessCreatedEvent)evt;
        } else if (evt instanceof LldbThreadCreatedEvent) {
            pending.claim(evt);
        } else if (evt instanceof LldbStoppedEvent) {
            pending.claim(evt);
        }
        return this.completed && this.created != null;
    }

    @Override
    public Set<SBThread> complete(LldbPendingCommand<?> pending) {
        LinkedHashSet<SBThread> threads = new LinkedHashSet<SBThread>();
        for (LldbThreadCreatedEvent adds : pending.findAllOf(LldbThreadCreatedEvent.class)) {
            DebugThreadInfo info = (DebugThreadInfo)adds.getInfo();
            threads.add(info.thread);
        }
        return threads;
    }

    @Override
    public void invoke() {
        DebugClient client = this.manager.getClient();
        client.connectRemote(client.getLocalServer(), this.key, this.auto, this.async, this.kernel);
    }
}

