/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbProcessCreatedEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.Map;

public class LldbOpenDumpCommand
extends AbstractLldbCommand<SBThread> {
    private LldbProcessCreatedEvent created = null;
    private boolean completed = false;
    private Map<String, ?> args;

    public LldbOpenDumpCommand(LldbManagerImpl manager, Map<String, ?> args) {
        super(manager);
        this.args = args;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof LldbProcessCreatedEvent) {
            this.created = (LldbProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public SBThread complete(LldbPendingCommand<?> pending) {
        return null;
    }

    @Override
    public void invoke() {
        String f = (String)this.args.get("TraceOrDump");
        if (f.startsWith("/")) {
            f = f.substring(1);
        }
        f = f.replace("/", "\\");
        DebugClient client = this.manager.getClient();
        client.openDumpFileWide(f);
        this.manager.waitForEventEx();
    }
}

