/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class GotoStack
extends AssignAction {
    private ParamEntry stackEntry = null;

    private void initializeEntry() throws InvalidInputException {
        for (int i = 0; i < this.resource.getNumParamEntry(); ++i) {
            ParamEntry entry = this.resource.getEntry(i);
            if (entry.isExclusion() || !entry.getSpace().isStackSpace()) continue;
            this.stackEntry = entry;
            break;
        }
        if (this.stackEntry == null) {
            throw new InvalidInputException("Cannot find matching <pentry> for action: gotostack");
        }
    }

    protected GotoStack(ParamListStandard res, int val) {
        super(res);
    }

    public GotoStack(ParamListStandard res) throws InvalidInputException {
        super(res);
        this.initializeEntry();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new GotoStack(newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        GotoStack otherAction = (GotoStack)op;
        return this.stackEntry.isEquivalent(otherAction.stackEntry);
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        int grp = this.stackEntry.getGroup();
        res.type = dt;
        status[grp] = this.stackEntry.getAddrBySlot(status[grp], dt.getLength(), dt.getAlignment(), res);
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_GOTO_STACK);
        encoder.closeElement(ElementId.ELEM_GOTO_STACK);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_GOTO_STACK.name()});
        parser.end(elem);
        try {
            this.initializeEntry();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

