/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.theme.GIcon;
import ghidra.program.model.data.Playable;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Icon;

public class AudioPlayer
implements Playable,
LineListener {
    private static final Icon AUDIO_ICON = new GIcon("icon.data.type.audio.player");
    private static volatile Clip currentClip;
    private byte[] bytes;

    public AudioPlayer(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public Icon getImageIcon() {
        return AUDIO_ICON;
    }

    @Override
    public void clicked(MouseEvent event) {
        if (currentClip != null) {
            currentClip.stop();
            currentClip = null;
            return;
        }
        try (AudioInputStream stream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.bytes));){
            Clip clip;
            currentClip = clip = AudioSystem.getClip();
            clip.addLineListener(this);
            clip.open(stream);
            clip.start();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            Msg.debug((Object)this, (Object)"Unable to play audio", (Throwable)e);
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type eventType = event.getType();
        if (eventType != LineEvent.Type.STOP && eventType != LineEvent.Type.CLOSE) {
            return;
        }
        Object object = event.getSource();
        if (object instanceof Clip) {
            Clip clip = (Clip)object;
            clip.removeLineListener(this);
            clip.close();
            Swing.runNow(() -> {
                if (currentClip == clip) {
                    currentClip = null;
                }
            });
        }
    }
}

