/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block.graph;

import ghidra.program.model.block.CodeBlock;

public class CodeBlockVertex
implements Comparable<CodeBlockVertex> {
    private final CodeBlock codeBlock;
    private final String name;

    public CodeBlockVertex(CodeBlock codeBlock) {
        this.codeBlock = codeBlock;
        this.name = codeBlock.getName();
    }

    public CodeBlockVertex(String name) {
        this.codeBlock = null;
        this.name = name;
    }

    public CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDummy() {
        return this.codeBlock == null;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(CodeBlockVertex o) {
        if (this.codeBlock == null) {
            return 1;
        }
        if (o.codeBlock == null) {
            return -1;
        }
        return this.codeBlock.getMinAddress().compareTo(o.codeBlock.getMinAddress());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeBlockVertex)) {
            return false;
        }
        CodeBlockVertex o = (CodeBlockVertex)obj;
        if (this.codeBlock == null && o.codeBlock == null) {
            return true;
        }
        if (this.codeBlock == null || o.codeBlock == null) {
            return false;
        }
        return this.codeBlock.getMinAddress().equals(o.codeBlock.getMinAddress());
    }

    public int hashCode() {
        if (this.codeBlock == null) {
            return 0;
        }
        return this.codeBlock.getMinAddress().hashCode();
    }
}

